/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.QuadCurve2D;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.NoSuchElementException;

class QuadIterator
implements PathIterator {
    QuadCurve2D quad;
    BaseTransform transform;
    int index;

    QuadIterator(QuadCurve2D q, BaseTransform tx) {
        this.quad = q;
        this.transform = tx;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(float[] coords) {
        int type;
        if (this.isDone()) {
            throw new NoSuchElementException("quad iterator iterator out of bounds");
        }
        if (this.index == 0) {
            coords[0] = this.quad.x1;
            coords[1] = this.quad.y1;
            type = 0;
        } else {
            coords[0] = this.quad.ctrlx;
            coords[1] = this.quad.ctrly;
            coords[2] = this.quad.x2;
            coords[3] = this.quad.y2;
            type = 2;
        }
        if (this.transform != null) {
            this.transform.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
        }
        return type;
    }
}

