/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.prism.Image;
import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class MultiTexture
implements Texture {
    private int width;
    private int height;
    private PixelFormat format;
    private Texture.WrapMode wrapMode;
    private boolean linearFiltering = true;
    private final ArrayList<Texture> textures;
    private int lastImageSerial;

    public MultiTexture(PixelFormat format, Texture.WrapMode wrapMode, int width, int height) {
        this.width = width;
        this.height = height;
        this.format = format;
        this.wrapMode = wrapMode;
        this.textures = new ArrayList(4);
    }

    private MultiTexture(MultiTexture sharedTex, Texture.WrapMode newMode) {
        this(sharedTex.format, newMode, sharedTex.width, sharedTex.height);
        for (int i = 0; i < sharedTex.textureCount(); ++i) {
            Texture t = sharedTex.getTexture(i);
            this.setTexture(t.getSharedTexture(newMode), i);
        }
        this.linearFiltering = sharedTex.linearFiltering;
        this.lastImageSerial = sharedTex.lastImageSerial;
    }

    @Override
    public Texture getSharedTexture(Texture.WrapMode altMode) {
        this.assertLocked();
        if (this.wrapMode == altMode) {
            this.lock();
            return this;
        }
        switch (altMode) {
            case REPEAT: {
                if (this.wrapMode == Texture.WrapMode.CLAMP_TO_EDGE) break;
                return null;
            }
            case CLAMP_TO_EDGE: {
                if (this.wrapMode == Texture.WrapMode.REPEAT) break;
                return null;
            }
            default: {
                return null;
            }
        }
        MultiTexture altTex = new MultiTexture(this, altMode);
        altTex.lock();
        return altTex;
    }

    public int textureCount() {
        return this.textures.size();
    }

    public void setTexture(Texture tex, int index) {
        if (!tex.getWrapMode().isCompatibleWith(this.wrapMode)) {
            throw new IllegalArgumentException("texture wrap mode must match multi-texture mode");
        }
        if (this.textures.size() < index + 1) {
            for (int ii = this.textures.size(); ii < index; ++ii) {
                this.textures.add(null);
            }
            this.textures.add(tex);
        } else {
            this.textures.set(index, tex);
        }
        tex.setLinearFiltering(this.linearFiltering);
    }

    public Texture getTexture(int index) {
        return this.textures.get(index);
    }

    public Texture[] getTextures() {
        return this.textures.toArray(new Texture[this.textures.size()]);
    }

    public void removeTexture(Texture tex) {
        this.textures.remove(tex);
    }

    public void removeTexture(int index) {
        this.textures.remove(index);
    }

    @Override
    public PixelFormat getPixelFormat() {
        return this.format;
    }

    @Override
    public int getPhysicalWidth() {
        return this.width;
    }

    @Override
    public int getPhysicalHeight() {
        return this.height;
    }

    @Override
    public int getContentX() {
        return 0;
    }

    @Override
    public int getContentY() {
        return 0;
    }

    @Override
    public int getContentWidth() {
        return this.width;
    }

    @Override
    public int getContentHeight() {
        return this.height;
    }

    @Override
    public int getLastImageSerial() {
        return this.lastImageSerial;
    }

    @Override
    public void setLastImageSerial(int serial) {
        this.lastImageSerial = serial;
    }

    @Override
    public void update(Image img) {
        throw new UnsupportedOperationException("Update from Image not supported");
    }

    @Override
    public void update(Image img, int dstx, int dsty) {
        throw new UnsupportedOperationException("Update from Image not supported");
    }

    @Override
    public void update(Image img, int dstx, int dsty, int srcw, int srch) {
        throw new UnsupportedOperationException("Update from Image not supported");
    }

    @Override
    public void update(Image img, int dstx, int dsty, int srcw, int srch, boolean skipFlush) {
        throw new UnsupportedOperationException("Update from Image not supported");
    }

    @Override
    public void update(Buffer buffer, PixelFormat format, int dstx, int dsty, int srcx, int srcy, int srcw, int srch, int srcscan, boolean skipFlush) {
        throw new UnsupportedOperationException("Update from generic Buffer not supported");
    }

    @Override
    public void update(MediaFrame frame, boolean skipFlush) {
        if (frame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            int encWidth = frame.getEncodedWidth();
            int encHeight = frame.getEncodedHeight();
            for (int index = 0; index < frame.planeCount(); ++index) {
                Texture tex = this.textures.get(index);
                if (null == tex) continue;
                int texWidth = encWidth;
                int texHeight = encHeight;
                if (index == 2 || index == 1) {
                    texWidth /= 2;
                    texHeight /= 2;
                }
                ByteBuffer pixels = frame.getBufferForPlane(index);
                tex.update(pixels, PixelFormat.BYTE_ALPHA, 0, 0, 0, 0, texWidth, texHeight, frame.strideForPlane(index), skipFlush);
            }
        } else {
            throw new IllegalArgumentException("Invalid pixel format in MediaFrame");
        }
    }

    @Override
    public Texture.WrapMode getWrapMode() {
        return this.wrapMode;
    }

    @Override
    public boolean getUseMipmap() {
        return false;
    }

    @Override
    public boolean getLinearFiltering() {
        return this.linearFiltering;
    }

    @Override
    public void setLinearFiltering(boolean linear) {
        this.linearFiltering = linear;
        for (Texture tex : this.textures) {
            tex.setLinearFiltering(linear);
        }
    }

    @Override
    public void lock() {
        for (Texture tex : this.textures) {
            tex.lock();
        }
    }

    @Override
    public void unlock() {
        for (Texture tex : this.textures) {
            tex.unlock();
        }
    }

    @Override
    public boolean isLocked() {
        for (Texture tex : this.textures) {
            if (!tex.isLocked()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getLockCount() {
        int count = 0;
        for (Texture tex : this.textures) {
            count = Math.max(count, tex.getLockCount());
        }
        return count;
    }

    @Override
    public void assertLocked() {
        for (Texture tex : this.textures) {
            tex.assertLocked();
        }
    }

    @Override
    public void makePermanent() {
        for (Texture tex : this.textures) {
            tex.makePermanent();
        }
    }

    @Override
    public void contentsUseful() {
        for (Texture tex : this.textures) {
            tex.contentsUseful();
        }
    }

    @Override
    public void contentsNotUseful() {
        for (Texture tex : this.textures) {
            tex.contentsNotUseful();
        }
    }

    @Override
    public boolean isSurfaceLost() {
        for (Texture tex : this.textures) {
            if (!tex.isSurfaceLost()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        for (Texture tex : this.textures) {
            tex.dispose();
        }
        this.textures.clear();
    }

    @Override
    public int getMaxContentWidth() {
        return this.getPhysicalWidth();
    }

    @Override
    public int getMaxContentHeight() {
        return this.getPhysicalHeight();
    }

    @Override
    public void setContentWidth(int contentWidth) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setContentHeight(int contentHeight) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

