/*
 * Decompiled with CFR 0.152.
 */
package javafx.application;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.tk.Toolkit;
import java.util.Optional;
import javafx.application.ConditionalFeature;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.scene.input.KeyCode;

public final class Platform {
    private static ReadOnlyBooleanWrapper accessibilityActiveProperty;

    private Platform() {
    }

    public static void runLater(Runnable runnable) {
        PlatformImpl.runLater(runnable);
    }

    public static boolean isFxApplicationThread() {
        return PlatformImpl.isFxApplicationThread();
    }

    public static void exit() {
        PlatformImpl.exit();
    }

    public static void setImplicitExit(boolean implicitExit) {
        PlatformImpl.setImplicitExit(implicitExit);
    }

    public static boolean isImplicitExit() {
        return PlatformImpl.isImplicitExit();
    }

    public static boolean isSupported(ConditionalFeature feature) {
        return PlatformImpl.isSupported(feature);
    }

    public static Optional<Boolean> isKeyLocked(KeyCode keyCode) {
        Toolkit.getToolkit().checkFxUserThread();
        switch (keyCode) {
            case CAPS: 
            case NUM_LOCK: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid KeyCode");
            }
        }
        return Toolkit.getToolkit().isKeyLocked(keyCode);
    }

    public static boolean isAccessibilityActive() {
        return accessibilityActiveProperty == null ? false : accessibilityActiveProperty.get();
    }

    public static ReadOnlyBooleanProperty accessibilityActiveProperty() {
        if (accessibilityActiveProperty == null) {
            accessibilityActiveProperty = new ReadOnlyBooleanWrapper(Platform.class, "accessibilityActive");
            accessibilityActiveProperty.bind(PlatformImpl.accessibilityActiveProperty());
        }
        return accessibilityActiveProperty.getReadOnlyProperty();
    }
}

