/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.collections.VetoableListDecorator;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.control.Toggle;

public class ToggleGroup {
    private final ObservableList<Toggle> toggles = new VetoableListDecorator<Toggle>((ObservableList)new TrackableObservableList<Toggle>(){

        @Override
        protected void onChanged(ListChangeListener.Change<Toggle> c) {
            block0: while (c.next()) {
                List<Toggle> addedToggles = c.getAddedSubList();
                for (Toggle t : c.getRemoved()) {
                    if (t.isSelected()) {
                        ToggleGroup.this.selectToggle(null);
                    }
                    if (addedToggles.contains(t)) continue;
                    t.setToggleGroup(null);
                }
                for (Toggle t : addedToggles) {
                    if (ToggleGroup.this.equals(t.getToggleGroup())) continue;
                    if (t.getToggleGroup() != null) {
                        t.getToggleGroup().getToggles().remove(t);
                    }
                    t.setToggleGroup(ToggleGroup.this);
                }
                for (Toggle t : addedToggles) {
                    if (!t.isSelected()) continue;
                    ToggleGroup.this.selectToggle(t);
                    continue block0;
                }
            }
        }
    }){

        @Override
        protected void onProposedChange(List<Toggle> toBeAdded, int ... indexes) {
            for (Toggle t : toBeAdded) {
                if (indexes[0] == 0 && indexes[1] == this.size()) break;
                if (!ToggleGroup.this.toggles.contains(t)) continue;
                throw new IllegalArgumentException("Duplicate toggles are not allow in a ToggleGroup.");
            }
        }
    };
    private final ReadOnlyObjectWrapper<Toggle> selectedToggle = new ReadOnlyObjectWrapper<Toggle>(){

        @Override
        public void set(Toggle newSelectedToggle) {
            if (this.isBound()) {
                throw new RuntimeException("A bound value cannot be set.");
            }
            Toggle old = (Toggle)this.get();
            if (old == newSelectedToggle) {
                return;
            }
            if (ToggleGroup.this.setSelected(newSelectedToggle, true) || newSelectedToggle != null && newSelectedToggle.getToggleGroup() == ToggleGroup.this || newSelectedToggle == null) {
                if (old == null || old.getToggleGroup() == ToggleGroup.this || !old.isSelected()) {
                    ToggleGroup.this.setSelected(old, false);
                }
                super.set(newSelectedToggle);
            }
        }
    };
    private static final Object USER_DATA_KEY = new Object();
    private ObservableMap<Object, Object> properties;

    public final ObservableList<Toggle> getToggles() {
        return this.toggles;
    }

    public final void selectToggle(Toggle value) {
        this.selectedToggle.set(value);
    }

    public final Toggle getSelectedToggle() {
        return (Toggle)this.selectedToggle.get();
    }

    public final ReadOnlyObjectProperty<Toggle> selectedToggleProperty() {
        return this.selectedToggle.getReadOnlyProperty();
    }

    private boolean setSelected(Toggle toggle, boolean selected) {
        if (toggle != null && toggle.getToggleGroup() == this && !toggle.selectedProperty().isBound()) {
            toggle.setSelected(selected);
            return true;
        }
        return false;
    }

    final void clearSelectedToggle() {
        if (!((Toggle)this.selectedToggle.getValue()).isSelected()) {
            for (Toggle toggle : this.getToggles()) {
                if (!toggle.isSelected()) continue;
                return;
            }
        }
        this.selectedToggle.set(null);
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object value) {
        this.getProperties().put(USER_DATA_KEY, value);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }
}

