/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.BaseMinecraftSessionService;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.net.InetAddress;
import java.util.Base64;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import pro.gravit.launcher.events.request.CheckServerRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.request.auth.CheckServerRequest;
import pro.gravit.launcher.request.auth.JoinServerRequest;
import pro.gravit.launcher.request.uuid.ProfileByUUIDRequest;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class YggdrasilMinecraftSessionService
extends BaseMinecraftSessionService {
    public static final boolean NO_TEXTURES = Boolean.getBoolean("launcher.com.mojang.authlib.noTextures");

    public YggdrasilMinecraftSessionService(AuthenticationService service) {
        super(service);
        LogHelper.debug((String)"Patched MinecraftSessionService created");
    }

    public YggdrasilMinecraftSessionService(YggdrasilAuthenticationService service) {
        super((AuthenticationService)service);
        LogHelper.debug((String)"Patched MinecraftSessionService created");
    }

    public static void fillTextureProperties(GameProfile profile, PlayerProfile pp) {
        boolean debug = LogHelper.isDebugEnabled();
        if (debug) {
            LogHelper.debug((String)"fillTextureProperties, Username: '%s'", (Object[])new Object[]{profile.getName()});
        }
        if (NO_TEXTURES) {
            return;
        }
        PropertyMap properties = profile.getProperties();
        if (pp.skin != null) {
            properties.put((Object)"skinURL", (Object)new Property("skinURL", pp.skin.url, ""));
            properties.put((Object)"skinDigest", (Object)new Property("skinDigest", SecurityHelper.toHex((byte[])pp.skin.digest), ""));
            if (debug) {
                LogHelper.debug((String)"fillTextureProperties, Has skin texture for username '%s'", (Object[])new Object[]{profile.getName()});
            }
        }
        if (pp.cloak != null) {
            properties.put((Object)"cloakURL", (Object)new Property("cloakURL", pp.cloak.url, ""));
            properties.put((Object)"cloakDigest", (Object)new Property("cloakDigest", SecurityHelper.toHex((byte[])pp.cloak.digest), ""));
            if (debug) {
                LogHelper.debug((String)"fillTextureProperties, Has cloak texture for username '%s'", (Object[])new Object[]{profile.getName()});
            }
        }
    }

    private static void getTexturesMojang(Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures, String texturesBase64, GameProfile profile) {
        JsonObject texturesJSON;
        try {
            byte[] decoded = Base64.getDecoder().decode(texturesBase64);
            texturesJSON = JsonParser.parseString((String)new String(decoded, IOHelper.UNICODE_CHARSET)).getAsJsonObject().getAsJsonObject("textures");
        }
        catch (Exception ignored) {
            LogHelper.error((String)"Could not decode textures payload, Username: '%s', UUID: '%s'", (Object[])new Object[]{profile.getName(), profile.getUUID()});
            return;
        }
        for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.PROFILE_TEXTURE_TYPES) {
            JsonElement urlValue;
            JsonElement textureJSON;
            if (textures.containsKey((Object)type) || (textureJSON = texturesJSON.get(type.name())) == null || !textureJSON.isJsonObject() || !(urlValue = textureJSON.getAsJsonObject().get("url")).isJsonPrimitive()) continue;
            textures.put(type, new MinecraftProfileTexture(urlValue.getAsString()));
        }
    }

    public static GameProfile toGameProfile(PlayerProfile pp) {
        GameProfile profile = new GameProfile(pp.uuid, pp.username);
        YggdrasilMinecraftSessionService.fillTextureProperties(profile, pp);
        return profile;
    }

    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) {
        PlayerProfile pp;
        UUID uuid = profile.getUUID();
        boolean debug = LogHelper.isDebugEnabled();
        if (debug) {
            LogHelper.debug((String)"fillProfileProperties, UUID: %s", (Object[])new Object[]{uuid});
        }
        if (uuid == null) {
            return profile;
        }
        try {
            pp = ((ProfileByUUIDRequestEvent)new ProfileByUUIDRequest((UUID)uuid).request()).playerProfile;
        }
        catch (Exception e) {
            if (debug) {
                LogHelper.debug((String)"Couldn't fetch profile properties for '%s': %s", (Object[])new Object[]{profile, e});
            }
            return profile;
        }
        if (pp == null) {
            if (debug) {
                LogHelper.debug((String)"Couldn't fetch profile properties for '%s' as the profile does not exist", (Object[])new Object[]{profile});
            }
            return profile;
        }
        if (debug) {
            LogHelper.debug((String)"Successfully fetched profile properties for '%s'", (Object[])new Object[]{profile});
        }
        YggdrasilMinecraftSessionService.fillTextureProperties(profile, pp);
        return YggdrasilMinecraftSessionService.toGameProfile(pp);
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile profile, boolean requireSecure) {
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)"getTextures, Username: '%s', UUID: '%s'", (Object[])new Object[]{profile.getName(), profile.getUUID()});
        }
        EnumMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures = new EnumMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>(MinecraftProfileTexture.Type.class);
        if (!NO_TEXTURES) {
            Property texturesMojang;
            Property skinURL = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"skinURL"), null);
            Property skinDigest = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"skinDigest"), null);
            if (skinURL != null && skinDigest != null) {
                textures.put(MinecraftProfileTexture.Type.SKIN, new MinecraftProfileTexture(skinURL.getValue(), skinDigest.getValue()));
            }
            Property cloakURL = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"cloakURL"), null);
            Property cloakDigest = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"cloakDigest"), null);
            if (cloakURL != null && cloakDigest != null) {
                textures.put(MinecraftProfileTexture.Type.CAPE, new MinecraftProfileTexture(cloakURL.getValue(), cloakDigest.getValue()));
            }
            if (textures.size() != MinecraftProfileTexture.PROFILE_TEXTURE_COUNT && (texturesMojang = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null)) != null) {
                YggdrasilMinecraftSessionService.getTexturesMojang(textures, texturesMojang.getValue(), profile);
            }
        }
        return textures;
    }

    public GameProfile hasJoinedServer(GameProfile profile, String serverID) throws AuthenticationUnavailableException {
        PlayerProfile pp;
        String username = profile.getName();
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)"checkServer, Username: '%s', Server ID: %s", (Object[])new Object[]{username, serverID});
        }
        try {
            pp = ((CheckServerRequestEvent)new CheckServerRequest((String)username, (String)serverID).request()).playerProfile;
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            throw new AuthenticationUnavailableException((Throwable)e);
        }
        return pp == null ? null : YggdrasilMinecraftSessionService.toGameProfile(pp);
    }

    public GameProfile hasJoinedServer(GameProfile profile, String serverID, InetAddress address) throws AuthenticationUnavailableException {
        return this.hasJoinedServer(profile, serverID);
    }

    public YggdrasilAuthenticationService getAuthenticationService() {
        return (YggdrasilAuthenticationService)super.getAuthenticationService();
    }

    public void joinServer(GameProfile profile, String accessToken, String serverID) throws AuthenticationException {
        boolean success;
        String username = profile.getName();
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)"joinServer, Username: '%s', Access token: %s, Server ID: %s", (Object[])new Object[]{username, accessToken, serverID});
        }
        try {
            success = ((JoinServerRequestEvent)new JoinServerRequest((String)username, (String)accessToken, (String)serverID).request()).allow;
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            throw new AuthenticationUnavailableException((Throwable)e);
        }
        if (!success) {
            throw new AuthenticationException("Bad Login (Clientside)");
        }
    }
}

