/*
 * Decompiled with CFR 0.152.
 */
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.Agent;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.Proxy;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.GradleStartCommon;
import net.minecraftforge.gradle.OldPropertyMapSerializer;

public class GradleStart
extends GradleStartCommon {
    private static final Gson GSON;

    public static void main(String[] var0) throws Throwable {
        GradleStart.hackNatives();
        new GradleStart().launch(var0);
    }

    @Override
    protected String getBounceClass() {
        return "net.minecraft.launchwrapper.Launch";
    }

    @Override
    protected String getTweakClass() {
        return "cpw.mods.fml.common.launcher.FMLTweaker";
    }

    @Override
    protected void setDefaultArguments(Map<String, String> var1) {
        var1.put("version", "1.7.10");
        var1.put("assetIndex", "1.7.10");
        var1.put("assetsDir", USER_HOME + "/.gradle/caches/minecraft/assets");
        var1.put("accessToken", "FML");
        var1.put("userProperties", "{}");
        var1.put("username", null);
        var1.put("password", null);
    }

    @Override
    protected void preLaunch(Map<String, String> var1, List<String> var2) {
        if (!Strings.isNullOrEmpty((String)var1.get("password"))) {
            GradleStartCommon.LOGGER.info("Password found, attempting login");
            this.attemptLogin(var1);
        }
        if (!Strings.isNullOrEmpty((String)var1.get("assetIndex"))) {
            this.setupAssets(var1);
        }
    }

    private static void hackNatives() {
        String var0 = System.getProperty("java.library.path");
        String var1 = USER_HOME + "/.gradle/caches/minecraft/net/minecraft/minecraft_natives/1.7.10";
        var0 = Strings.isNullOrEmpty((String)var0) ? var1 : var0 + File.pathSeparator + var1;
        System.setProperty("java.library.path", var0);
        try {
            Field var2 = ClassLoader.class.getDeclaredField("sys_paths");
            var2.setAccessible(true);
            var2.set(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void attemptLogin(Map<String, String> var1) {
        YggdrasilUserAuthentication var2 = (YggdrasilUserAuthentication)new YggdrasilAuthenticationService(Proxy.NO_PROXY, "1").createUserAuthentication(Agent.MINECRAFT);
        var2.setUsername(var1.get("username"));
        var2.setPassword(var1.get("password"));
        var1.put("password", null);
        try {
            var2.logIn();
        }
        catch (AuthenticationException var4) {
            LOGGER.error("-- Login failed!  " + var4.getMessage());
            Throwables.propagate((Throwable)var4);
            return;
        }
        LOGGER.info("Login Succesful!");
        var1.put("accessToken", var2.getAuthenticatedToken());
        var1.put("uuid", var2.getSelectedProfile().getId().toString().replace("-", ""));
        var1.put("username", var2.getSelectedProfile().getName());
        var1.put("userType", var2.getUserType().getName());
        var1.put("userProperties", new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new OldPropertyMapSerializer()).create().toJson((Object)var2.getUserProperties()));
    }

    private void setupAssets(Map<String, String> var1) {
        if (Strings.isNullOrEmpty((String)var1.get("assetsDir"))) {
            throw new IllegalArgumentException("assetsDir is null when assetIndex is not! THIS IS BAD COMMAND LINE ARGUMENTS, fix them");
        }
        File var2 = new File(var1.get("assetsDir"));
        File var3 = new File(var2, "objects");
        File var4 = new File(new File(var2, "indexes"), var1.get("assetIndex") + ".json");
        try {
            AssetIndex var5 = this.loadAssetsIndex(var4);
            if (!var5.virtual) {
                return;
            }
            File var6 = new File(new File(var2, "virtual"), var1.get("assetIndex"));
            var1.put("assetsDir", var6.getAbsolutePath());
            GradleStartCommon.LOGGER.info("Setting up virtual assets in: " + var6.getAbsolutePath());
            Map<String, String> var7 = this.gatherFiles(var6);
            for (Map.Entry<String, AssetIndex.AssetEntry> var9 : var5.objects.entrySet()) {
                String var10 = var9.getKey();
                String var11 = var9.getValue().hash.toLowerCase();
                File var12 = new File(var6, var10);
                File var13 = new File(new File(var3, var11.substring(0, 2)), var11);
                if (var7.containsKey(var10)) {
                    if (var7.get(var10).equals(var11)) {
                        var7.remove(var10);
                        continue;
                    }
                    GradleStartCommon.LOGGER.info("  " + var10 + ": INVALID HASH");
                    var12.delete();
                    continue;
                }
                if (!var13.exists()) {
                    GradleStartCommon.LOGGER.info("  " + var10 + ": NEW MISSING " + var11);
                    continue;
                }
                GradleStartCommon.LOGGER.info("  " + var10 + ": NEW ");
                File var14 = var12.getParentFile();
                if (!var14.exists()) {
                    var14.mkdirs();
                }
                Files.copy((File)var13, (File)var12);
            }
            for (String var16 : var7.keySet()) {
                GradleStartCommon.LOGGER.info("  " + var16 + ": REMOVED");
                File var17 = new File(var6, var16);
                var17.delete();
            }
        }
        catch (Throwable var15) {
            Throwables.propagate((Throwable)var15);
        }
    }

    private AssetIndex loadAssetsIndex(File var1) throws JsonSyntaxException, JsonIOException, IOException {
        FileReader var2 = new FileReader(var1);
        AssetIndex var3 = (AssetIndex)GSON.fromJson((Reader)var2, AssetIndex.class);
        var2.close();
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDigest(File var1) {
        Object var4;
        FilterInputStream var2 = null;
        try {
            int var16;
            var2 = new DigestInputStream(new FileInputStream(var1), MessageDigest.getInstance("SHA"));
            byte[] var3 = new byte[65536];
            while ((var16 = var2.read(var3)) > 0) {
            }
            String string = String.format("%1$040x", new BigInteger(1, ((DigestInputStream)var2).getMessageDigest().digest()));
            return string;
        }
        catch (Exception var14) {
            var4 = null;
        }
        finally {
            if (var2 != null) {
                try {
                    var2.close();
                }
                catch (Exception exception) {}
            }
        }
        return var4;
    }

    private Map<String, String> gatherFiles(File var1) {
        HashMap<String, String> var2 = new HashMap<String, String>();
        this.gatherDir(var2, var1, var1);
        return var2;
    }

    private void gatherDir(Map<String, String> var1, File var2, File var3) {
        if (var3.exists() && var3.isDirectory()) {
            for (File var7 : var3.listFiles()) {
                if (var7.isDirectory()) {
                    this.gatherDir(var1, var2, var7);
                    continue;
                }
                String var8 = var2.toURI().relativize(var7.toURI()).getPath().replace("\\", "/");
                String var9 = this.getDigest(var7).toLowerCase();
                var1.put(var8, var9);
            }
        }
    }

    static {
        GsonBuilder var0 = new GsonBuilder();
        var0.enableComplexMapKeySerialization();
        var0.setPrettyPrinting();
        GSON = var0.create();
    }

    private static class AssetIndex {
        public boolean virtual;
        public Map<String, AssetEntry> objects;

        private AssetIndex() {
        }

        public static class AssetEntry {
            public String hash;
        }
    }
}

