/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GradleStartCommon {
    protected static String USER_HOME = System.getProperty("user.home");
    protected static Logger LOGGER = LogManager.getLogger((String)"GradleStart");
    private static final String NO_CORE_SEARCH = "noCoreSearch";
    private Map<String, String> argMap = Maps.newHashMap();
    private List<String> extras = Lists.newArrayList();
    private static final File SRG_DIR = new File(USER_HOME + "/.gradle/caches/minecraft/net/minecraftforge/forge/1.7.10-10.13.4.1614-1.7.10/srgs");
    private static final File SRG_NOTCH_SRG = new File(USER_HOME + "/.gradle/caches/minecraft/net/minecraftforge/forge/1.7.10-10.13.4.1614-1.7.10/srgs/notch-srg.srg");
    private static final File SRG_NOTCH_MCP = new File(USER_HOME + "/.gradle/caches/minecraft/net/minecraftforge/forge/1.7.10-10.13.4.1614-1.7.10/srgs/notch-mcp.srg");
    private static final File SRG_SRG_MCP = new File(USER_HOME + "/.gradle/caches/minecraft/net/minecraftforge/forge/1.7.10-10.13.4.1614-1.7.10/srgs/srg-mcp.srg");
    private static final File SRG_MCP_SRG = new File(USER_HOME + "/.gradle/caches/minecraft/net/minecraftforge/forge/1.7.10-10.13.4.1614-1.7.10/srgs/mcp-srg.srg");
    private static final File SRG_MCP_NOTCH = new File(USER_HOME + "/.gradle/caches/minecraft/net/minecraftforge/forge/1.7.10-10.13.4.1614-1.7.10/srgs/mcp-notch.srg");
    private static final File CSV_DIR = new File(USER_HOME + "/.gradle/caches/minecraft/net/minecraftforge/forge/1.7.10-10.13.4.1614-1.7.10/unpacked/conf");
    private static final String MC_VERSION = "1.7.10";
    private static final String FML_PACK_OLD = "cpw.mods";
    private static final String FML_PACK_NEW = "net.minecraftforge";
    private static final String COREMOD_VAR = "fml.coreMods.load";
    private static final String COREMOD_MF = "FMLCorePlugin";
    private static final String MOD_ATD_CLASS = "fml.common.asm.transformers.ModAccessTransformer";
    private static final String MOD_AT_METHOD = "addJar";
    public static final Map<String, File> coreMap = Maps.newHashMap();

    protected abstract void setDefaultArguments(Map<String, String> var1);

    protected abstract void preLaunch(Map<String, String> var1, List<String> var2);

    protected abstract String getBounceClass();

    protected abstract String getTweakClass();

    protected void launch(String[] var1) throws Throwable {
        System.setProperty("net.minecraftforge.gradle.GradleStart.srgDir", SRG_DIR.getCanonicalPath());
        System.setProperty("net.minecraftforge.gradle.GradleStart.srg.notch-srg", SRG_NOTCH_SRG.getCanonicalPath());
        System.setProperty("net.minecraftforge.gradle.GradleStart.srg.notch-mcp", SRG_NOTCH_MCP.getCanonicalPath());
        System.setProperty("net.minecraftforge.gradle.GradleStart.srg.srg-mcp", SRG_SRG_MCP.getCanonicalPath());
        System.setProperty("net.minecraftforge.gradle.GradleStart.srg.mcp-srg", SRG_MCP_SRG.getCanonicalPath());
        System.setProperty("net.minecraftforge.gradle.GradleStart.srg.mcp-notch", SRG_MCP_NOTCH.getCanonicalPath());
        System.setProperty("net.minecraftforge.gradle.GradleStart.csvDir", CSV_DIR.getCanonicalPath());
        this.setDefaultArguments(this.argMap);
        this.parseArgs(var1);
        this.preLaunch(this.argMap, this.extras);
        System.setProperty("fml.ignoreInvalidMinecraftCertificates", "true");
        if (this.argMap.get(NO_CORE_SEARCH) == null) {
            this.searchCoremods();
        } else {
            LOGGER.info("GradleStart coremod searching disabled!");
        }
        var1 = this.getArgs();
        this.argMap = null;
        this.extras = null;
        System.gc();
        String var2 = this.getBounceClass();
        if (var2.endsWith("launchwrapper.Launch")) {
            Launch.main((String[])var1);
        } else {
            Class.forName(this.getBounceClass()).getDeclaredMethod("main", String[].class).invoke(null, (Object[])var1);
        }
    }

    private String[] getArgs() {
        ArrayList<String> var1 = new ArrayList<String>(22);
        for (Map.Entry<String, String> var3 : this.argMap.entrySet()) {
            String var4 = var3.getValue();
            if (Strings.isNullOrEmpty((String)var4)) continue;
            var1.add("--" + var3.getKey());
            var1.add(var4);
        }
        if (!Strings.isNullOrEmpty((String)this.getTweakClass())) {
            var1.add("--tweakClass");
            var1.add(this.getTweakClass());
        }
        if (this.extras != null) {
            var1.addAll(this.extras);
        }
        String[] var5 = var1.toArray(new String[0]);
        StringBuilder var6 = new StringBuilder();
        var6.append('[');
        for (int var7 = 0; var7 < var5.length; ++var7) {
            var6.append(var5[var7]).append(", ");
            if (!"--accessToken".equalsIgnoreCase(var5[var7])) continue;
            var6.append("{REDACTED}, ");
            ++var7;
        }
        var6.replace(var6.length() - 2, var6.length(), "");
        var6.append(']');
        LOGGER.info("Running with arguments: " + var6.toString());
        return var5;
    }

    private void parseArgs(String[] var1) {
        OptionParser var2 = new OptionParser();
        var2.allowsUnrecognizedOptions();
        for (String var4 : this.argMap.keySet()) {
            var2.accepts(var4).withRequiredArg().ofType(String.class);
        }
        var2.accepts(NO_CORE_SEARCH);
        NonOptionArgumentSpec var8 = var2.nonOptions();
        OptionSet var9 = var2.parse(var1);
        for (String var6 : this.argMap.keySet()) {
            if (!var9.hasArgument(var6)) continue;
            String var7 = (String)var9.valueOf(var6);
            this.argMap.put(var6, var7);
            if ("password".equalsIgnoreCase(var6)) continue;
            LOGGER.info(var6 + ": " + var7);
        }
        if (var9.has(NO_CORE_SEARCH)) {
            this.argMap.put(NO_CORE_SEARCH, "");
        }
        this.extras = Lists.newArrayList((Iterable)var8.values(var9));
        LOGGER.info("Extra: " + this.extras);
    }

    protected static Class getFmlClass(String var0) throws ClassNotFoundException {
        return GradleStartCommon.getFmlClass(var0, GradleStartCommon.class.getClassLoader());
    }

    public static Class getFmlClass(String var0, ClassLoader var1) throws ClassNotFoundException {
        if (!var0.startsWith("fml")) {
            throw new IllegalArgumentException("invalid FML classname");
        }
        var0 = MC_VERSION.startsWith("1.7") ? "cpw.mods." + var0 : "net.minecraftforge." + var0;
        return Class.forName(var0, true, var1);
    }

    private void searchCoremods() throws Exception {
        Method var1 = null;
        try {
            var1 = GradleStartCommon.getFmlClass(MOD_ATD_CLASS).getDeclaredMethod(MOD_AT_METHOD, JarFile.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (URL var5 : ((URLClassLoader)GradleStartCommon.class.getClassLoader()).getURLs()) {
            String var13;
            if (!var5.getProtocol().startsWith("file")) continue;
            File var6 = new File(var5.toURI().getPath());
            Manifest var7 = null;
            if (!var6.exists()) continue;
            if (var6.isDirectory()) {
                File var8 = new File(var6, "META-INF/MANIFEST.MF");
                if (var8.exists()) {
                    FileInputStream var9 = new FileInputStream(var8);
                    var7 = new Manifest(var9);
                    var9.close();
                }
            } else if (var6.getName().endsWith("jar")) {
                JarFile var12 = new JarFile(var6);
                var7 = var12.getManifest();
                if (var1 != null && var7 != null) {
                    var1.invoke(null, var12);
                }
                var12.close();
            }
            if (var7 == null || Strings.isNullOrEmpty((String)(var13 = var7.getMainAttributes().getValue(COREMOD_MF)))) continue;
            LOGGER.info("Found and added coremod: " + var13);
            coreMap.put(var13, var6);
        }
        HashSet var11 = Sets.newHashSet();
        if (!Strings.isNullOrEmpty((String)System.getProperty(COREMOD_VAR))) {
            var11.addAll(Splitter.on((char)',').splitToList((CharSequence)System.getProperty(COREMOD_VAR)));
        }
        var11.addAll(coreMap.keySet());
        System.setProperty(COREMOD_VAR, Joiner.on((char)',').join((Iterable)var11));
        if (!Strings.isNullOrEmpty((String)this.getTweakClass())) {
            this.extras.add("--tweakClass");
            this.extras.add("net.minecraftforge.gradle.tweakers.CoremodTweaker");
        }
    }

    public static final class AccessTransformerTransformer
    implements IClassTransformer {
        public AccessTransformerTransformer() {
            this.doStuff((LaunchClassLoader)this.getClass().getClassLoader());
        }

        private void doStuff(LaunchClassLoader var1) {
            Class<?> var2 = null;
            IClassTransformer var3 = null;
            for (IClassTransformer var5 : var1.getTransformers()) {
                if (!var5.getClass().getCanonicalName().endsWith(GradleStartCommon.MOD_ATD_CLASS)) continue;
                var2 = var5.getClass();
                var3 = var5;
            }
            if (var2 != null && var3 != null) {
                Collection var15;
                Field var16;
                Iterator var4 = null;
                try {
                    var16 = var2.getSuperclass().getDeclaredFields()[1];
                    var16.setAccessible(true);
                    var15 = ((Multimap)var16.get(var3)).values();
                }
                catch (Throwable var13) {
                    LOGGER.log(Level.ERROR, "AccessTransformer.modifiers field was somehow not found...");
                    return;
                }
                if (!var15.isEmpty()) {
                    IClassTransformer var5;
                    var5 = null;
                    try {
                        Object var6 = null;
                        Iterator var7 = var15.iterator();
                        if (var7.hasNext()) {
                            Object var8 = var7.next();
                            var6 = var8;
                        }
                        var16 = var6.getClass().getFields()[0];
                        var16.setAccessible(true);
                    }
                    catch (Throwable var14) {
                        LOGGER.log(Level.ERROR, "AccessTransformer.Modifier.name field was somehow not found...");
                        return;
                    }
                    HashMap var17 = Maps.newHashMap();
                    try {
                        this.readCsv(new File(CSV_DIR, "fields.csv"), var17);
                        this.readCsv(new File(CSV_DIR, "methods.csv"), var17);
                    }
                    catch (IOException var12) {
                        LOGGER.log(Level.ERROR, "Could not load CSV files!");
                        var12.printStackTrace();
                        return;
                    }
                    LOGGER.log(Level.INFO, "Remapping AccessTransformer rules...");
                    for (Object var8 : var15) {
                        try {
                            String var9 = (String)var16.get(var8);
                            String var10 = (String)var17.get(var9);
                            if (var10 == null) continue;
                            var16.set(var8, var10);
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                LOGGER.log(Level.ERROR, "ModAccessTransformer was somehow not found.");
            }
        }

        private void readCsv(File var1, Map<String, String> var2) throws IOException {
            LOGGER.log(Level.DEBUG, "Reading CSV file: {}", new Object[]{var1});
            Splitter var3 = Splitter.on((char)',').trimResults().limit(3);
            for (String var5 : Files.readLines((File)var1, (Charset)Charsets.UTF_8)) {
                if (var5.startsWith("searge")) continue;
                List var6 = var3.splitToList((CharSequence)var5);
                var2.put((String)var6.get(0), (String)var6.get(1));
            }
        }

        public byte[] transform(String var1, String var2, byte[] var3) {
            return var3;
        }
    }
}

