/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalByteFloatMapOps;
import net.openhft.koloboke.collect.map.ByteFloatMap;
import net.openhft.koloboke.function.ByteFloatConsumer;
import net.openhft.koloboke.function.ByteFloatPredicate;

public final class CommonByteFloatMapOps {
    public static boolean containsAllEntries(final InternalByteFloatMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ByteFloatMap) {
            ByteFloatMap m2 = (ByteFloatMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalByteFloatMapOps) {
                return ((InternalByteFloatMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ByteFloatPredicate(){

                public boolean test(byte a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((byte)((Byte)e.getKey()), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalByteFloatMapOps map, Map<? extends Byte, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ByteFloatMap) {
            if (another instanceof InternalByteFloatMapOps) {
                ((InternalByteFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((ByteFloatMap)another).forEach(new ByteFloatConsumer(){

                    public void accept(byte key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Byte, ? extends Float> e : another.entrySet()) {
                map.justPut((byte)e.getKey(), e.getValue().floatValue());
            }
        }
    }

    private CommonByteFloatMapOps() {
    }
}

