/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalDoubleDoubleMapOps;
import net.openhft.koloboke.collect.map.DoubleDoubleMap;
import net.openhft.koloboke.function.DoubleDoubleConsumer;
import net.openhft.koloboke.function.DoubleDoublePredicate;

public final class CommonDoubleDoubleMapOps {
    public static boolean containsAllEntries(final InternalDoubleDoubleMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof DoubleDoubleMap) {
            DoubleDoubleMap m2 = (DoubleDoubleMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalDoubleDoubleMapOps) {
                return ((InternalDoubleDoubleMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new DoubleDoublePredicate(){

                public boolean test(double a, double b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Double)e.getKey(), (Double)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalDoubleDoubleMapOps map, Map<? extends Double, ? extends Double> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof DoubleDoubleMap) {
            if (another instanceof InternalDoubleDoubleMapOps) {
                ((InternalDoubleDoubleMapOps)another).reversePutAllTo(map);
            } else {
                ((DoubleDoubleMap)another).forEach(new DoubleDoubleConsumer(){

                    public void accept(double key, double value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Double, ? extends Double> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonDoubleDoubleMapOps() {
    }
}

