/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalDoubleFloatMapOps;
import net.openhft.koloboke.collect.map.DoubleFloatMap;
import net.openhft.koloboke.function.DoubleFloatConsumer;
import net.openhft.koloboke.function.DoubleFloatPredicate;

public final class CommonDoubleFloatMapOps {
    public static boolean containsAllEntries(final InternalDoubleFloatMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof DoubleFloatMap) {
            DoubleFloatMap m2 = (DoubleFloatMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalDoubleFloatMapOps) {
                return ((InternalDoubleFloatMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new DoubleFloatPredicate(){

                public boolean test(double a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Double)e.getKey(), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalDoubleFloatMapOps map, Map<? extends Double, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof DoubleFloatMap) {
            if (another instanceof InternalDoubleFloatMapOps) {
                ((InternalDoubleFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((DoubleFloatMap)another).forEach(new DoubleFloatConsumer(){

                    public void accept(double key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Double, ? extends Float> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue().floatValue());
            }
        }
    }

    private CommonDoubleFloatMapOps() {
    }
}

