/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalDoubleIntMapOps;
import net.openhft.koloboke.collect.map.DoubleIntMap;
import net.openhft.koloboke.function.DoubleIntConsumer;
import net.openhft.koloboke.function.DoubleIntPredicate;

public final class CommonDoubleIntMapOps {
    public static boolean containsAllEntries(final InternalDoubleIntMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof DoubleIntMap) {
            DoubleIntMap m2 = (DoubleIntMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalDoubleIntMapOps) {
                return ((InternalDoubleIntMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new DoubleIntPredicate(){

                public boolean test(double a, int b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Double)e.getKey(), (int)((Integer)e.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalDoubleIntMapOps map, Map<? extends Double, ? extends Integer> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof DoubleIntMap) {
            if (another instanceof InternalDoubleIntMapOps) {
                ((InternalDoubleIntMapOps)another).reversePutAllTo(map);
            } else {
                ((DoubleIntMap)another).forEach(new DoubleIntConsumer(){

                    public void accept(double key, int value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Double, ? extends Integer> e : another.entrySet()) {
                map.justPut(e.getKey(), (int)e.getValue());
            }
        }
    }

    private CommonDoubleIntMapOps() {
    }
}

