/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalLongFloatMapOps;
import net.openhft.koloboke.collect.map.LongFloatMap;
import net.openhft.koloboke.function.LongFloatConsumer;
import net.openhft.koloboke.function.LongFloatPredicate;

public final class CommonLongFloatMapOps {
    public static boolean containsAllEntries(final InternalLongFloatMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof LongFloatMap) {
            LongFloatMap m2 = (LongFloatMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalLongFloatMapOps) {
                return ((InternalLongFloatMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new LongFloatPredicate(){

                public boolean test(long a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((long)((Long)e.getKey()), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalLongFloatMapOps map, Map<? extends Long, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof LongFloatMap) {
            if (another instanceof InternalLongFloatMapOps) {
                ((InternalLongFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((LongFloatMap)another).forEach(new LongFloatConsumer(){

                    public void accept(long key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Long, ? extends Float> e : another.entrySet()) {
                map.justPut((long)e.getKey(), e.getValue().floatValue());
            }
        }
    }

    private CommonLongFloatMapOps() {
    }
}

