/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalShortShortMapOps;
import net.openhft.koloboke.collect.map.ShortShortMap;
import net.openhft.koloboke.function.ShortShortConsumer;
import net.openhft.koloboke.function.ShortShortPredicate;

public final class CommonShortShortMapOps {
    public static boolean containsAllEntries(final InternalShortShortMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ShortShortMap) {
            ShortShortMap m2 = (ShortShortMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalShortShortMapOps) {
                return ((InternalShortShortMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ShortShortPredicate(){

                public boolean test(short a, short b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Short)e.getKey(), (Short)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalShortShortMapOps map, Map<? extends Short, ? extends Short> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortShortMap) {
            if (another instanceof InternalShortShortMapOps) {
                ((InternalShortShortMapOps)another).reversePutAllTo(map);
            } else {
                ((ShortShortMap)another).forEach(new ShortShortConsumer(){

                    public void accept(short key, short value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Short, ? extends Short> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonShortShortMapOps() {
    }
}

