/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ByteCollection;
import net.openhft.koloboke.collect.ByteCursor;
import net.openhft.koloboke.collect.ByteIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractByteValueView;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonCharByteMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalCharByteMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.ImmutableLHashSeparateKVCharByteMapSO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVCharByteLHash;
import net.openhft.koloboke.collect.map.CharByteCursor;
import net.openhft.koloboke.collect.set.ByteSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.ByteBinaryOperator;
import net.openhft.koloboke.function.ByteConsumer;
import net.openhft.koloboke.function.BytePredicate;
import net.openhft.koloboke.function.CharByteConsumer;
import net.openhft.koloboke.function.CharBytePredicate;
import net.openhft.koloboke.function.CharByteToByteFunction;
import net.openhft.koloboke.function.CharToByteFunction;

public class ImmutableLHashSeparateKVCharByteMapGO
extends ImmutableLHashSeparateKVCharByteMapSO {
    @Override
    final void copy(SeparateKVCharByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVCharByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(char key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public byte get(char key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Byte getOrDefault(Object key, Byte defaultValue) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public byte getOrDefault(char key, byte defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Character, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(Character.valueOf(key), (Byte)vals[i]);
        }
    }

    public void forEach(CharByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(CharBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        char free = this.freeValue;
        char[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public CharByteCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharByteMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalCharByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        char free = this.freeValue;
        char[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalCharByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Character, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        char free = this.freeValue;
        char[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        char free = this.freeValue;
        char[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Byte put(Character key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte put(char key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte putIfAbsent(Character key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte putIfAbsent(char key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(char key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte compute(Character key, BiFunction<? super Character, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte compute(char key, CharByteToByteFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte computeIfAbsent(Character key, Function<? super Character, ? extends Byte> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfAbsent(char key, CharToByteFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte computeIfPresent(Character key, BiFunction<? super Character, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfPresent(char key, CharByteToByteFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte merge(Character key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte merge(char key, byte value, ByteBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(char key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(char key, byte addition, byte defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Character, ? extends Byte> m) {
        CommonCharByteMapOps.putAll(this, m);
    }

    @Override
    public Byte replace(Character key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte replace(char key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Character key, Byte oldValue, Byte newValue) {
        return this.replace(key.charValue(), (byte)oldValue, (byte)newValue);
    }

    @Override
    public boolean replace(char key, byte oldValue, byte newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Character, ? super Byte, ? extends Byte> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(CharByteToByteFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(char key) {
        throw new UnsupportedOperationException();
    }

    public byte remove(char key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), (Byte)value);
    }

    public boolean remove(char key, byte value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(CharBytePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements CharByteCursor {
        final char[] keys;
        final byte[] vals;
        final char free;
        int index;
        char curKey;
        byte curValue;

        NoRemovedMapCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue);
        }

        public void forEachForward(CharByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            byte[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final char[] keys;
        final byte[] vals;
        final char free;
        int index;
        char curKey;
        byte curValue;

        NoRemovedValueCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            byte[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final char[] keys;
        final byte[] vals;
        final char free;
        int nextIndex;
        byte next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            char free = this.free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] keys = this.keys;
                char free = this.free;
                byte prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            byte[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            byte[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Byte>> {
        final char[] keys;
        final byte[] vals;
        final char free;
        int index;
        char curKey;
        byte curValue;

        NoRemovedEntryCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            byte[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Byte> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Byte>> {
        final char[] keys;
        final byte[] vals;
        final char free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            char free = this.free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                char key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            byte[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] keys = this.keys;
                char free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    char key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVCharByteMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVCharByteMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVCharByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return ImmutableLHashSeparateKVCharByteMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Byte)vals[i]);
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeByte(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ByteCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return ImmutableLHashSeparateKVCharByteMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVCharByteMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(BytePredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends CharByteEntry {
        private char key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends CharByteEntry {
        private final char key;
        private final byte value;

        ImmutableEntry(char key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    abstract class CharByteEntry
    extends AbstractEntry<Character, Byte> {
        CharByteEntry() {
        }

        abstract char key();

        @Override
        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract byte value();

        @Override
        public final Byte getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Byte>>
    implements HashObjSet<Map.Entry<Character, Byte>>,
    InternalObjCollectionOps<Map.Entry<Character, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Character, Byte>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVCharByteMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVCharByteMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVCharByteMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVCharByteMapGO.this.containsEntry(((Character)e.getKey()).charValue(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || predicate.test(new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Character, Byte>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Byte>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashSeparateKVCharByteMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashSeparateKVCharByteMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVCharByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVCharByteMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                byte value = (Byte)e.getValue();
                return ImmutableLHashSeparateKVCharByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Byte>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVCharByteMapGO.this.clear();
        }
    }
}

