/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.Maths;
import net.openhft.koloboke.collect.impl.hash.Capacities;
import net.openhft.koloboke.collect.impl.hash.HashConfigWrapper;

public final class LHashCapacities {
    private static final int MIN_CAPACITY = 4;
    private static final int MAX_INT_CAPACITY = 0x40000000;
    private static final long MAX_LONG_CAPACITY = 0x4000000000000000L;

    public static boolean isMaxCapacity(int capacity) {
        return capacity == 0x40000000;
    }

    public static boolean isMaxCapacity(int capacity, boolean doubleSizedArrays) {
        int maxCapacity = 0x40000000;
        if (doubleSizedArrays) {
            maxCapacity >>= 1;
        }
        return capacity == maxCapacity;
    }

    public static boolean isMaxCapacity(long capacity) {
        return capacity == 0x4000000000000000L;
    }

    public static boolean isMaxCapacity(long capacity, boolean doubleSizedArrays) {
        long maxCapacity = 0x4000000000000000L;
        if (doubleSizedArrays) {
            maxCapacity >>= 1;
        }
        return capacity == maxCapacity;
    }

    public static int capacity(HashConfigWrapper conf, int size) {
        return LHashCapacities.capacity(conf, size, false);
    }

    public static int capacity(HashConfigWrapper conf, int size, boolean doubleSizedArrays) {
        assert (size >= 0) : "size must be non-negative";
        int desiredCapacity = conf.targetCapacity(size);
        if (desiredCapacity <= 4) {
            return 4;
        }
        int maxCapacity = 0x40000000;
        if (doubleSizedArrays) {
            maxCapacity >>= 1;
        }
        if (desiredCapacity < maxCapacity) {
            if (Maths.isPowerOf2(desiredCapacity)) {
                return desiredCapacity;
            }
            int lesserCapacity = LHashCapacities.highestOneBit(desiredCapacity);
            int greaterCapacity = lesserCapacity << 1;
            return Capacities.chooseBetter(conf, size, desiredCapacity, lesserCapacity, greaterCapacity, greaterCapacity);
        }
        return maxCapacity;
    }

    static boolean configIsSuitableForImmutableHash(HashConfigWrapper conf, int size) {
        assert (size >= 0);
        int desiredCapacity = conf.targetCapacity(size);
        if (desiredCapacity <= 4) {
            return 4 <= conf.maxCapacity(size);
        }
        if (desiredCapacity < 0x40000000) {
            int greaterCapacity;
            if (Maths.isPowerOf2(desiredCapacity)) {
                return true;
            }
            int lesserCapacity = LHashCapacities.highestOneBit(desiredCapacity);
            int c = Capacities.chooseBetter(conf, size, desiredCapacity, lesserCapacity, greaterCapacity = lesserCapacity << 1, -1);
            return c > 0;
        }
        return false;
    }

    public static long capacity(HashConfigWrapper conf, long size) {
        return LHashCapacities.capacity(conf, size, false);
    }

    public static long capacity(HashConfigWrapper conf, long size, boolean doubleSizedArrays) {
        assert (size >= 0L) : "size must be non-negative";
        long desiredCapacity = conf.targetCapacity(size);
        if (desiredCapacity <= 4L) {
            return 4L;
        }
        long maxCapacity = 0x4000000000000000L;
        if (doubleSizedArrays) {
            maxCapacity >>= 1;
        }
        if (desiredCapacity < maxCapacity) {
            if (Maths.isPowerOf2(desiredCapacity)) {
                return desiredCapacity;
            }
            long lesserCapacity = LHashCapacities.highestOneBit(desiredCapacity);
            long greaterCapacity = lesserCapacity << 1;
            return Capacities.chooseBetter(conf, size, desiredCapacity, lesserCapacity, greaterCapacity, greaterCapacity);
        }
        return maxCapacity;
    }

    private static int highestOneBit(int n) {
        assert (n > 0);
        return Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(n);
    }

    private static long highestOneBit(long n) {
        assert (n > 0L);
        return Long.MIN_VALUE >>> Long.numberOfLeadingZeros(n);
    }

    static boolean configIsSuitableForMutableLHash(HashConfig conf) {
        return conf.getGrowFactor() == 2.0 && conf.getMinLoad() < 0.5;
    }

    private LHashCapacities() {
    }
}

