/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.hash.CharHashFactory;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.hash.HashContainerFactory;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.hash.ImmutableLHashCharSetGO;
import net.openhft.koloboke.collect.impl.hash.LHashCapacities;
import net.openhft.koloboke.collect.impl.hash.LHashCharSetFactorySO;
import net.openhft.koloboke.collect.impl.hash.MutableLHashCharSetGO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVCharLHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableLHashCharSetGO;
import net.openhft.koloboke.collect.set.hash.HashCharSet;
import net.openhft.koloboke.collect.set.hash.HashCharSetFactory;
import net.openhft.koloboke.function.CharConsumer;
import net.openhft.koloboke.function.Predicate;

public abstract class LHashCharSetFactoryGO
extends LHashCharSetFactorySO {
    public LHashCharSetFactoryGO(HashConfig hashConf, int defaultExpectedSize, char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashCharSetFactory thisWith(HashConfig var1, int var2, char var3, char var4);

    abstract HashCharSetFactory lHashLikeThisWith(HashConfig var1, int var2, char var3, char var4);

    abstract HashCharSetFactory qHashLikeThisWith(HashConfig var1, int var2, char var3, char var4);

    public final HashCharSetFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashCharSetFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public String toString() {
        return "HashCharSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashCharSetFactory) {
            HashCharSetFactory factory = (HashCharSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((CharHashFactory)factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private UpdatableLHashCharSetGO shrunk(UpdatableLHashCharSetGO set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(set)) {
            set.shrink();
        }
        return set;
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    @Nonnull
    public MutableLHashCharSetGO newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elements) {
        return this.newUpdatableSet((Iterable)elements, LHashCharSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2) {
        long expectedSize = LHashCharSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt(expectedSize += (long)LHashCharSetFactoryGO.sizeOr(elems2, 0)));
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3) {
        long expectedSize = LHashCharSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashCharSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt(expectedSize += (long)LHashCharSetFactoryGO.sizeOr(elems3, 0)));
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4) {
        long expectedSize = LHashCharSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashCharSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)LHashCharSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt(expectedSize += (long)LHashCharSetFactoryGO.sizeOr(elems4, 0)));
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5) {
        long expectedSize = LHashCharSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashCharSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)LHashCharSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)LHashCharSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt(expectedSize += (long)LHashCharSetFactoryGO.sizeOr(elems5, 0)));
    }

    @Override
    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elements, int expectedSize) {
        return this.shrunk((UpdatableLHashCharSetGO)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static void addAll(UpdatableLHashCharSetGO set, Iterable<? extends Character> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            Iterator<? extends Character> iterator = elems.iterator();
            while (iterator.hasNext()) {
                char e = iterator.next().charValue();
                set.add(e);
            }
        }
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, int expectedSize) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(expectedSize);
        LHashCharSetFactoryGO.addAll(set, elems1);
        LHashCharSetFactoryGO.addAll(set, elems2);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, int expectedSize) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(expectedSize);
        LHashCharSetFactoryGO.addAll(set, elems1);
        LHashCharSetFactoryGO.addAll(set, elems2);
        LHashCharSetFactoryGO.addAll(set, elems3);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, int expectedSize) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(expectedSize);
        LHashCharSetFactoryGO.addAll(set, elems1);
        LHashCharSetFactoryGO.addAll(set, elems2);
        LHashCharSetFactoryGO.addAll(set, elems3);
        LHashCharSetFactoryGO.addAll(set, elems4);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5, int expectedSize) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(expectedSize);
        LHashCharSetFactoryGO.addAll(set, elems1);
        LHashCharSetFactoryGO.addAll(set, elems2);
        LHashCharSetFactoryGO.addAll(set, elems3);
        LHashCharSetFactoryGO.addAll(set, elems4);
        LHashCharSetFactoryGO.addAll(set, elems5);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterator<Character> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterator<Character> elements, int expectedSize) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Consumer<CharConsumer> elementsSupplier) {
        return this.newUpdatableSet((Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Consumer<CharConsumer> elementsSupplier, int expectedSize) {
        final UpdatableLHashCharSetGO set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept(new CharConsumer(){

            public void accept(char e) {
                set.add(e);
            }
        });
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(char[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(char[] elements, int expectedSize) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(expectedSize);
        for (char e : elements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Character[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Character[] elements, int expectedSize) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(expectedSize);
        Character[] characterArray = elements;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char e = characterArray[i].charValue();
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSetOf(char e1) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSetOf(char e1, char e2) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSetOf(char e1, char e2, char e3) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSetOf(char e1, char e2, char e3, char e4) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSetOf(char e1, char e2, char e3, char e4, char e5, char ... restElements) {
        UpdatableLHashCharSetGO set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (char e : restElements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elements, int expectedSize) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, int expectedSize) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, int expectedSize) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, int expectedSize) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5, int expectedSize) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elements) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterator<Character> elements) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterator<Character> elements, int expectedSize) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Consumer<CharConsumer> elementsSupplier) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Consumer<CharConsumer> elementsSupplier, int expectedSize) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(char[] elements) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(char[] elements, int expectedSize) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Character[] elements) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Character[] elements, int expectedSize) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSetOf(char e1) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSetOf(char e1, char e2) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSetOf(char e1, char e2, char e3) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSetOf(char e1, char e2, char e3, char e4) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSetOf(char e1, char e2, char e3, char e4, char e5, char ... restElements) {
        MutableLHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elements, int expectedSize) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, int expectedSize) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, int expectedSize) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, int expectedSize) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5, int expectedSize) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elements) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterator<Character> elements) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterator<Character> elements, int expectedSize) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Consumer<CharConsumer> elementsSupplier) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Consumer<CharConsumer> elementsSupplier, int expectedSize) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharLHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(char[] elements) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(char[] elements, int expectedSize) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Character[] elements) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Character[] elements, int expectedSize) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSetOf(char e1) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSetOf(char e1, char e2) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSetOf(char e1, char e2, char e3) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSetOf(char e1, char e2, char e3, char e4) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSetOf(char e1, char e2, char e3, char e4, char e5, char ... restElements) {
        ImmutableLHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }
}

