/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.CharCollection;
import net.openhft.koloboke.collect.CharCursor;
import net.openhft.koloboke.collect.CharIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.ShortCollection;
import net.openhft.koloboke.collect.ShortCursor;
import net.openhft.koloboke.collect.ShortIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.AbstractShortValueView;
import net.openhft.koloboke.collect.impl.CommonCharShortMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalCharShortMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableLHashParallelKVCharShortMapSO;
import net.openhft.koloboke.collect.impl.hash.MutableParallelKVCharLHashGO;
import net.openhft.koloboke.collect.impl.hash.ParallelKVCharShortLHash;
import net.openhft.koloboke.collect.map.CharShortCursor;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.ShortSet;
import net.openhft.koloboke.collect.set.hash.HashCharSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.CharPredicate;
import net.openhft.koloboke.function.CharShortConsumer;
import net.openhft.koloboke.function.CharShortPredicate;
import net.openhft.koloboke.function.CharShortToShortFunction;
import net.openhft.koloboke.function.CharToShortFunction;
import net.openhft.koloboke.function.ShortBinaryOperator;
import net.openhft.koloboke.function.ShortConsumer;
import net.openhft.koloboke.function.ShortPredicate;

public class MutableLHashParallelKVCharShortMapGO
extends MutableLHashParallelKVCharShortMapSO {
    final void copy(ParallelKVCharShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVCharShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(char key, short value) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (short)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return null;
        }
        return null;
    }

    public short get(char key) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    @Override
    public Short getOrDefault(Object key, Short defaultValue) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public short getOrDefault(char key, short defaultValue) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Character, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            action.accept(Character.valueOf(key), (Short)((short)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            action.accept(key, (short)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free || predicate.test(key, (short)(entry >>> 16))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public CharShortCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharShortMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalCharShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free || m.containsEntry(key, (short)(entry >>> 16))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalCharShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            m.justPut(key, (short)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Character, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            hashCode += key ^ (short)(entry >>> 16);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((short)(entry >>> 16));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newTab = this.table;
        int capacityMask = newTab.length - 1;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2)) != free) {
                while (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)(index = index - 1 & capacityMask) << 2)) != free) {
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Short put(Character key, Short value) {
        char free;
        char k = key.charValue();
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k | value << 16;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = k | value << 16;
                this.postInsertHook();
                return null;
            } while (cur != k);
        }
        short prevValue = (short)(entry >>> 16);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    @Override
    public short put(char key, short value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postInsertHook();
                return this.defaultValue();
            } while (cur != key);
        }
        short prevValue = (short)(entry >>> 16);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    @Override
    public Short putIfAbsent(Character key, Short value) {
        char free;
        char k = key.charValue();
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k | value << 16;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (short)(entry >>> 16);
        }
        do {
            if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = k | value << 16;
            this.postInsertHook();
            return null;
        } while (cur != k);
        return (short)(entry >>> 16);
    }

    @Override
    public short putIfAbsent(char key, short value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (short)(entry >>> 16);
        }
        do {
            if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        } while (cur != key);
        return (short)(entry >>> 16);
    }

    @Override
    public void justPut(char key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putShort(this.table, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Short compute(Character key, BiFunction<? super Character, ? super Short, ? extends Short> remappingFunction) {
        block5: {
            k = key.charValue();
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                    this.incrementModCount();
                    tab[index] = k | newValue << 16;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(k), (Short)((short)(entry >>> 16)))) != null) {
            MutableLHashParallelKVCharShortMapGO.U.putShort(tab, MutableLHashParallelKVCharShortMapGO.INT_BASE + MutableLHashParallelKVCharShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public short compute(char key, CharShortToShortFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsShort(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsShort(key, (short)(entry >>> 16));
        MutableLHashParallelKVCharShortMapGO.U.putShort(tab, MutableLHashParallelKVCharShortMapGO.INT_BASE + MutableLHashParallelKVCharShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    @Override
    public Short computeIfAbsent(Character key, Function<? super Character, ? extends Short> mappingFunction) {
        Short value;
        char k = key.charValue();
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == k) {
            return (short)(entry >>> 16);
        }
        if (cur != free) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
        }
        if ((value = mappingFunction.apply(Character.valueOf(k))) != null) {
            this.incrementModCount();
            tab[index] = k | value << 16;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(char key, CharToShortFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == key) {
            return (short)(entry >>> 16);
        }
        if (cur != free) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
        }
        short value = mappingFunction.applyAsShort(key);
        this.incrementModCount();
        tab[index] = key | value << 16;
        this.postInsertHook();
        return value;
    }

    @Override
    public Short computeIfPresent(Character key, BiFunction<? super Character, ? super Short, ? extends Short> remappingFunction) {
        char k = key.charValue();
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (k != free) {
            Short newValue;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply(Character.valueOf(k), (Short)((short)(entry >>> 16)))) != null) {
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public short computeIfPresent(char key, CharShortToShortFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            short newValue = remappingFunction.applyAsShort(key, (short)(entry >>> 16));
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Short merge(Character key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        block5: {
            k = key.charValue();
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                tab[index] = k | value << 16;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Short)((short)(entry >>> 16)), value)) != null) {
            MutableLHashParallelKVCharShortMapGO.U.putShort(tab, MutableLHashParallelKVCharShortMapGO.INT_BASE + MutableLHashParallelKVCharShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public short merge(char key, short value, ShortBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsShort((short)(entry >>> 16), value);
        MutableLHashParallelKVCharShortMapGO.U.putShort(tab, MutableLHashParallelKVCharShortMapGO.INT_BASE + MutableLHashParallelKVCharShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public short addValue(char key, short value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postInsertHook();
                return value;
            } while (cur != key);
        }
        short newValue = (short)((short)(entry >>> 16) + value);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public short addValue(char key, short addition, short defaultValue) {
        short value = (short)(defaultValue + addition);
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postInsertHook();
                return value;
            } while (cur != key);
        }
        short newValue = (short)((short)(entry >>> 16) + addition);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Character, ? extends Short> m) {
        CommonCharShortMapOps.putAll(this, m);
    }

    @Override
    public Short replace(Character key, Short value) {
        char free;
        char k = key.charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            short oldValue = (short)(entry >>> 16);
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return null;
    }

    @Override
    public short replace(char key, short value) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            short oldValue = (short)(entry >>> 16);
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Character key, Short oldValue, Short newValue) {
        return this.replace(key.charValue(), (short)oldValue, (short)newValue);
    }

    @Override
    public boolean replace(char key, short oldValue, short newValue) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((short)(entry >>> 16) == oldValue) {
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Character, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.apply(Character.valueOf(key), (Short)((short)(entry >>> 16))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(CharShortToShortFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.applyAsShort(key, (short)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        int entry;
        char keyToShift;
        int indexToRemove;
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = entry;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
        this.postRemoveHook();
    }

    @Override
    public Short remove(Object key) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            char keyToShift;
            int indexToRemove;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            short val = (short)(entry >>> 16);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(char key) {
        char free = this.freeValue;
        if (key != free) {
            char keyToShift;
            int indexToRemove;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public short remove(char key) {
        char free = this.freeValue;
        if (key != free) {
            char keyToShift;
            int indexToRemove;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            short val = (short)(entry >>> 16);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), (Short)value);
    }

    public boolean remove(char key, short value) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((short)(entry >>> 16) == value) {
                char keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(CharShortPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !filter.test(key, (short)(entry >>> 16))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    this.postRemoveHook();
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Character> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !filter.test(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    this.postRemoveHook();
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(CharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    this.postRemoveHook();
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    this.postRemoveHook();
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    this.postRemoveHook();
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.retainAll(thisC, (CharCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block13: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    this.postRemoveHook();
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block12: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    this.postRemoveHook();
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, char delayedRemoved) {
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            char keyToShift;
            int indexToRemove;
            int entry = tab[i];
            if ((char)entry != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
            this.postRemoveHook();
        }
    }

    @Override
    public CharIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public CharCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements CharShortCursor {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVCharShortMapGO.this.freeValue);
        }

        public void forEachForward(CharShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key, (short)(entry >>> 16));
            }
            if (index != this.index || mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(short value) {
            if (this.curKey == this.free) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashParallelKVCharShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), value);
            if (this.tab == MutableLHashParallelKVCharShortMapGO.this.table) return;
            UnsafeConstants.U.putShort(MutableLHashParallelKVCharShortMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharShortMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharShortMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVCharShortMapGO.this.freeValue);
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (index != this.index || mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharShortMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharShortMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            this.capacityMask = tab.length - 1;
            char free = this.free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((char)entry == free) continue;
                this.next = (short)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        if ((char)entry == free) continue;
                        this.next = (short)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharShortMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = (short)(entry >>> 16);
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharShortMapGO.this.justRemove(UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2)));
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Short>> {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVCharShortMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new MutableEntry2(mc, i, key, (short)(entry >>> 16)));
            }
            if (index != this.index || mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Short> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharShortMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharShortMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, char key, short value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(short newValue) {
                if (NoRemovedEntryCursor.this.tab == MutableLHashParallelKVCharShortMapGO.this.table) {
                    UnsafeConstants.U.putShort(NoRemovedEntryCursor.this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)NoRemovedEntryCursor.this.index << 2), newValue);
                } else {
                    MutableLHashParallelKVCharShortMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Short>> {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            this.capacityMask = tab.length - 1;
            char free = this.free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free) continue;
                this.next = new MutableEntry2(mc, nextI, key, (short)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new MutableEntry2(mc, i, key, (short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry2(mc, nextI, key, (short)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharShortMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashParallelKVCharShortMapGO.this.modCount(), indexToShift, keyToShift, (short)(entry >>> 16));
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharShortMapGO.this.justRemove(UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2)));
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, char key, short value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(short newValue) {
                if (NoRemovedEntryIterator.this.tab == MutableLHashParallelKVCharShortMapGO.this.table) {
                    UnsafeConstants.U.putShort(NoRemovedEntryIterator.this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)NoRemovedEntryIterator.this.index << 2), newValue);
                } else {
                    MutableLHashParallelKVCharShortMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableLHashParallelKVCharShortMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashParallelKVCharShortMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableLHashParallelKVCharShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return MutableLHashParallelKVCharShortMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free || predicate.test((short)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free || c.contains((short)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                changed |= c.add((short)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                changed |= s.removeShort((short)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                result[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                a[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                result[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                a[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                sb.append(' ').append((short)(entry >>> 16)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return MutableLHashParallelKVCharShortMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableLHashParallelKVCharShortMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !filter.test((Short)((short)(entry >>> 16)))) continue;
                    MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                        MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(ShortPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !filter.test((short)(entry >>> 16))) continue;
                    MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                        MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.removeAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !c.contains((short)(entry >>> 16))) continue;
                    MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                        MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !c.contains((short)(entry >>> 16))) continue;
                    MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                        MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.retainAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block13: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || c.contains((short)(entry >>> 16))) continue;
                    MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                        MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || c.contains((short)(entry >>> 16))) continue;
                    MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                        MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends CharShortEntry {
        private char key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends CharShortEntry {
        final int modCount;
        private final int index;
        final char key;
        private short value;

        MutableEntry(int modCount, int index, char key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        @Override
        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            UnsafeConstants.U.putShort(MutableLHashParallelKVCharShortMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), newValue);
        }
    }

    abstract class CharShortEntry
    extends AbstractEntry<Character, Short> {
        CharShortEntry() {
        }

        abstract char key();

        @Override
        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract short value();

        @Override
        public final Short getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Short>>
    implements HashObjSet<Map.Entry<Character, Short>>,
    InternalObjCollectionOps<Map.Entry<Character, Short>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Character, Short>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashParallelKVCharShortMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableLHashParallelKVCharShortMapGO.this.size();
        }

        public double currentLoad() {
            return MutableLHashParallelKVCharShortMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashParallelKVCharShortMapGO.this.containsEntry(((Character)e.getKey()).charValue(), (Short)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (short)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || predicate.test(new MutableEntry(mc, i, key, (short)(entry >>> 16)))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Character, Short>> iterator() {
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Short>> cursor() {
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (short)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableLHashParallelKVCharShortMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((short)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashParallelKVCharShortMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                short value = (Short)e.getValue();
                return MutableLHashParallelKVCharShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Short>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !filter.test(new MutableEntry(mc, i, key, (short)(entry >>> 16)))) continue;
                    MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                        MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block13: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !c.contains(e.with(key, (short)(entry >>> 16)))) continue;
                    MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                        MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharShortMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || c.contains(e.with(key, (short)(entry >>> 16)))) continue;
                    MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), key);
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                        MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharShortMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableLHashParallelKVCharShortMapGO.this.clear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableParallelKVCharLHashGO.NoRemovedCursor {
        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashParallelKVCharShortMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharShortMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharShortMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableParallelKVCharLHashGO.NoRemovedIterator {
        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashParallelKVCharShortMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharShortMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharShortMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharShortMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                MutableLHashParallelKVCharShortMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharShortMapGO.this.justRemove(UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2)));
            }
        }
    }
}

