/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.DoubleCollection;
import net.openhft.koloboke.collect.DoubleCursor;
import net.openhft.koloboke.collect.DoubleIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractDoubleValueView;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonDoubleDoubleMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalDoubleCollectionOps;
import net.openhft.koloboke.collect.impl.InternalDoubleDoubleMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableLHashParallelKVDoubleDoubleMapSO;
import net.openhft.koloboke.collect.impl.hash.MutableParallelKVDoubleLHashGO;
import net.openhft.koloboke.collect.impl.hash.ParallelKVDoubleDoubleLHash;
import net.openhft.koloboke.collect.map.DoubleDoubleCursor;
import net.openhft.koloboke.collect.set.DoubleSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashDoubleSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.DoubleDoubleConsumer;
import net.openhft.koloboke.function.DoubleDoublePredicate;
import net.openhft.koloboke.function.DoubleDoubleToDoubleFunction;

public class MutableLHashParallelKVDoubleDoubleMapGO
extends MutableLHashParallelKVDoubleDoubleMapSO {
    final void copy(ParallelKVDoubleDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVDoubleDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    @Override
    public boolean containsEntry(double key, double value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1] == Double.doubleToLongBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return null;
    }

    public double get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return this.defaultValue();
    }

    @Override
    public Double getOrDefault(Object key, Double defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return defaultValue;
    }

    public double getOrDefault(double key, double defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Double, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key), (Double)Double.longBitsToDouble(tab[i + 1]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(DoubleDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), Double.longBitsToDouble(tab[i + 1]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(DoubleDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), Double.longBitsToDouble(tab[i + 1]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public DoubleDoubleCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleDoubleMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalDoubleDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, tab[i + 1])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalDoubleDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Double, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            long val = tab[i + 1];
            hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(Double.longBitsToDouble(tab[i + 1]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacityMask = newTab.length - 2;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            int index = LHash.ParallelKVDoubleKeyMixing.mix(key) & capacityMask;
            if (newTab[index] != 0x7FFFFFFFFFFFFFFEL) {
                while (newTab[index = index - 2 & capacityMask] != 0x7FFFFFFFFFFFFFFEL) {
                }
            }
            newTab[index] = key;
            newTab[index + 1] = tab[i + 1];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Double put(Double key, Double value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        long[] tab = this.table;
        double prevValue = Double.longBitsToDouble(tab[index + 1]);
        tab[index + 1] = Double.doubleToLongBits(value);
        return prevValue;
    }

    @Override
    public double put(double key, double value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        long[] tab = this.table;
        double prevValue = Double.longBitsToDouble(tab[index + 1]);
        tab[index + 1] = Double.doubleToLongBits(value);
        return prevValue;
    }

    @Override
    public Double putIfAbsent(Double key, Double value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        return Double.longBitsToDouble(this.table[index + 1]);
    }

    @Override
    public double putIfAbsent(double key, double value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Double.longBitsToDouble(this.table[index + 1]);
    }

    @Override
    public void justPut(double key, double value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return;
        }
        this.table[index + 1] = Double.doubleToLongBits(value);
    }

    @Override
    public void justPut(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Double compute(Double key, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        block4: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl12:
                // 2 sources

                if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), null)) != null) {
                    this.incrementModCount();
                    tab[index] = k;
                    tab[index + 1] = Double.doubleToLongBits(newValue);
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Double)Double.longBitsToDouble(tab[index + 1]))) != null) {
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public double compute(double key, DoubleDoubleToDoubleFunction remappingFunction) {
        block2: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl12:
                // 2 sources

                newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(k), this.defaultValue());
                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(k), Double.longBitsToDouble(tab[index + 1]));
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    @Override
    public Double computeIfAbsent(Double key, Function<? super Double, ? extends Double> mappingFunction) {
        Double value;
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
        long cur = tab[index];
        if (cur == k) {
            return Double.longBitsToDouble(tab[index + 1]);
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = tab[index = index - 2 & capacityMask]) != k) continue;
                return Double.longBitsToDouble(tab[index + 1]);
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        if ((value = mappingFunction.apply((Double)Double.longBitsToDouble(k))) != null) {
            this.incrementModCount();
            tab[index] = k;
            tab[index + 1] = Double.doubleToLongBits(value);
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public double computeIfAbsent(double key, DoubleUnaryOperator mappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
        long cur = tab[index];
        if (cur == k) {
            return Double.longBitsToDouble(tab[index + 1]);
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = tab[index = index - 2 & capacityMask]) != k) continue;
                return Double.longBitsToDouble(tab[index + 1]);
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        double value = mappingFunction.applyAsDouble(Double.longBitsToDouble(k));
        this.incrementModCount();
        tab[index] = k;
        tab[index + 1] = Double.doubleToLongBits(value);
        this.postInsertHook();
        return value;
    }

    @Override
    public Double computeIfPresent(Double key, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            Double newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Double)Double.longBitsToDouble(tab[index + 1]));
            if (newValue != null) {
                tab[index + 1] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public double computeIfPresent(double key, DoubleDoubleToDoubleFunction remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            double newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(k), Double.longBitsToDouble(tab[index + 1]));
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Double merge(Double key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        block4: {
            k = Double.doubleToLongBits(key);
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl14
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl14:
                // 2 sources

                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(tab[index + 1]), value)) != null) {
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public double merge(double key, double value, DoubleBinaryOperator remappingFunction) {
        block2: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl12:
                // 2 sources

                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(tab[index + 1]), value);
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(double key, double value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return value;
        }
        long[] tab = this.table;
        double newValue = Double.longBitsToDouble(tab[index + 1]) + value;
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(double key, double addition, double defaultValue) {
        double value;
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Double.doubleToLongBits(value = defaultValue + addition));
        if (index < 0) {
            return value;
        }
        long[] tab = this.table;
        double newValue = Double.longBitsToDouble(tab[index + 1]) + addition;
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Double, ? extends Double> m) {
        CommonDoubleDoubleMapOps.putAll(this, m);
    }

    @Override
    public Double replace(Double key, Double value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            double oldValue = Double.longBitsToDouble(tab[index + 1]);
            tab[index + 1] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return null;
    }

    @Override
    public double replace(double key, double value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            double oldValue = Double.longBitsToDouble(tab[index + 1]);
            tab[index + 1] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Double key, Double oldValue, Double newValue) {
        return this.replace((double)key, (double)oldValue, (double)newValue);
    }

    @Override
    public boolean replace(double key, double oldValue, double newValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            if (tab[index + 1] == Double.doubleToLongBits(oldValue)) {
                tab[index + 1] = Double.doubleToLongBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Double, ? super Double, ? extends Double> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            tab[i + 1] = Double.doubleToLongBits(function.apply((Double)Double.longBitsToDouble(key), (Double)Double.longBitsToDouble(tab[i + 1])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(DoubleDoubleToDoubleFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            tab[i + 1] = Double.doubleToLongBits(function.applyAsDouble(Double.longBitsToDouble(key), Double.longBitsToDouble(tab[i + 1])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        long keyToShift;
        int indexToRemove;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 2;
        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = keyToShift;
                tab[indexToRemove + 1] = tab[indexToShift + 1];
                indexToRemove = indexToShift;
                shiftDistance = 2;
                continue;
            }
            shiftDistance += 2;
            if (indexToShift != 2 + index) continue;
            throw new ConcurrentModificationException();
        }
        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
        this.postRemoveHook();
    }

    @Override
    public Double remove(Object key) {
        long keyToShift;
        int indexToRemove;
        long k = Double.doubleToLongBits((Double)key);
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
        long cur = tab[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return null;
            }
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
                return null;
            }
        }
        double val = Double.longBitsToDouble(tab[index + 1]);
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 2;
        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = keyToShift;
                tab[indexToRemove + 1] = tab[indexToShift + 1];
                indexToRemove = indexToShift;
                shiftDistance = 2;
                continue;
            }
            shiftDistance += 2;
            if (indexToShift != 2 + index) continue;
            throw new ConcurrentModificationException();
        }
        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean justRemove(double key) {
        long keyToShift;
        int indexToRemove;
        long k = Double.doubleToLongBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
        long cur = tab[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
                return false;
            }
        }
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 2;
        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = keyToShift;
                tab[indexToRemove + 1] = tab[indexToShift + 1];
                indexToRemove = indexToShift;
                shiftDistance = 2;
                continue;
            }
            shiftDistance += 2;
            if (indexToShift != 2 + index) continue;
            throw new ConcurrentModificationException();
        }
        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
        this.postRemoveHook();
        return true;
    }

    @Override
    public boolean justRemove(long key) {
        long keyToShift;
        int indexToRemove;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(key) & capacityMask;
        long cur = tab[index];
        if (cur != key) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
                return false;
            }
        }
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 2;
        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = keyToShift;
                tab[indexToRemove + 1] = tab[indexToShift + 1];
                indexToRemove = indexToShift;
                shiftDistance = 2;
                continue;
            }
            shiftDistance += 2;
            if (indexToShift != 2 + index) continue;
            throw new ConcurrentModificationException();
        }
        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
        this.postRemoveHook();
        return true;
    }

    public double remove(double key) {
        long keyToShift;
        int indexToRemove;
        long k = Double.doubleToLongBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
        long cur = tab[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return this.defaultValue();
            }
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
                return this.defaultValue();
            }
        }
        double val = Double.longBitsToDouble(tab[index + 1]);
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 2;
        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = keyToShift;
                tab[indexToRemove + 1] = tab[indexToShift + 1];
                indexToRemove = indexToShift;
                shiftDistance = 2;
                continue;
            }
            shiftDistance += 2;
            if (indexToShift != 2 + index) continue;
            throw new ConcurrentModificationException();
        }
        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Double)value);
    }

    public boolean remove(double key, double value) {
        long k = Double.doubleToLongBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
        long cur = tab[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
                return false;
            }
        }
        if (tab[index + 1] == Double.doubleToLongBits(value)) {
            long keyToShift;
            int indexToRemove;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + index) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeIf(DoubleDoublePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test(Double.longBitsToDouble(key), Double.longBitsToDouble(tab[i + 1]))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Long.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    tab[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Double> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test((Double)Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Long.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    tab[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(DoublePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test(Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Long.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    tab[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof InternalDoubleCollectionOps) {
            return this.removeAll(thisC, (InternalDoubleCollectionOps)((Object)c));
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block12: {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !c.contains(Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Long.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    tab[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull DoubleCollection c) {
        if (c instanceof InternalDoubleCollectionOps) {
            return this.removeAll(thisC, (InternalDoubleCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block12: {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !c.contains(Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Long.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    tab[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull InternalDoubleCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Long.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    tab[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof DoubleCollection) {
            return this.retainAll(thisC, (DoubleCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block13: {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Long.MAX_VALUE;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    tab[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull DoubleCollection c) {
        if (c instanceof InternalDoubleCollectionOps) {
            return this.retainAll(thisC, (InternalDoubleCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block13: {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Long.MAX_VALUE;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    tab[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull InternalDoubleCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block12: {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Long.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    tab[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved) {
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        for (int i = firstDelayedRemoved; i >= 0; i -= 2) {
            long keyToShift;
            int indexToRemove;
            if (tab[i] != Long.MAX_VALUE) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                if (keyToShift != Long.MAX_VALUE && (LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + i) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
            this.postRemoveHook();
        }
    }

    @Override
    public DoubleIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public DoubleCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements DoubleDoubleCursor {
        long[] tab;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index || mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(double value) {
            if (this.curKey == 0x7FFFFFFFFFFFFFFEL) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.tab[this.index + 1] = Double.doubleToLongBits(value);
            if (this.tab == MutableLHashParallelKVDoubleDoubleMapGO.this.table) return;
            MutableLHashParallelKVDoubleDoubleMapGO.this.table[this.index + 1] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            if (curKey == 0x7FFFFFFFFFFFFFFEL) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVDoubleDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVDoubleDoubleMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        long[] tab;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index || mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            if (curKey == 0x7FFFFFFFFFFFFFFEL) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVDoubleDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVDoubleDoubleMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        long[] tab;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        double next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            this.capacityMask = tab.length - 2;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = Double.longBitsToDouble(tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    double prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        if (tab[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = Double.longBitsToDouble(tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVDoubleDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = Double.longBitsToDouble(tab[indexToShift + 1]);
                                }
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVDoubleDoubleMapGO.this.justRemove(tab[index]);
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Double>> {
        long[] tab;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry2(mc, i, key, tab[i + 1]));
            }
            if (index != this.index || mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Double> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            if (curKey == 0x7FFFFFFFFFFFFFFEL) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVDoubleDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVDoubleDoubleMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, long key, long value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(long newValue) {
                if (NoRemovedEntryCursor.this.tab == MutableLHashParallelKVDoubleDoubleMapGO.this.table) {
                    NoRemovedEntryCursor.this.tab[NoRemovedEntryCursor.this.index + 1] = newValue;
                } else {
                    MutableLHashParallelKVDoubleDoubleMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Double>> {
        long[] tab;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            this.capacityMask = tab.length - 2;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new MutableEntry2(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry2(mc, i, key, tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Double> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = new MutableEntry2(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVDoubleDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = new MutableEntry2(MutableLHashParallelKVDoubleDoubleMapGO.this.modCount(), indexToShift, keyToShift, tab[indexToShift + 1]);
                                }
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVDoubleDoubleMapGO.this.justRemove(tab[index]);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, long key, long value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(long newValue) {
                if (NoRemovedEntryIterator.this.tab == MutableLHashParallelKVDoubleDoubleMapGO.this.table) {
                    NoRemovedEntryIterator.this.tab[NoRemovedEntryIterator.this.index + 1] = newValue;
                } else {
                    MutableLHashParallelKVDoubleDoubleMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(long bits) {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(tab[i + 1]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeDouble(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public DoubleCursor cursor() {
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(Double.longBitsToDouble(tab[i + 1])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeDouble(long bits) {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            MutableLHashParallelKVDoubleDoubleMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Double> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || !filter.test((Double)Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(DoublePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || !filter.test(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.removeAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || !c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.removeAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || !c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || !c.contains(tab[i + 1])) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.retainAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block13: {
                    if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.retainAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block13: {
                    if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(tab[i + 1])) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends DoubleDoubleEntry {
        private long key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends DoubleDoubleEntry {
        final int modCount;
        private final int index;
        final long key;
        private long value;

        MutableEntry(int modCount, int index, long key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Double setValue(Double newValue) {
            long unwrappedNewValue;
            if (this.modCount != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            double oldValue = Double.longBitsToDouble(this.value);
            this.value = unwrappedNewValue = Double.doubleToLongBits(newValue);
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            MutableLHashParallelKVDoubleDoubleMapGO.this.table[this.index + 1] = newValue;
        }
    }

    abstract class DoubleDoubleEntry
    extends AbstractEntry<Double, Double> {
        DoubleDoubleEntry() {
        }

        abstract long key();

        @Override
        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract long value();

        @Override
        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Double>>
    implements HashObjSet<Map.Entry<Double, Double>>,
    InternalObjCollectionOps<Map.Entry<Double, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Double, Double>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.size();
        }

        public double currentLoad() {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashParallelKVDoubleDoubleMapGO.this.containsEntry((Double)e.getKey(), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Double, Double>> iterator() {
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Double>> cursor() {
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(Double.longBitsToDouble(tab[i + 1]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashParallelKVDoubleDoubleMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                double value = (Double)e.getValue();
                return MutableLHashParallelKVDoubleDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Double>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test(new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block13: {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL || !c.contains(e.with(key, tab[i + 1]))) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVDoubleDoubleMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVDoubleDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(e.with(key, tab[i + 1]))) continue;
                    MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Long.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVDoubleDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableLHashParallelKVDoubleDoubleMapGO.this.clear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableParallelKVDoubleLHashGO.NoRemovedCursor {
        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashParallelKVDoubleDoubleMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            long curKey = this.curKey;
            if (curKey == 0x7FFFFFFFFFFFFFFEL) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVDoubleDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVDoubleDoubleMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableParallelKVDoubleLHashGO.NoRemovedIterator {
        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashParallelKVDoubleDoubleMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVDoubleDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVDoubleDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVDoubleDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.ParallelKVDoubleKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = Double.longBitsToDouble(keyToShift);
                                }
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashParallelKVDoubleDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVDoubleDoubleMapGO.this.justRemove(tab[index]);
            }
        }
    }
}

