/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.ShortCollection;
import net.openhft.koloboke.collect.ShortCursor;
import net.openhft.koloboke.collect.ShortIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.AbstractShortValueView;
import net.openhft.koloboke.collect.impl.CommonFloatShortMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalFloatShortMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.MutableQHashSeparateKVFloatShortMapSO;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVFloatShortQHash;
import net.openhft.koloboke.collect.map.FloatShortCursor;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.ShortSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.FloatShortConsumer;
import net.openhft.koloboke.function.FloatShortPredicate;
import net.openhft.koloboke.function.FloatShortToShortFunction;
import net.openhft.koloboke.function.FloatToShortFunction;
import net.openhft.koloboke.function.ShortBinaryOperator;
import net.openhft.koloboke.function.ShortConsumer;
import net.openhft.koloboke.function.ShortPredicate;

public class MutableQHashSeparateKVFloatShortMapGO
extends MutableQHashSeparateKVFloatShortMapSO {
    @Override
    final void copy(SeparateKVFloatShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVFloatShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(float key, short value) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public boolean containsEntry(int key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public short get(float key) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Short getOrDefault(Object key, Short defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public short getOrDefault(float key, short defaultValue) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Float, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)), (Short)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(FloatShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(FloatShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public FloatShortCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatShortMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalFloatShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalFloatShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Float, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacity = newKeys.length;
        short[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            int index = QHash.SeparateKVFloatKeyMixing.mix(key) % capacity;
            if (newKeys[index] != 0x7FFFFFFE) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] == 0x7FFFFFFE) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] == 0x7FFFFFFE) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Short put(Float key, Short value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public short put(float key, short value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Short putIfAbsent(Float key, Short value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public short putIfAbsent(float key, short value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(float key, short value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public void justPut(int key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Short compute(Float key, BiFunction<? super Float, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int index;
        short[] vals;
        int k;
        block25: {
            k = Float.floatToIntBits(key.floatValue());
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                Short newValue2;
                block26: {
                    if (cur != 0x7FFFFFFE) {
                        Short newValue3;
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFE) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Short)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = Integer.MAX_VALUE;
        this.postRemoveHook();
        return null;
    }

    public short compute(float key, FloatShortToShortFunction remappingFunction) {
        short newValue;
        int index;
        short[] vals;
        int k;
        block22: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                block23: {
                    if (cur != 0x7FFFFFFE) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFE) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        short newValue2 = remappingFunction.applyAsShort(Float.intBitsToFloat(k), this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsShort(Float.intBitsToFloat(k), this.defaultValue());
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(Float.intBitsToFloat(k), vals[index]);
        return newValue;
    }

    @Override
    public Short computeIfAbsent(Float key, Function<? super Float, ? extends Short> mappingFunction) {
        Short value;
        int k;
        block24: {
            k = Float.floatToIntBits(key.floatValue());
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int[] keys = this.set;
            short[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur == k) {
                return vals[index];
            }
            if (cur != 0x7FFFFFFE) {
                Short value2;
                int firstRemoved;
                if (cur <= 0x7FFFFFFE) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                return vals[bIndex];
                            }
                            if (cur == 0x7FFFFFFE) {
                                index = bIndex;
                                break block24;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                return vals[fIndex];
                            }
                            if (cur == 0x7FFFFFFE) {
                                index = fIndex;
                                break block24;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        return vals[bIndex];
                    }
                    if (cur == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        return vals[fIndex];
                    }
                    if (cur == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)))) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = k;
                    vals[firstRemoved] = value2;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(float key, FloatToShortFunction mappingFunction) {
        int k;
        block22: {
            k = Float.floatToIntBits(key);
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int[] keys = this.set;
            short[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur == k) {
                return vals[index];
            }
            if (cur != 0x7FFFFFFE) {
                int firstRemoved;
                if (cur <= 0x7FFFFFFE) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                return vals[bIndex];
                            }
                            if (cur == 0x7FFFFFFE) {
                                index = bIndex;
                                break block22;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                return vals[fIndex];
                            }
                            if (cur == 0x7FFFFFFE) {
                                index = fIndex;
                                break block22;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        return vals[bIndex];
                    }
                    if (cur == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block22;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        return vals[fIndex];
                    }
                    if (cur == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block22;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                short value = mappingFunction.applyAsShort(Float.intBitsToFloat(k));
                this.incrementModCount();
                keys[firstRemoved] = k;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        short value = mappingFunction.applyAsShort(Float.intBitsToFloat(k));
        this.incrementModCount();
        keys[index] = k;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    @Override
    public Short computeIfPresent(Float key, BiFunction<? super Float, ? super Short, ? extends Short> remappingFunction) {
        int k = Float.floatToIntBits(key.floatValue());
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            Short newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Short)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = Integer.MAX_VALUE;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public short computeIfPresent(float key, FloatShortToShortFunction remappingFunction) {
        int k = Float.floatToIntBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            short newValue;
            short[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsShort(Float.intBitsToFloat(k), vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Short merge(Float key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int index;
        short[] vals;
        block24: {
            int k = Float.floatToIntBits(key.floatValue());
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                block25: {
                    if (cur != 0x7FFFFFFE) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFE) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Short)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = Integer.MAX_VALUE;
        this.postRemoveHook();
        return null;
    }

    public short merge(float key, short value, ShortBinaryOperator remappingFunction) {
        short newValue;
        int index;
        short[] vals;
        block22: {
            int k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                block23: {
                    if (cur != 0x7FFFFFFE) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFE) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(vals[index], value);
        return newValue;
    }

    public short addValue(float key, short value) {
        short newValue;
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return value;
        }
        short[] vals = this.values;
        vals[index] = newValue = (short)(vals[index] + value);
        return newValue;
    }

    public short addValue(float key, short addition, short defaultValue) {
        short newValue;
        short value;
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value = (short)(defaultValue + addition));
        if (index < 0) {
            return value;
        }
        short[] vals = this.values;
        vals[index] = newValue = (short)(vals[index] + addition);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Float, ? extends Short> m) {
        CommonFloatShortMapOps.putAll(this, m);
    }

    @Override
    public Short replace(Float key, Short value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public short replace(float key, short value) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Float key, Short oldValue, Short newValue) {
        return this.replace(key.floatValue(), (short)oldValue, (short)newValue);
    }

    @Override
    public boolean replace(float key, short oldValue, short newValue) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Float, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            vals[i] = function.apply(Float.valueOf(Float.intBitsToFloat(key)), (Short)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(FloatShortToShortFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            vals[i] = function.applyAsShort(Float.intBitsToFloat(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    @Override
    public Short remove(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                step += 2;
            }
        }
        short val = this.values[index];
        this.incrementModCount();
        keys[index] = Integer.MAX_VALUE;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean justRemove(float key) {
        int k = Float.floatToIntBits(key);
        int[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = Integer.MAX_VALUE;
        this.postRemoveHook();
        return true;
    }

    @Override
    public boolean justRemove(int key) {
        int[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix(key) % capacity;
        int cur = keys[index];
        if (cur != key) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = Integer.MAX_VALUE;
        this.postRemoveHook();
        return true;
    }

    public short remove(float key) {
        int k = Float.floatToIntBits(key);
        int[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        short val = this.values[index];
        this.incrementModCount();
        keys[index] = Integer.MAX_VALUE;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), (Short)value);
    }

    public boolean remove(float key, short value) {
        int k = Float.floatToIntBits(key);
        int[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                step += 2;
            }
        }
        if (this.values[index] == value) {
            this.incrementModCount();
            keys[index] = Integer.MAX_VALUE;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeIf(FloatShortPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || !filter.test(Float.intBitsToFloat(key), vals[i])) continue;
            this.incrementModCount();
            ++mc;
            keys[i] = Integer.MAX_VALUE;
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements FloatShortCursor {
        final int[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        int curKey;
        short curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
            this.keys[this.index] = Integer.MAX_VALUE;
            MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements FloatShortCursor {
        final int[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        int curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
            this.keys[this.index] = Integer.MAX_VALUE;
            MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ShortCursor {
        final int[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        int curKey;
        short curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public short elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
            this.keys[this.index] = Integer.MAX_VALUE;
            MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ShortIterator {
        final int[] keys;
        final short[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFE) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept((Short)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
            this.keys[index] = Integer.MAX_VALUE;
            MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final int[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        int curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public short elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
            this.keys[this.index] = Integer.MAX_VALUE;
            MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final int[] keys;
        final short[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFE) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept((Short)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
            this.keys[index] = Integer.MAX_VALUE;
            MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Short>> {
        final int[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        int curKey;
        short curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Short> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
            this.keys[this.index] = Integer.MAX_VALUE;
            MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Short>> {
        final int[] keys;
        final short[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
            this.keys[index] = Integer.MAX_VALUE;
            MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Short>> {
        final int[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        int curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Short> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
            this.keys[this.index] = Integer.MAX_VALUE;
            MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Short>> {
        final int[] keys;
        final short[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
            this.keys[index] = Integer.MAX_VALUE;
            MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVFloatShortMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVFloatShortMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashSeparateKVFloatShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return MutableQHashSeparateKVFloatShortMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept((Short)vals[i]);
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= s.removeShort(vals[i]);
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVFloatShortMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVFloatShortMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return MutableQHashSeparateKVFloatShortMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVFloatShortMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || !filter.test((Short)vals[i])) continue;
                MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Integer.MAX_VALUE;
                MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(ShortPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || !filter.test(vals[i])) continue;
                MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Integer.MAX_VALUE;
                MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.removeAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || !c.contains(vals[i])) continue;
                MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Integer.MAX_VALUE;
                MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || !c.contains(vals[i])) continue;
                MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Integer.MAX_VALUE;
                MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.retainAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || c.contains(vals[i])) continue;
                MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Integer.MAX_VALUE;
                MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || c.contains(vals[i])) continue;
                MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Integer.MAX_VALUE;
                MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends FloatShortEntry {
        private int key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends FloatShortEntry {
        final int modCount;
        private final int index;
        final int key;
        private short value;

        MutableEntry(int modCount, int index, int key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        @Override
        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            MutableQHashSeparateKVFloatShortMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class FloatShortEntry
    extends AbstractEntry<Float, Short> {
        FloatShortEntry() {
        }

        abstract int key();

        @Override
        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract short value();

        @Override
        public final Short getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Short>>
    implements HashObjSet<Map.Entry<Float, Short>>,
    InternalObjCollectionOps<Map.Entry<Float, Short>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Float, Short>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVFloatShortMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVFloatShortMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashSeparateKVFloatShortMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVFloatShortMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), (short)((Short)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Float, Short>> iterator() {
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVFloatShortMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Short>> cursor() {
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVFloatShortMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVFloatShortMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVFloatShortMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                short value = (Short)e.getValue();
                return MutableQHashSeparateKVFloatShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Short>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Integer.MAX_VALUE;
                MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !c.contains(e.with(key, vals[i]))) continue;
                MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Integer.MAX_VALUE;
                MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVFloatShortMapGO.this.modCount();
            int[] keys = MutableQHashSeparateKVFloatShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVFloatShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains(e.with(key, vals[i]))) continue;
                MutableQHashSeparateKVFloatShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Integer.MAX_VALUE;
                MutableQHashSeparateKVFloatShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVFloatShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVFloatShortMapGO.this.clear();
        }
    }
}

