/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.koloboke.collect.hash.HashOverflowException;
import net.openhft.koloboke.collect.impl.ByteArrays;
import net.openhft.koloboke.collect.impl.PrimitiveConstants;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.HashConfigWrapper;
import net.openhft.koloboke.collect.impl.hash.MutableQHash;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVByteQHash;

public abstract class MutableSeparateKVByteQHashSO
extends MutableQHash
implements SeparateKVByteQHash,
PrimitiveConstants,
UnsafeConstants {
    byte freeValue;
    byte removedValue;
    byte[] set;

    void copy(SeparateKVByteQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.set = (byte[])hash.keys().clone();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    void move(SeparateKVByteQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.set = hash.keys();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    final void init(HashConfigWrapper configWrapper, int size, byte freeValue, byte removedValue) {
        this.freeValue = freeValue;
        this.removedValue = removedValue;
        super.init(configWrapper, size);
    }

    @Override
    public byte freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return true;
    }

    @Override
    public byte removedValue() {
        return this.removedValue;
    }

    public boolean contains(Object key) {
        return this.contains((Byte)key);
    }

    public boolean contains(byte key) {
        return this.index(key) >= 0;
    }

    int index(byte key) {
        byte free = this.freeValue;
        if (key != free && key != this.removedValue) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }

    private byte findNewFreeOrRemoved() {
        byte newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 254) {
                throw new HashOverflowException();
            }
            byte free = this.freeValue;
            byte removed = this.removedValue;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (size > 192) {
                int nf = ((Random)random).nextInt(256) * 97;
                for (int i = 0; i < 256; ++i) {
                    newFree = (byte)(nf += 97);
                    if (newFree == free || newFree == removed || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (byte)((Random)random).nextInt()) == free || newFree == removed || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    byte changeFree() {
        int mc = this.modCount();
        byte newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ByteArrays.replaceAll(this.set, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    byte changeRemoved() {
        int mc = this.modCount();
        byte newRemoved = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ++mc;
        if (!this.noRemoved()) {
            ByteArrays.replaceAll(this.set, this.removedValue, newRemoved);
        }
        this.removedValue = newRemoved;
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newRemoved;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new byte[capacity];
        if (this.freeValue != 0) {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, this.freeValue);
    }

    @Override
    void removeAt(int index) {
        this.set[index] = this.removedValue;
    }
}

