/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractObjValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.CommonShortObjMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalShortObjMapOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVShortObjLHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableLHashSeparateKVShortObjMapSO;
import net.openhft.koloboke.collect.map.ShortObjCursor;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.ShortFunction;
import net.openhft.koloboke.function.ShortObjConsumer;
import net.openhft.koloboke.function.ShortObjFunction;
import net.openhft.koloboke.function.ShortObjPredicate;

public class UpdatableLHashSeparateKVShortObjMapGO<V>
extends UpdatableLHashSeparateKVShortObjMapSO<V> {
    @Override
    final void copy(SeparateKVShortObjLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVShortObjLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public Equivalence<V> valueEquivalence() {
        return Equivalence.defaultEquality();
    }

    @Override
    public boolean containsEntry(short key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.values[index], value);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V get(short key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public V getOrDefault(short key, V defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Short, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ShortObjConsumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ShortObjPredicate<? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ShortObjCursor<V> cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortObjMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalShortObjMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalShortObjMapOps<? super V> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Short, V>> entrySet() {
        return new EntryView();
    }

    @Override
    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            hashCode += key ^ this.nullableValueHashCode(vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            Object val = vals[i];
            sb.append(val != this ? val : "(this Map)");
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        short[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        Object[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            int index = LHash.SeparateKVShortKeyMixing.mix(key) & capacityMask;
            if (newKeys[index] != free) {
                while (newKeys[index = index - 1 & capacityMask] != free) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public V put(Short key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    @Override
    public V put(short key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    @Override
    public V putIfAbsent(Short key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    @Override
    public V putIfAbsent(short key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    @Override
    public void justPut(short key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public V compute(Short key, BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVShortKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply(k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(k, vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public V compute(short key, ShortObjFunction<? super V, ? extends V> remappingFunction) {
        block5: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVShortKeyMixing.mix(key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block5;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                if ((newValue = remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return (V)newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(key, vals[index])) != null) {
            vals[index] = newValue;
            return (V)newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public V computeIfAbsent(Short key, Function<? super Short, ? extends V> mappingFunction) {
        block6: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVShortKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block6;
            if (cur == free) ** GOTO lbl16
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((value = mappingFunction.apply(k)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = value;
                    this.postInsertHook();
                    return value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        value = mappingFunction.apply(k);
        if (value != null) {
            vals[index] = value;
            return value;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public V computeIfAbsent(short key, ShortFunction<? extends V> mappingFunction) {
        block6: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVShortKeyMixing.mix(key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block6;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                if ((value = mappingFunction.apply(key)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value;
                    this.postInsertHook();
                    return (V)value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        value = mappingFunction.apply(key);
        if (value != null) {
            vals[index] = value;
            return (V)value;
        }
        return null;
    }

    @Override
    public V computeIfPresent(Short key, BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
        short k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                V newValue = remappingFunction.apply(k, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return newValue;
                }
                throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
            }
            return null;
        }
        return null;
    }

    public V computeIfPresent(short key, ShortObjFunction<? super V, ? extends V> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                Object newValue = remappingFunction.apply(key, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return (V)newValue;
                }
                throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
            }
            return null;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public V merge(Short key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        block6: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVShortKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block6;
            if (cur == free) ** GOTO lbl18
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
        }
        vals[index] = value;
        return value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public V merge(short key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        block6: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVShortKeyMixing.mix(key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block6;
            if (cur == free) ** GOTO lbl17
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl17:
                // 2 sources

                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
        }
        vals[index] = value;
        return value;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Short, ? extends V> m) {
        CommonShortObjMapOps.putAll(this, m);
    }

    @Override
    public V replace(Short key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public V replace(short key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public boolean replace(Short key, V oldValue, V newValue) {
        return this.replace((short)key, oldValue, newValue);
    }

    @Override
    public boolean replace(short key, V oldValue, V newValue) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            if (this.nullableValueEquals(vals[index], oldValue)) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Short, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ShortObjFunction<? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(short key) {
        throw new UnsupportedOperationException();
    }

    public V remove(short key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, value);
    }

    public boolean remove(short key, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortObjPredicate<? super V> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ShortObjCursor<V> {
        final short[] keys;
        final V[] vals;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        V curValue;

        NoRemovedMapCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            this.curKey = free = (this.free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue);
        }

        public void forEachForward(ShortObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            V[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                short[] keys = this.keys;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    short key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        final short[] keys;
        final V[] vals;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        V curValue;

        NoRemovedValueCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            this.curKey = free = (this.free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            V[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                short[] keys = this.keys;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    short key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        final short[] keys;
        final V[] vals;
        final short free;
        int expectedModCount;
        int nextIndex;
        V next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            this.vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            short free = this.free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            V[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                    short[] keys = this.keys;
                    short free = this.free;
                    Object prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, V>> {
        final short[] keys;
        final V[] vals;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        V curValue;

        NoRemovedEntryCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            this.curKey = free = (this.free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            V[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, V> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                short[] keys = this.keys;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    short key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, V>> {
        final short[] keys;
        final V[] vals;
        final short free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            this.vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            short free = this.free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                short key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            V[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, V> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                    short[] keys = this.keys;
                    short free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        short key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return UpdatableLHashSeparateKVShortObjMapGO.this.valueEquivalence();
        }

        @Override
        public int size() {
            return UpdatableLHashSeparateKVShortObjMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashSeparateKVShortObjMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableLHashSeparateKVShortObjMapGO.this.containsValue(o);
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.remove(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        @Nonnull
        public ObjIterator<V> iterator() {
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object val;
                if (keys[i] == free) continue;
                sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return UpdatableLHashSeparateKVShortObjMapGO.this.removeValue(o);
        }

        @Override
        public void clear() {
            UpdatableLHashSeparateKVShortObjMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ShortObjEntry {
        private short key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ShortObjEntry {
        final int modCount;
        private final int index;
        final short key;
        private V value;

        MutableEntry(int modCount, int index, short key, V value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            if (this.modCount != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            Object oldValue = this.value;
            Object unwrappedNewValue = newValue;
            this.value = unwrappedNewValue;
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(V newValue) {
            UpdatableLHashSeparateKVShortObjMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ShortObjEntry
    extends AbstractEntry<Short, V> {
        ShortObjEntry() {
        }

        abstract short key();

        @Override
        public final Short getKey() {
            return this.key();
        }

        abstract V value();

        @Override
        public final V getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                Object v2 = e2.getValue();
                return this.key() == k2 && UpdatableLHashSeparateKVShortObjMapGO.this.nullableValueEquals(this.value(), v2);
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ UpdatableLHashSeparateKVShortObjMapGO.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, V>>
    implements HashObjSet<Map.Entry<Short, V>>,
    InternalObjCollectionOps<Map.Entry<Short, V>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Short, V>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), UpdatableLHashSeparateKVShortObjMapGO.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashSeparateKVShortObjMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableLHashSeparateKVShortObjMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableLHashSeparateKVShortObjMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashSeparateKVShortObjMapGO.this.containsEntry((Short)e.getKey(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Short, V>> iterator() {
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, V>> cursor() {
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableLHashSeparateKVShortObjMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashSeparateKVShortObjMapGO.this.modCount();
            short free = UpdatableLHashSeparateKVShortObjMapGO.this.freeValue;
            short[] keys = UpdatableLHashSeparateKVShortObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVShortObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Collection)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashSeparateKVShortObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashSeparateKVShortObjMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                Object value = e.getValue();
                return UpdatableLHashSeparateKVShortObjMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, V>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableLHashSeparateKVShortObjMapGO.this.clear();
        }
    }
}

