/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.LongCursor;
import net.openhft.koloboke.collect.impl.CommonLongCollectionOps;
import net.openhft.koloboke.collect.impl.CommonSetOps;
import net.openhft.koloboke.collect.impl.InternalLongCollectionOps;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVLongQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableLongQHashSetSO;
import net.openhft.koloboke.collect.set.hash.HashLongSet;

public class UpdatableQHashLongSetGO
extends UpdatableLongQHashSetSO
implements HashLongSet,
InternalLongCollectionOps {
    @Override
    final void copy(SeparateKVLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonLongCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public LongCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Long e) {
        return this.add((long)e);
    }

    public boolean add(long key) {
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
        long cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Long> c) {
        return CommonLongCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeLong((Long)key);
    }

    @Override
    boolean justRemove(long key) {
        return this.removeLong(key);
    }

    public boolean removeLong(long key) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

