/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.McoServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.LongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.LongRunningTask;
import com.mojang.realmsclient.gui.McoWorldTemplateScreen;
import com.mojang.realmsclient.gui.ScreenWithCallback;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class StartMinigameWorldScreen
extends ScreenWithCallback<WorldTemplate> {
    private static final Logger LOGGER = LogManager.getLogger();
    private RealmsScreen lastScreen;
    private McoServer serverData;
    private final int START_BUTTON_ID = 1;
    private final int CANCEL_BUTTON = 2;
    private static int WORLD_TEMPLATE_BUTTON = 3;
    private WorldTemplate selectedWorldTemplate;
    private RealmsButton startButton;

    public StartMinigameWorldScreen(RealmsScreen lastScreen, McoServer serverData) {
        this.lastScreen = lastScreen;
        this.serverData = serverData;
    }

    public void tick() {
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.startButton = StartMinigameWorldScreen.newButton((int)1, (int)(this.width() / 2 - 100), (int)(this.height() / 4 + 120 + 12), (int)97, (int)20, (String)StartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.startButton"));
        this.buttonsAdd(this.startButton);
        this.buttonsAdd(StartMinigameWorldScreen.newButton((int)2, (int)(this.width() / 2 + 5), (int)(this.height() / 4 + 120 + 12), (int)97, (int)20, (String)StartMinigameWorldScreen.getLocalizedString((String)"gui.cancel")));
        this.startButton.active(this.selectedWorldTemplate != null);
        if (this.selectedWorldTemplate == null) {
            this.buttonsAdd(StartMinigameWorldScreen.newButton((int)WORLD_TEMPLATE_BUTTON, (int)(this.width() / 2 - 100), (int)102, (int)200, (int)20, (String)StartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.noSelection")));
        } else {
            this.buttonsAdd(StartMinigameWorldScreen.newButton((int)WORLD_TEMPLATE_BUTTON, (int)(this.width() / 2 - 100), (int)102, (int)200, (int)20, (String)this.selectedWorldTemplate.name));
        }
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 28 || eventKey == 156) {
            this.buttonClicked(this.startButton);
        }
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 2) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        } else if (button.id() == 1) {
            this.startMinigame();
        } else if (button.id() == WORLD_TEMPLATE_BUTTON) {
            Realms.setScreen((RealmsScreen)new McoWorldTemplateScreen(this, this.selectedWorldTemplate, true));
        }
    }

    private void startMinigame() {
        StartMinigameTask startMinigameTask = new StartMinigameTask(this.serverData.id, this.selectedWorldTemplate);
        LongRunningMcoTaskScreen longRunningMcoTaskScreen = new LongRunningMcoTaskScreen(this.lastScreen, startMinigameTask);
        longRunningMcoTaskScreen.start();
        Realms.setScreen((RealmsScreen)longRunningMcoTaskScreen);
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(StartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.title"), this.width() / 2, 17, 0xFFFFFF);
        this.drawCenteredString(StartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.info1"), this.width() / 2, 56, 0xFFFFFF);
        this.drawCenteredString(StartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.info2"), this.width() / 2, 68, 0xFFFFFF);
        this.drawString(StartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.selected"), this.width() / 2 - 100, 90, 0xA0A0A0);
        super.render(xm, ym, a);
    }

    @Override
    void callback(WorldTemplate worldTemplate) {
        this.selectedWorldTemplate = worldTemplate;
    }

    private class StartMinigameTask
    extends LongRunningTask {
        private final long worldId;
        private final WorldTemplate worldTemplate;

        public StartMinigameTask(long worldId, WorldTemplate worldTemplate) {
            this.worldId = worldId;
            this.worldTemplate = worldTemplate;
        }

        @Override
        public void run() {
            RealmsClient client = RealmsClient.createRealmsClient();
            String title = RealmsScreen.getLocalizedString((String)"mco.minigame.world.starting.screen.title");
            this.setTitle(title);
            try {
                if (this.aborted()) {
                    return;
                }
                Boolean result = client.putIntoMinigameMode(this.worldId, this.worldTemplate.id);
                Thread.sleep(2000L);
                if (result.booleanValue()) {
                    McoServer serverData = StartMinigameWorldScreen.this.serverData;
                    serverData.worldType = McoServer.WorldType.MINIGAME;
                    serverData.motd = this.worldTemplate.id;
                }
                if (this.aborted()) {
                    return;
                }
                Realms.setScreen((RealmsScreen)StartMinigameWorldScreen.this.lastScreen);
            }
            catch (RealmsServiceException e) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't start mini game!");
                this.error(e.toString());
            }
            catch (Exception e) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't start mini game!");
                this.error(e.toString());
            }
        }
    }
}

