/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.asm.FMLSanityChecker;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameData$GameDataSnapshot;
import cpw.mods.fml.relauncher.Side;
import fgm.IiIIIiIiIIiIiiiiiiIIiiiiIIiiiIIIiiIIIIiiIIiIiiiIIiIiIIIIIiIiiIii;
import fgm.IiiIIIIIIiIIiIiiIIiIIIIiIiiiiiiIIIIIiiIIIIiiIIIiiiiIIIiIiiiiIIII;
import fgm.iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii;
import fgm.iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI;
import fgm.iiiiiIiIiiiIIiiIiiiiiIIIiIIiIIiIIIiiiIiiIiiIiiiiIiIiIiiiiiIiiiiI;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata modMetadata = this.getMetadata();
        modMetadata.modId = "FML";
        modMetadata.name = "Forge Mod Loader";
        modMetadata.version = Loader.instance().getFMLVersionString();
        modMetadata.credits = "Made possible with help from many people";
        modMetadata.authorList = Arrays.asList("cpw", "LexManos", "Player");
        modMetadata.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        modMetadata.url = "https://github.com/MinecraftForge/FML/wiki";
        modMetadata.updateUrl = "https://github.com/MinecraftForge/FML/wiki";
        modMetadata.screenshots = new String[0];
        modMetadata.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI getDataForWriting(IiiIIIIIIiIIiIiiIIiIIIIiIiiiiiiIIIIIiiIIIIiiIIIiiiiIIIiIiiiiIIII handler, iiiiiIiIiiiIIiiIiiiiiIIIiIIiIIiIIIiiiIiiIiiIiiiiIiIiIiiiiiIiiiiI info) {
        Object object;
        iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2 = new iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI();
        iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii2 = new iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii();
        for (ModContainer object52 : Loader.instance().getActiveModList()) {
            object = new iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI();
            ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object).IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ModId", object52.getModId());
            ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object).IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ModVersion", object52.getVersion());
            iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii((IiIIIiIiIIiIiiiiiiIIiiiiIIiiiIIIiiIIIIiiIIiIiiiIIiIiIIIIIiIiiIii)object);
        }
        iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ModList", iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii2);
        iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3 = new iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii();
        FMLLog.fine("Gathering id map for writing to world save %s", info.IIIIIiiiIiIiiiiIIIiiiiIiiiIiiIIiiiiIIIiIIIIiIiiiiiiiIIIiIiiiiiII());
        GameData$GameDataSnapshot gameData$GameDataSnapshot = GameData.buildItemDataList();
        for (Map.Entry entry : gameData$GameDataSnapshot.idMap.entrySet()) {
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI3 = new iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI();
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI3.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("K", (String)entry.getKey());
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI3.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("V", (Integer)entry.getValue());
            iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI3);
        }
        iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ItemData", iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3);
        iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("BlockedItemIds", GameData.getBlockedIds());
        object = new iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii();
        for (Map.Entry<String, String> entry : GameData.getBlockRegistry().getAliases().entrySet()) {
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI4 = new iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI();
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI4.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("K", entry.getKey());
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI4.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("V", entry.getValue());
            ((iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii)object).IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI4);
        }
        iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("BlockAliases", (IiIIIiIiIIiIiiiiiiIIiiiiIIiiiIIIiiIIIIiiIIiIiiiIIiIiIIIIIiIiiIii)object);
        iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii4 = new iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii();
        for (String string : gameData$GameDataSnapshot.blockSubstitutions) {
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI5 = new iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI();
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI5.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("K", string);
            iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii4.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI5);
        }
        iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("BlockSubstitutions", iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii4);
        iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii5 = new iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii();
        for (Map.Entry<String, String> entry : GameData.getItemRegistry().getAliases().entrySet()) {
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI6 = new iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI();
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI6.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("K", entry.getKey());
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI6.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("V", entry.getValue());
            iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii5.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI6);
        }
        iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ItemAliases", iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii5);
        iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii6 = new iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii();
        for (String string : gameData$GameDataSnapshot.itemSubstitutions) {
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI7 = new iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI();
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI7.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("K", string);
            iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii6.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI7);
        }
        iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ItemSubstitutions", iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii6);
        return iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2;
    }

    @Override
    public void readData(IiiIIIIIIiIIiIiiIIiIIIIiIiiiiiiIIIIIiiIIIIiiIIIiiiiIIIiIiiiiIIII handler, iiiiiIiIiiiIIiiIiiiiiIIIiIIiIIiIIIiiiIiiIiiIiiiiIiIiIiiiiiIiiiiI info, Map<String, IiIIIiIiIIiIiiiiiiIIiiiiIIiiiIIIiiIIIIiiIIiIiiiIIiIiIIIIIiIiiIii> propertyMap, iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI tag) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        List<String> list;
        if (tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ModList")) {
            list = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ModList", 10);
            for (int i = 0; i < ((iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii)((Object)list)).IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                iterator = ((iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii)((Object)list)).iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                String string = ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)((Object)iterator)).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ModId");
                object4 = ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)((Object)iterator)).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ModVersion");
                object3 = Loader.instance().getIndexedModList().get(string);
                if (object3 == null) {
                    FMLLog.log("fml.ModTracker", Level.ERROR, "This world was saved with mod %s which appears to be missing, things may not work well", string);
                    continue;
                }
                if (((String)object4).equals(object3.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", string, object4, object3.getVersion());
            }
        }
        list = null;
        if (tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ModItemData")) {
            FMLLog.info("Attempting to convert old world data to new system. This may be trouble!", new Object[0]);
            iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii2 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ModItemData", 10);
            iterator = Maps.newLinkedHashMap();
            for (int i = 0; i < iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii2.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                String string;
                object4 = iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii2.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                object3 = ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ModId");
                object2 = ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ItemType");
                int n = ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII("ItemId");
                int n2 = ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII("ordinal");
                object = ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ForcedModId") ? ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ForcedModId") : null;
                String string2 = string = ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ForcedName") ? ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ForcedName") : null;
                if (string == null) {
                    FMLLog.warning("Found unlabelled item in world save, this may cause problems. The item type %s:%d will not be present", object2, n2);
                    continue;
                }
                String string3 = String.format("%c%s:%s", Character.valueOf('\u0002'), object != null ? object : object3, string);
                iterator.put(string3, n);
            }
            list = GameData.injectWorldIDMap((Map<String, Integer>)((Object)iterator), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), true, true);
        } else if (tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ItemData")) {
            iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ItemData", 10);
            iterator = Maps.newLinkedHashMap();
            for (int i = 0; i < iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                object4 = iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                if (((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K").contains("FGM:")) continue;
                iterator.put(((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K"), ((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object4).iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII("V"));
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (!tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("BlockedItemIds")) {
                GameData.fixBrokenIds(iterator, hashSet);
            }
            for (Object object5 : (Object)tag.iIIIiIiIiiIiIiIIiIIIIIiiIIiIiiIiiiiiiIIiiIiiIiiIIiiIIIiiIIiIIIII("BlockedItemIds")) {
                hashSet.add((int)object5);
            }
            object4 = new HashMap<String, String>();
            iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("BlockAliases", 10);
            for (int i = 0; i < iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2 = iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                object4.put(iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2.iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K"), iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2.iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("V"));
            }
            object3 = Sets.newHashSet();
            if (tag.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI("BlockSubstitutions", 9)) {
                iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("BlockSubstitutions", 10);
                for (int i = 0; i < iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                    iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI3 = iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                    object3.add(iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI3.iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K"));
                }
            }
            object2 = new HashMap();
            iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ItemAliases", 10);
            for (int i = 0; i < iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI4 = iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                object2.put(iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI4.iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K"), iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI4.iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("V"));
            }
            HashSet hashSet2 = Sets.newHashSet();
            if (tag.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI("ItemSubstitutions", 9)) {
                iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ItemSubstitutions", 10);
                for (int i = 0; i < iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                    object = iIiiiiiiIIiIIIiIiiIiiiIiIIiiiiiiIIIIiIiIiiiIIIIIIIIIIIIIiiiiIIii3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                    hashSet2.add(((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)object).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K"));
                }
            }
            try {
                list = GameData.injectWorldIDMap(iterator, hashSet, object4, (Map<String, String>)object2, (Set<String>)object3, hashSet2, true, true);
            }
            catch (IllegalStateException illegalStateException) {
                object = "The world state is utterly corrupted and this save is NOT loadable\n\nThere is a high probability that a mod has broken the\nID map and there is\nNOTHING FML or Forge can do to recover this save.\n\nIf you changed your mods, try reverting the change";
                FMLLog.log(Level.FATAL, illegalStateException, (String)object, new Object[0]);
                StartupQuery.notify((String)object);
                StartupQuery.abort();
            }
        }
        if (list != null && !list.isEmpty()) {
            String string = "Forge Mod Loader could not load this save.\n\nThere are " + list.size() + " unassigned blocks and items in this save.\nYou will not be able to load until they are present again.\n\nMissing Blocks/Items:\n";
            for (String string4 : list) {
                string = string + string4 + "\n";
            }
            StartupQuery.notify(string);
            StartupQuery.abort();
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificateArray = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificateArray != null ? certificateArray[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Override
    public String getGuiClassName() {
        return "cpw.mods.fml.client.FMLConfigGuiFactory";
    }

    @Override
    public Object getMod() {
        return this;
    }
}

