/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import java.io.File;
import java.util.List;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
class ModAPIManager$APIContainer
extends DummyModContainer {
    private List<ArtifactVersion> referredMods;
    private ArtifactVersion ownerMod;
    private ArtifactVersion ourVersion;
    private String providedAPI;
    private File source;
    private String version;
    private Set<String> currentReferents;
    private Set<String> packages;
    private boolean selfReferenced;

    public ModAPIManager$APIContainer(String providedAPI, String apiVersion, File source, ArtifactVersion ownerMod) {
        this.providedAPI = providedAPI;
        this.version = apiVersion;
        this.ownerMod = ownerMod;
        this.ourVersion = new DefaultArtifactVersion(providedAPI, apiVersion);
        this.referredMods = Lists.newArrayList();
        this.source = source;
        this.currentReferents = Sets.newHashSet();
        this.packages = Sets.newHashSet();
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return "API: " + this.providedAPI;
    }

    @Override
    public String getModId() {
        return this.providedAPI;
    }

    @Override
    public List<ArtifactVersion> getDependants() {
        return this.referredMods;
    }

    @Override
    public List<ArtifactVersion> getDependencies() {
        return this.selfReferenced ? ImmutableList.of() : ImmutableList.of((Object)this.ownerMod);
    }

    @Override
    public ArtifactVersion getProcessedVersion() {
        return this.ourVersion;
    }

    public void validate(String providedAPI, String apiOwner, String apiVersion) {
    }

    @Override
    public String toString() {
        return "APIContainer{" + this.providedAPI + ":" + this.version + "}";
    }

    public void addAPIReference(String embedded) {
        if (this.currentReferents.add(embedded)) {
            this.referredMods.add(VersionParser.parseVersionReference(embedded));
        }
    }

    public void addOwnedPackage(String apiPackage) {
        this.packages.add(apiPackage);
    }

    public void addAPIReferences(List<String> candidateIds) {
        for (String string : candidateIds) {
            this.addAPIReference(string);
        }
    }

    void markSelfReferenced() {
        this.selfReferenced = true;
    }

    static /* synthetic */ Set access$000(ModAPIManager$APIContainer x0) {
        return x0.currentReferents;
    }

    static /* synthetic */ Set access$100(ModAPIManager$APIContainer x0) {
        return x0.packages;
    }

    static /* synthetic */ ArtifactVersion access$200(ModAPIManager$APIContainer x0) {
        return x0.ownerMod;
    }

    static /* synthetic */ List access$300(ModAPIManager$APIContainer x0) {
        return x0.referredMods;
    }

    static /* synthetic */ String access$400(ModAPIManager$APIContainer x0) {
        return x0.providedAPI;
    }
}

