/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModAPIManager$APIContainer;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.asm.transformers.ModAPITransformer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.ModDiscoverer;
import cpw.mods.fml.common.functions.ModIdFunction;
import cpw.mods.fml.common.versioning.VersionParser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class ModAPIManager {
    public static final ModAPIManager INSTANCE = new ModAPIManager();
    private ModAPITransformer transformer;
    private ASMDataTable dataTable;
    private Map<String, ModAPIManager$APIContainer> apiContainers;

    @ObfuscationIgnore
    public void registerDataTableAndParseAPI(ASMDataTable dataTable) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        Object object6;
        this.dataTable = dataTable;
        Set<ASMDataTable$ASMData> set = dataTable.getAll("cpw.mods.fml.common.API");
        this.apiContainers = Maps.newHashMap();
        for (ASMDataTable$ASMData object7 : set) {
            object6 = object7.getAnnotationInfo();
            object52 = object7.getClassName().substring(0, object7.getClassName().indexOf(".package-info"));
            object4 = (String)object6.get("provides");
            object3 = (String)object6.get("owner");
            object2 = (String)object6.get("apiVersion");
            object = this.apiContainers.get(object4);
            if (object == null) {
                object = new ModAPIManager$APIContainer((String)object4, (String)object2, object7.getCandidate().getModContainer(), VersionParser.parseVersionReference((String)object3));
                this.apiContainers.put((String)object4, (ModAPIManager$APIContainer)object);
            } else {
                ((ModAPIManager$APIContainer)object).validate((String)object4, (String)object3, (String)object2);
            }
            ((ModAPIManager$APIContainer)object).addOwnedPackage((String)object52);
            for (ModContainer modContainer : object7.getCandidate().getContainedMods()) {
                String string = modContainer.getModId();
                if (ModAPIManager$APIContainer.access$000((ModAPIManager$APIContainer)object).contains(string)) continue;
                FMLLog.fine("Found API %s (owned by %s providing %s) embedded in %s", object52, object3, object4, string);
                if (string.equals(object3)) continue;
                ((ModAPIManager$APIContainer)object).addAPIReference(string);
            }
        }
        for (ModAPIManager$APIContainer modAPIManager$APIContainer : this.apiContainers.values()) {
            for (Object object52 : ModAPIManager$APIContainer.access$100(modAPIManager$APIContainer)) {
                object4 = dataTable.getCandidatesFor((String)object52);
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (ModCandidate)object3.next();
                    object = Lists.transform(((ModCandidate)object2).getContainedMods(), (Function)new ModIdFunction());
                    if (object.contains(ModAPIManager$APIContainer.access$200(modAPIManager$APIContainer).getLabel()) || ModAPIManager$APIContainer.access$000(modAPIManager$APIContainer).containsAll((Collection<?>)object)) continue;
                    FMLLog.info("Found mod(s) %s containing declared API package %s (owned by %s) without associated API reference", object, object52, ModAPIManager$APIContainer.access$200(modAPIManager$APIContainer));
                    modAPIManager$APIContainer.addAPIReferences((List<String>)object);
                }
            }
            if (this.apiContainers.containsKey(ModAPIManager$APIContainer.access$200(modAPIManager$APIContainer).getLabel())) {
                object6 = ModAPIManager$APIContainer.access$200(modAPIManager$APIContainer);
                do {
                    if ((object52 = this.apiContainers.get(object6.getLabel())) == modAPIManager$APIContainer) {
                        FMLLog.finer("APIContainer %s is it's own parent. skipping", object6);
                        modAPIManager$APIContainer.markSelfReferenced();
                        break;
                    }
                    FMLLog.finer("Removing upstream parent %s from %s", ModAPIManager$APIContainer.access$200((ModAPIManager$APIContainer)object52).getLabel(), modAPIManager$APIContainer);
                    ModAPIManager$APIContainer.access$000(modAPIManager$APIContainer).remove(ModAPIManager$APIContainer.access$200((ModAPIManager$APIContainer)object52).getLabel());
                    ModAPIManager$APIContainer.access$300(modAPIManager$APIContainer).remove(ModAPIManager$APIContainer.access$200((ModAPIManager$APIContainer)object52));
                } while (this.apiContainers.containsKey((object6 = ModAPIManager$APIContainer.access$200((ModAPIManager$APIContainer)object52)).getLabel()));
            }
            FMLLog.fine("Creating API container dummy for API %s: owner: %s, dependents: %s", ModAPIManager$APIContainer.access$400(modAPIManager$APIContainer), ModAPIManager$APIContainer.access$200(modAPIManager$APIContainer), ModAPIManager$APIContainer.access$300(modAPIManager$APIContainer));
        }
    }

    @ObfuscationIgnore
    public void manageAPI(ModClassLoader modClassLoader, ModDiscoverer discoverer) {
        this.registerDataTableAndParseAPI(discoverer.getASMTable());
        this.transformer = modClassLoader.addModAPITransformer(this.dataTable);
    }

    @ObfuscationIgnore
    public void injectAPIModContainers(List<ModContainer> mods, Map<String, ModContainer> nameLookup) {
        mods.addAll(this.apiContainers.values());
        nameLookup.putAll(this.apiContainers);
    }

    @ObfuscationIgnore
    public void cleanupAPIContainers(List<ModContainer> mods) {
        mods.removeAll(this.apiContainers.values());
    }

    @ObfuscationIgnore
    public boolean hasAPI(String modId) {
        return this.apiContainers.containsKey(modId);
    }

    @ObfuscationIgnore
    public Iterable<? extends ModContainer> getAPIList() {
        return this.apiContainers.values();
    }
}

