/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import cpw.mods.fml.common.asm.transformers.AccessTransformer$1;
import cpw.mods.fml.common.asm.transformers.AccessTransformer$Modifier;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@ObfuscationIgnore
public class AccessTransformer
implements IClassTransformer {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugAccessTransformer", "false"));
    private Multimap<String, AccessTransformer$Modifier> modifiers = ArrayListMultimap.create();

    public AccessTransformer() {
        this("fml_at.cfg");
    }

    protected AccessTransformer(String rulesFile) {
        this.readMapFile(rulesFile);
    }

    AccessTransformer(Class<? extends AccessTransformer> dummyClazz) {
    }

    void readMapFile(String rulesFile) {
        File file = new File(rulesFile);
        URL uRL = file.exists() ? file.toURI().toURL() : Resources.getResource((String)rulesFile);
        this.processATFile(Resources.asCharSource((URL)uRL, (Charset)Charsets.UTF_8));
        FMLRelaunchLog.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII("Loaded %d rules from AccessTransformer config file %s", this.modifiers.size(), rulesFile);
    }

    protected void processATFile(CharSource rulesResource) {
        rulesResource.readLines((LineProcessor)new AccessTransformer$1(this));
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (DEBUG) {
            FMLRelaunchLog.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII("Considering all methods and fields on %s (%s)\n", transformedName, name);
        }
        if (!this.modifiers.containsKey((Object)transformedName)) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Collection collection = this.modifiers.get((Object)transformedName);
        block0: for (AccessTransformer$Modifier accessTransformer$Modifier : collection) {
            if (accessTransformer$Modifier.modifyClassVisibility) {
                classNode.access = this.getFixedAccess(classNode.access, accessTransformer$Modifier);
                if (!DEBUG) continue;
                System.out.println(String.format("Class: %s %s -> %s", name, this.toBinary(accessTransformer$Modifier.oldAccess), this.toBinary(accessTransformer$Modifier.newAccess)));
                continue;
            }
            if (accessTransformer$Modifier.desc.isEmpty()) {
                for (FieldNode fieldNode : classNode.fields) {
                    if (!fieldNode.name.equals(accessTransformer$Modifier.name) && !accessTransformer$Modifier.name.equals("*")) continue;
                    fieldNode.access = this.getFixedAccess(fieldNode.access, accessTransformer$Modifier);
                    if (DEBUG) {
                        System.out.println(String.format("Field: %s.%s %s -> %s", name, fieldNode.name, this.toBinary(accessTransformer$Modifier.oldAccess), this.toBinary(accessTransformer$Modifier.newAccess)));
                    }
                    if (accessTransformer$Modifier.name.equals("*")) continue;
                    continue block0;
                }
                continue;
            }
            ArrayList arrayList = Lists.newArrayList();
            for (MethodNode methodNode : classNode.methods) {
                if ((!methodNode.name.equals(accessTransformer$Modifier.name) || !methodNode.desc.equals(accessTransformer$Modifier.desc)) && !accessTransformer$Modifier.name.equals("*")) continue;
                methodNode.access = this.getFixedAccess(methodNode.access, accessTransformer$Modifier);
                if (!methodNode.name.equals("<init>")) {
                    boolean bl;
                    boolean bl2 = (accessTransformer$Modifier.oldAccess & 2) == 2;
                    boolean bl3 = bl = (accessTransformer$Modifier.newAccess & 2) == 2;
                    if (bl2 && !bl) {
                        arrayList.add(methodNode);
                    }
                }
                if (DEBUG) {
                    System.out.println(String.format("Method: %s.%s%s %s -> %s", name, methodNode.name, methodNode.desc, this.toBinary(accessTransformer$Modifier.oldAccess), this.toBinary(accessTransformer$Modifier.newAccess)));
                }
                if (accessTransformer$Modifier.name.equals("*")) continue;
                break;
            }
            this.replaceInvokeSpecial(classNode, arrayList);
        }
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private void replaceInvokeSpecial(ClassNode clazz, List<MethodNode> toReplace) {
        for (MethodNode methodNode : clazz.methods) {
            block1: for (AbstractInsnNode abstractInsnNode : methodNode.instructions) {
                if (abstractInsnNode.getOpcode() != 183) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                for (MethodNode methodNode2 : toReplace) {
                    if (!methodNode2.name.equals(methodInsnNode.name) || !methodNode2.desc.equals(methodInsnNode.desc)) continue;
                    methodInsnNode.setOpcode(182);
                    continue block1;
                }
            }
        }
    }

    private String toBinary(int num) {
        return String.format("%16s", Integer.toBinaryString(num)).replace(' ', '0');
    }

    private int getFixedAccess(int access, AccessTransformer$Modifier target) {
        target.oldAccess = access;
        int n = target.targetAccess;
        int n2 = access & 0xFFFFFFF8;
        switch (access & 7) {
            case 2: {
                n2 |= n;
                break;
            }
            case 0: {
                n2 |= n != 2 ? n : 0;
                break;
            }
            case 4: {
                n2 |= n != 2 && n != 0 ? n : 4;
                break;
            }
            case 1: {
                n2 |= n != 2 && n != 0 && n != 4 ? n : 1;
                break;
            }
            default: {
                throw new RuntimeException("The fuck?");
            }
        }
        if (target.changeFinal) {
            n2 = target.markFinal ? (n2 |= 0x10) : (n2 &= 0xFFFFFFEF);
        }
        target.newAccess = n2;
        return n2;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: AccessTransformer <JarPath> <MapFile> [MapFile2]... ");
            System.exit(1);
        }
        boolean bl = false;
        AccessTransformer[] accessTransformerArray = new AccessTransformer[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            try {
                accessTransformerArray[i - 1] = new AccessTransformer(args[i]);
                bl = true;
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Could not read Transformer Map: " + args[i]);
                iOException.printStackTrace();
            }
        }
        if (!bl) {
            System.out.println("Culd not find a valid transformer to perform");
            System.exit(1);
        }
        File file = new File(args[0]);
        File file2 = new File(args[0] + ".ATBack");
        if (!file.exists() && !file2.exists()) {
            System.out.println("Could not find target jar: " + file);
            System.exit(1);
        }
        if (!file.renameTo(file2)) {
            System.out.println("Could not rename file: " + file + " -> " + file2);
            System.exit(1);
        }
        try {
            AccessTransformer.processJar(file2, file, accessTransformerArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        if (!file2.delete()) {
            System.out.println("Could not delete temp file: " + file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJar(File inFile, File outFile, AccessTransformer[] transformers) {
        ZipInputStream zipInputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            ZipEntry zipEntry;
            try {
                zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException("Could not open input file: " + fileNotFoundException.getMessage());
            }
            try {
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException("Could not open output file: " + fileNotFoundException.getMessage());
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipEntry zipEntry2;
                int n;
                if (zipEntry.isDirectory()) {
                    zipOutputStream.putNextEntry(zipEntry);
                    continue;
                }
                byte[] byArray = new byte[4096];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                do {
                    if ((n = zipInputStream.read(byArray)) <= 0) continue;
                    byteArrayOutputStream.write(byArray, 0, n);
                } while (n != -1);
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                String string = zipEntry.getName();
                if (string.endsWith(".class") && !string.startsWith(".")) {
                    zipEntry2 = new ClassNode();
                    ClassReader classReader = new ClassReader(byArray2);
                    classReader.accept((ClassVisitor)zipEntry2, 0);
                    String string2 = ((ClassNode)zipEntry2).name.replace('/', '.').replace('\\', '.');
                    for (AccessTransformer accessTransformer : transformers) {
                        byArray2 = accessTransformer.transform(string2, string2, byArray2);
                    }
                }
                zipEntry2 = new ZipEntry(string);
                zipOutputStream.putNextEntry(zipEntry2);
                zipOutputStream.write(byArray2);
            }
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    Multimap<String, AccessTransformer$Modifier> getModifiers() {
        return this.modifiers;
    }

    boolean isEmpty() {
        return this.modifiers.isEmpty();
    }

    static /* synthetic */ Multimap access$100(AccessTransformer x0) {
        return x0.modifiers;
    }

    static /* synthetic */ boolean access$200() {
        return DEBUG;
    }

    static /* synthetic */ String access$300(AccessTransformer x0, int x1) {
        return x0.toBinary(x1);
    }
}

