/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@ObfuscationIgnore
public class ModAPITransformer
implements IClassTransformer {
    private static final boolean logDebugInfo = Boolean.valueOf(System.getProperty("fml.debugAPITransformer", "false"));
    private ListMultimap<String, ASMDataTable$ASMData> optionals;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        String string = name;
        if (name.endsWith("$class")) {
            string = name.substring(0, name.length() - 6);
        }
        if (this.optionals == null || !this.optionals.containsKey((Object)string)) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        if (logDebugInfo) {
            FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal - found optionals for class %s - processing", name);
        }
        for (ASMDataTable$ASMData aSMDataTable$ASMData : this.optionals.get((Object)string)) {
            String string2 = (String)aSMDataTable$ASMData.getAnnotationInfo().get("modid");
            if (Loader.isModLoaded(string2) || ModAPIManager.INSTANCE.hasAPI(string2)) {
                if (!logDebugInfo) continue;
                FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal skipped - mod present %s", string2);
                continue;
            }
            if (logDebugInfo) {
                FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional on %s triggered - mod missing %s", name, string2);
            }
            if (aSMDataTable$ASMData.getAnnotationInfo().containsKey("iface")) {
                Boolean bl = (Boolean)aSMDataTable$ASMData.getAnnotationInfo().get("striprefs");
                if (bl == null) {
                    bl = Boolean.FALSE;
                }
                this.stripInterface(classNode, (String)aSMDataTable$ASMData.getAnnotationInfo().get("iface"), bl);
                continue;
            }
            this.stripMethod(classNode, aSMDataTable$ASMData.getObjectName());
        }
        if (logDebugInfo) {
            FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal - class %s processed", name);
        }
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private void stripMethod(ClassNode classNode, String methodDescriptor) {
        Object object;
        if (classNode.name.endsWith("$class")) {
            object = classNode.name.substring(0, classNode.name.length() - 6);
            int n = methodDescriptor.indexOf(40) + 1;
            methodDescriptor = methodDescriptor.substring(0, n) + 'L' + (String)object + ';' + methodDescriptor.substring(n);
        }
        object = classNode.methods.listIterator();
        while (object.hasNext()) {
            MethodNode methodNode = (MethodNode)object.next();
            if (!methodDescriptor.equals(methodNode.name + methodNode.desc)) continue;
            object.remove();
            if (logDebugInfo) {
                FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal - method %s removed", methodDescriptor);
            }
            return;
        }
        if (logDebugInfo) {
            FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal - method %s NOT removed - not found", methodDescriptor);
        }
    }

    private void stripInterface(ClassNode classNode, String interfaceName, boolean stripRefs) {
        String string = interfaceName.replace('.', '/');
        boolean bl = classNode.interfaces.remove(string);
        if (bl && logDebugInfo) {
            FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal - interface %s removed", interfaceName);
        }
        if (!bl && logDebugInfo) {
            FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal - interface %s NOT removed - not found", interfaceName);
        }
        if (bl && stripRefs) {
            if (logDebugInfo) {
                FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal - interface %s - stripping method signature references", interfaceName);
            }
            Iterator iterator = classNode.methods.iterator();
            while (iterator.hasNext()) {
                MethodNode methodNode = (MethodNode)iterator.next();
                if (!methodNode.desc.contains(string)) continue;
                if (logDebugInfo) {
                    FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal - interface %s - stripping method containing reference %s", interfaceName, methodNode.name);
                }
                iterator.remove();
            }
            if (logDebugInfo) {
                FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal - interface %s - all method signature references stripped", interfaceName);
            }
        } else if (bl && logDebugInfo) {
            FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Optional removal - interface %s - NOT stripping method signature references", interfaceName);
        }
    }

    public void initTable(ASMDataTable dataTable) {
        this.optionals = ArrayListMultimap.create();
        Set<ASMDataTable$ASMData> set = dataTable.getAll("cpw.mods.fml.common.Optional$InterfaceList");
        this.addData(this.unpackInterfaces(set));
        Set<ASMDataTable$ASMData> set2 = dataTable.getAll("cpw.mods.fml.common.Optional$Interface");
        this.addData(set2);
        Set<ASMDataTable$ASMData> set3 = dataTable.getAll("cpw.mods.fml.common.Optional$Method");
        this.addData(set3);
    }

    private Set<ASMDataTable$ASMData> unpackInterfaces(Set<ASMDataTable$ASMData> packedInterfaces) {
        HashSet hashSet = Sets.newHashSet();
        for (ASMDataTable$ASMData aSMDataTable$ASMData : packedInterfaces) {
            List list = (List)aSMDataTable$ASMData.getAnnotationInfo().get("value");
            for (Map map : list) {
                ASMDataTable$ASMData aSMDataTable$ASMData2 = aSMDataTable$ASMData.copy(map);
                hashSet.add(aSMDataTable$ASMData2);
            }
        }
        return hashSet;
    }

    private void addData(Set<ASMDataTable$ASMData> interfaces) {
        for (ASMDataTable$ASMData aSMDataTable$ASMData : interfaces) {
            this.optionals.put((Object)aSMDataTable$ASMData.getClassName(), (Object)aSMDataTable$ASMData);
        }
    }
}

