/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

@ObfuscationIgnore
public class SideTransformer
implements IClassTransformer {
    private static String SIDE = FMLLaunchHandler.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().name();
    private static final boolean DEBUG = false;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        MethodNode methodNode;
        Object object;
        if (bytes == null) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if (this.remove(classNode.visibleAnnotations, SIDE)) {
            throw new RuntimeException(String.format("Attempted to load class %s for invalid side %s", classNode.name, SIDE));
        }
        Iterator iterator = classNode.fields.iterator();
        while (iterator.hasNext()) {
            object = (FieldNode)iterator.next();
            if (!this.remove(((FieldNode)object).visibleAnnotations, SIDE)) continue;
            iterator.remove();
        }
        object = classNode.methods.iterator();
        while (object.hasNext()) {
            methodNode = (MethodNode)object.next();
            if (!this.remove(methodNode.visibleAnnotations, SIDE)) continue;
            object.remove();
        }
        methodNode = new ClassWriter(1);
        classNode.accept((ClassVisitor)methodNode);
        return methodNode.toByteArray();
    }

    private boolean remove(List<AnnotationNode> anns, String side) {
        if (anns == null) {
            return false;
        }
        for (AnnotationNode annotationNode : anns) {
            if (!annotationNode.desc.equals(Type.getDescriptor(SideOnly.class)) || annotationNode.values == null) continue;
            for (int i = 0; i < annotationNode.values.size() - 1; i += 2) {
                Object e = annotationNode.values.get(i);
                Object e2 = annotationNode.values.get(i + 1);
                if (!(e instanceof String) || !e.equals("value") || !(e2 instanceof String[]) || ((String[])e2)[1].equals(side)) continue;
                return true;
            }
        }
        return false;
    }
}

