/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers.deobf;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import cpw.mods.fml.common.asm.transformers.deobf.LZMAInputSupplier;
import cpw.mods.fml.common.patcher.ClassPatchManager;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

@ObfuscationIgnore
public class FMLDeobfuscatingRemapper
extends Remapper {
    public static final FMLDeobfuscatingRemapper INSTANCE = new FMLDeobfuscatingRemapper();
    private BiMap<String, String> classNameBiMap;
    private Map<String, Map<String, String>> rawFieldMaps;
    private Map<String, Map<String, String>> rawMethodMaps;
    private Map<String, Map<String, String>> fieldNameMaps;
    private Map<String, Map<String, String>> methodNameMaps;
    private LaunchClassLoader classLoader;
    private static final boolean DEBUG_REMAPPING = Boolean.parseBoolean(System.getProperty("fml.remappingDebug", "false"));
    private static final boolean DUMP_FIELD_MAPS = Boolean.parseBoolean(System.getProperty("fml.remappingDebug.dumpFieldMaps", "false")) && DEBUG_REMAPPING;
    private static final boolean DUMP_METHOD_MAPS = Boolean.parseBoolean(System.getProperty("fml.remappingDebug.dumpMethodMaps", "false")) && DEBUG_REMAPPING;
    private Map<String, Map<String, String>> fieldDescriptions = Maps.newHashMap();
    private Set<String> negativeCacheMethods = Sets.newHashSet();
    private Set<String> negativeCacheFields = Sets.newHashSet();

    private FMLDeobfuscatingRemapper() {
        this.classNameBiMap = ImmutableBiMap.of();
    }

    public void setupLoadOnly(String deobfFileName, boolean loadAll) {
        try {
            File file = new File(deobfFileName);
            LZMAInputSupplier lZMAInputSupplier = new LZMAInputSupplier(new FileInputStream(file));
            CharSource charSource = lZMAInputSupplier.asCharSource(Charsets.UTF_8);
            ImmutableList immutableList = charSource.readLines();
            this.rawMethodMaps = Maps.newHashMap();
            this.rawFieldMaps = Maps.newHashMap();
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)": ")).omitEmptyStrings().trimResults();
            for (String string : immutableList) {
                String[] stringArray = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)string), String.class);
                String string2 = stringArray[0];
                if ("CL".equals(string2)) {
                    this.parseClass((ImmutableBiMap.Builder<String, String>)builder, stringArray);
                    continue;
                }
                if ("MD".equals(string2) && loadAll) {
                    this.parseMethod(stringArray);
                    continue;
                }
                if (!"FD".equals(string2) || !loadAll) continue;
                this.parseField(stringArray);
            }
            this.classNameBiMap = builder.build();
        }
        catch (IOException iOException) {
            FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(Level.ERROR, "An error occurred loading the deobfuscation map data", iOException);
        }
        this.methodNameMaps = Maps.newHashMapWithExpectedSize((int)this.rawMethodMaps.size());
        this.fieldNameMaps = Maps.newHashMapWithExpectedSize((int)this.rawFieldMaps.size());
    }

    public void setup(File mcDir, LaunchClassLoader classLoader, String deobfFileName) {
        this.classLoader = classLoader;
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(deobfFileName);
            LZMAInputSupplier lZMAInputSupplier = new LZMAInputSupplier(inputStream);
            CharSource charSource = lZMAInputSupplier.asCharSource(Charsets.UTF_8);
            ImmutableList immutableList = charSource.readLines();
            this.rawMethodMaps = Maps.newHashMap();
            this.rawFieldMaps = Maps.newHashMap();
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)": ")).omitEmptyStrings().trimResults();
            for (String string : immutableList) {
                String[] stringArray = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)string), String.class);
                String string2 = stringArray[0];
                if ("CL".equals(string2)) {
                    this.parseClass((ImmutableBiMap.Builder<String, String>)builder, stringArray);
                    continue;
                }
                if ("MD".equals(string2)) {
                    this.parseMethod(stringArray);
                    continue;
                }
                if (!"FD".equals(string2)) continue;
                this.parseField(stringArray);
            }
            this.classNameBiMap = builder.build();
        }
        catch (IOException iOException) {
            FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(Level.ERROR, iOException, "An error occurred loading the deobfuscation map data", new Object[0]);
        }
        this.methodNameMaps = Maps.newHashMapWithExpectedSize((int)this.rawMethodMaps.size());
        this.fieldNameMaps = Maps.newHashMapWithExpectedSize((int)this.rawFieldMaps.size());
    }

    public boolean isRemappedClass(String className) {
        return !this.map(className).equals(className);
    }

    private void parseField(String[] parts) {
        String string = parts[1];
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = parts[2];
        int n2 = string4.lastIndexOf(47);
        String string5 = string4.substring(n2 + 1);
        if (!this.rawFieldMaps.containsKey(string2)) {
            this.rawFieldMaps.put(string2, Maps.newHashMap());
        }
        this.rawFieldMaps.get(string2).put(string3 + ":" + this.getFieldType(string2, string3), string5);
        this.rawFieldMaps.get(string2).put(string3 + ":null", string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFieldType(String owner, String name) {
        if (this.fieldDescriptions.containsKey(owner)) {
            return this.fieldDescriptions.get(owner).get(name);
        }
        Map<String, Map<String, String>> map = this.fieldDescriptions;
        synchronized (map) {
            try {
                byte[] byArray = ClassPatchManager.INSTANCE.getPatchedResource(owner, this.map(owner).replace('/', '.'), this.classLoader);
                if (byArray == null) {
                    return null;
                }
                ClassReader classReader = new ClassReader(byArray);
                ClassNode classNode = new ClassNode();
                classReader.accept((ClassVisitor)classNode, 7);
                HashMap hashMap = Maps.newHashMap();
                for (FieldNode fieldNode : classNode.fields) {
                    hashMap.put(fieldNode.name, fieldNode.desc);
                }
                this.fieldDescriptions.put(owner, hashMap);
                return (String)hashMap.get(name);
            }
            catch (IOException iOException) {
                FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(Level.ERROR, iOException, "A critical exception occured reading a class file %s", owner);
                return null;
            }
        }
    }

    private void parseClass(ImmutableBiMap.Builder<String, String> builder, String[] parts) {
        builder.put((Object)parts[1], (Object)parts[2]);
    }

    private void parseMethod(String[] parts) {
        String string = parts[1];
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = parts[2];
        String string5 = parts[3];
        int n2 = string5.lastIndexOf(47);
        String string6 = string5.substring(n2 + 1);
        if (!this.rawMethodMaps.containsKey(string2)) {
            this.rawMethodMaps.put(string2, Maps.newHashMap());
        }
        this.rawMethodMaps.get(string2).put(string3 + string4, string6);
    }

    public String mapFieldName(String owner, String name, String desc) {
        if (this.classNameBiMap == null || this.classNameBiMap.isEmpty()) {
            return name;
        }
        Map<String, String> map = this.getFieldMap(owner);
        return map != null && map.containsKey(name + ":" + desc) ? map.get(name + ":" + desc) : name;
    }

    public String map(String typeName) {
        if (this.classNameBiMap == null || this.classNameBiMap.isEmpty()) {
            return typeName;
        }
        if (this.classNameBiMap.containsKey((Object)typeName)) {
            return (String)this.classNameBiMap.get((Object)typeName);
        }
        int n = typeName.lastIndexOf(36);
        if (n > -1) {
            return this.map(typeName.substring(0, n)) + "$" + typeName.substring(n + 1);
        }
        return typeName;
    }

    public String unmap(String typeName) {
        if (this.classNameBiMap == null || this.classNameBiMap.isEmpty()) {
            return typeName;
        }
        if (this.classNameBiMap.containsValue((Object)typeName)) {
            return (String)this.classNameBiMap.inverse().get((Object)typeName);
        }
        int n = typeName.lastIndexOf(36);
        if (n > -1) {
            return this.unmap(typeName.substring(0, n)) + "$" + typeName.substring(n + 1);
        }
        return typeName;
    }

    public String mapMethodName(String owner, String name, String desc) {
        if (this.classNameBiMap == null || this.classNameBiMap.isEmpty()) {
            return name;
        }
        Map<String, String> map = this.getMethodMap(owner);
        String string = name + desc;
        return map != null && map.containsKey(string) ? map.get(string) : name;
    }

    private Map<String, String> getFieldMap(String className) {
        if (!this.fieldNameMaps.containsKey(className) && !this.negativeCacheFields.contains(className)) {
            this.findAndMergeSuperMaps(className);
            if (!this.fieldNameMaps.containsKey(className)) {
                this.negativeCacheFields.add(className);
            }
            if (DUMP_FIELD_MAPS) {
                FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Field map for %s : %s", className, this.fieldNameMaps.get(className));
            }
        }
        return this.fieldNameMaps.get(className);
    }

    private Map<String, String> getMethodMap(String className) {
        if (!this.methodNameMaps.containsKey(className) && !this.negativeCacheMethods.contains(className)) {
            this.findAndMergeSuperMaps(className);
            if (!this.methodNameMaps.containsKey(className)) {
                this.negativeCacheMethods.add(className);
            }
            if (DUMP_METHOD_MAPS) {
                FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Method map for %s : %s", className, this.methodNameMaps.get(className));
            }
        }
        return this.methodNameMaps.get(className);
    }

    private void findAndMergeSuperMaps(String name) {
        try {
            String string = null;
            String[] stringArray = new String[]{};
            byte[] byArray = ClassPatchManager.INSTANCE.getPatchedResource(name, this.map(name), this.classLoader);
            if (byArray != null) {
                ClassReader classReader = new ClassReader(byArray);
                string = classReader.getSuperName();
                stringArray = classReader.getInterfaces();
            }
            this.mergeSuperMaps(name, string, stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void mergeSuperMaps(String name, String superName, String[] interfaces) {
        Object object2;
        if (this.classNameBiMap == null || this.classNameBiMap.isEmpty()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)superName)) {
            return;
        }
        ImmutableList immutableList = ImmutableList.builder().add((Object)superName).addAll(Arrays.asList(interfaces)).build();
        for (Object object2 : immutableList) {
            if (this.methodNameMaps.containsKey(object2)) continue;
            this.findAndMergeSuperMaps((String)object2);
        }
        HashMap hashMap = Maps.newHashMap();
        object2 = Maps.newHashMap();
        for (String string : immutableList) {
            if (this.methodNameMaps.containsKey(string)) {
                hashMap.putAll(this.methodNameMaps.get(string));
            }
            if (!this.fieldNameMaps.containsKey(string)) continue;
            object2.putAll(this.fieldNameMaps.get(string));
        }
        if (this.rawMethodMaps.containsKey(name)) {
            hashMap.putAll(this.rawMethodMaps.get(name));
        }
        if (this.rawFieldMaps.containsKey(name)) {
            object2.putAll(this.rawFieldMaps.get(name));
        }
        this.methodNameMaps.put(name, (Map<String, String>)ImmutableMap.copyOf((Map)hashMap));
        this.fieldNameMaps.put(name, (Map<String, String>)ImmutableMap.copyOf((Map)object2));
    }

    public Set<String> getObfedClasses() {
        return ImmutableSet.copyOf((Collection)this.classNameBiMap.keySet());
    }

    public String getStaticFieldType(String oldType, String oldName, String newType, String newName) {
        String string = this.getFieldType(oldType, oldName);
        if (oldType.equals(newType)) {
            return string;
        }
        HashMap hashMap = this.fieldDescriptions.get(newType);
        if (hashMap == null) {
            hashMap = Maps.newHashMap();
            this.fieldDescriptions.put(newType, hashMap);
        }
        hashMap.put(newName, string);
        return string;
    }
}

