/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.DirectoryDiscoverer$ClassFilter;
import cpw.mods.fml.common.discovery.ITypeDiscoverer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class DirectoryDiscoverer
implements ITypeDiscoverer {
    private ASMDataTable table;

    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        this.table = table;
        ArrayList arrayList = Lists.newArrayList();
        FMLLog.fine("Examining directory %s for potential mods", candidate.getModContainer().getName());
        this.exploreFileSystem("", candidate.getModContainer(), arrayList, candidate, null);
        for (ModContainer modContainer : arrayList) {
            table.addContainer(modContainer);
        }
        return arrayList;
    }

    public void exploreFileSystem(String path, File modDir, List<ModContainer> harvestedMods, ModCandidate candidate, MetadataCollection mc) {
        Object[] objectArray;
        if (path.length() == 0) {
            objectArray = new File(modDir, "mcmod.info");
            try {
                Object[] objectArray2 = new FileInputStream((File)objectArray);
                mc = MetadataCollection.from((InputStream)objectArray2, modDir.getName());
                objectArray2.close();
                FMLLog.fine("Found an mcmod.info file in directory %s", modDir.getName());
            }
            catch (Exception exception) {
                mc = MetadataCollection.from(null, "");
                FMLLog.fine("No mcmod.info file found in directory %s", modDir.getName());
            }
        }
        objectArray = modDir.listFiles(new DirectoryDiscoverer$ClassFilter(this, null));
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            Object object2;
            if (((File)object).isDirectory()) {
                FMLLog.finer("Recursing into package %s", path + ((File)object).getName());
                this.exploreFileSystem(path + ((File)object).getName() + ".", (File)object, harvestedMods, candidate, mc);
                continue;
            }
            Matcher matcher = classFile.matcher(((File)object).getName());
            if (!matcher.matches()) continue;
            ASMModParser aSMModParser = null;
            try {
                object2 = new FileInputStream((File)object);
                aSMModParser = new ASMModParser((InputStream)object2);
                ((FileInputStream)object2).close();
                candidate.addClassEntry(path + ((File)object).getName());
            }
            catch (LoaderException loaderException) {
                FMLLog.log(Level.ERROR, loaderException, "There was a problem reading the file %s - probably this is a corrupt file", ((File)object).getPath());
                throw loaderException;
            }
            catch (Exception exception) {
                Throwables.propagate((Throwable)exception);
            }
            aSMModParser.validate();
            aSMModParser.sendToTable(this.table, candidate);
            object2 = ModContainerFactory.instance().build(aSMModParser, candidate.getModContainer(), candidate);
            if (object2 == null) continue;
            harvestedMods.add((ModContainer)object2);
            object2.bindMetadata(mc);
        }
    }
}

