/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.eventhandler;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.MapMaker;
import com.google.common.reflect.TypeToken;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.ASMEventHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.IEventExceptionHandler;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.ListenerList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class EventBus
implements IEventExceptionHandler {
    @ObfuscationIgnore
    private static int maxID = 0;
    @ObfuscationIgnore
    private ConcurrentHashMap<Object, ArrayList<IEventListener>> listeners = new ConcurrentHashMap();
    @ObfuscationIgnore
    private Map<Object, ModContainer> listenerOwners = new MapMaker().weakKeys().weakValues().makeMap();
    @ObfuscationIgnore
    private final int busID = maxID++;
    @ObfuscationIgnore
    private IEventExceptionHandler exceptionHandler;

    @ObfuscationIgnore
    public EventBus() {
        ListenerList.resize(this.busID + 1);
        this.exceptionHandler = this;
    }

    @ObfuscationIgnore
    public EventBus(@Nonnull IEventExceptionHandler handler) {
        this();
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"EventBus exception handler can not be null");
        this.exceptionHandler = handler;
    }

    @ObfuscationIgnore
    public void register(Object target) {
        if (this.listeners.containsKey(target)) {
            return;
        }
        ModContainer modContainer = Loader.instance().activeModContainer();
        if (modContainer == null) {
            FMLLog.log(Level.ERROR, new Throwable(), "Unable to determine registrant mod for %s. This is a critical error and should be impossible", target);
            modContainer = Loader.instance().getMinecraftModContainer();
        }
        this.listenerOwners.put(target, modContainer);
        Set set = TypeToken.of(target.getClass()).getTypes().rawTypes();
        block2: for (Method method : target.getClass().getMethods()) {
            for (Class clazz : set) {
                try {
                    Method method2 = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    if (!method2.isAnnotationPresent(SubscribeEvent.class)) continue;
                    Class<?>[] classArray = method.getParameterTypes();
                    if (classArray.length != 1) {
                        throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but requires " + classArray.length + " arguments.  Event handler methods must require a single argument.");
                    }
                    Class<?> clazz2 = classArray[0];
                    if (!Event.class.isAssignableFrom(clazz2)) {
                        throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes a argument that is not an Event " + clazz2);
                    }
                    this.register(clazz2, target, method, modContainer);
                    continue block2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
    }

    @ObfuscationIgnore
    private void register(Class<?> eventType, Object target, Method method, ModContainer owner) {
        try {
            Constructor<?> constructor = eventType.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            Event event = (Event)constructor.newInstance(new Object[0]);
            ASMEventHandler aSMEventHandler = new ASMEventHandler(target, method, owner);
            event.getListenerList().register(this.busID, aSMEventHandler.getPriority(), aSMEventHandler);
            ArrayList<IEventListener> arrayList = this.listeners.get(target);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.listeners.put(target, arrayList);
            }
            arrayList.add(aSMEventHandler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @ObfuscationIgnore
    public void unregister(Object object) {
        ArrayList<IEventListener> arrayList = this.listeners.remove(object);
        if (arrayList == null) {
            return;
        }
        for (IEventListener iEventListener : arrayList) {
            ListenerList.unregisterAll(this.busID, iEventListener);
        }
    }

    @ObfuscationIgnore
    public boolean post(Event event) {
        int n;
        IEventListener[] iEventListenerArray = event.getListenerList().getListeners(this.busID);
        try {
            for (n = 0; n < iEventListenerArray.length; ++n) {
                iEventListenerArray[n].invoke(event);
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(this, event, iEventListenerArray, n, throwable);
            Throwables.propagate((Throwable)throwable);
        }
        return event.isCancelable() ? event.isCanceled() : false;
    }

    @Override
    @ObfuscationIgnore
    public void handleException(EventBus bus, Event event, IEventListener[] listeners, int index, Throwable throwable) {
        FMLLog.log(Level.ERROR, throwable, "Exception caught during firing event %s:", event);
        FMLLog.log(Level.ERROR, "Index: %d Listeners:", index);
        for (int i = 0; i < listeners.length; ++i) {
            FMLLog.log(Level.ERROR, "%d: %s", i, listeners[i]);
        }
    }
}

