/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.eventhandler;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.ListenerList$ListenerListInst;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class ListenerList {
    private static ImmutableList<ListenerList> allLists = ImmutableList.of();
    private static int maxSize = 0;
    private ListenerList parent;
    private ListenerList$ListenerListInst[] lists = new ListenerList$ListenerListInst[0];

    public ListenerList() {
        this(null);
    }

    public ListenerList(ListenerList parent) {
        this.parent = parent;
        ListenerList.extendMasterList(this);
        this.resizeLists(maxSize);
    }

    private static synchronized void extendMasterList(ListenerList inst) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(allLists);
        builder.add((Object)inst);
        allLists = builder.build();
    }

    public static void resize(int max) {
        if (max <= maxSize) {
            return;
        }
        for (ListenerList listenerList : allLists) {
            listenerList.resizeLists(max);
        }
        maxSize = max;
    }

    public void resizeLists(int max) {
        int n;
        if (this.parent != null) {
            this.parent.resizeLists(max);
        }
        if (this.lists.length >= max) {
            return;
        }
        ListenerList$ListenerListInst[] listenerList$ListenerListInstArray = new ListenerList$ListenerListInst[max];
        for (n = 0; n < this.lists.length; ++n) {
            listenerList$ListenerListInstArray[n] = this.lists[n];
        }
        while (n < max) {
            listenerList$ListenerListInstArray[n] = this.parent != null ? new ListenerList$ListenerListInst(this, this.parent.getInstance(n), null) : new ListenerList$ListenerListInst(this, null);
            ++n;
        }
        this.lists = listenerList$ListenerListInstArray;
    }

    public static void clearBusID(int id) {
        for (ListenerList listenerList : allLists) {
            listenerList.lists[id].dispose();
        }
    }

    protected ListenerList$ListenerListInst getInstance(int id) {
        return this.lists[id];
    }

    public IEventListener[] getListeners(int id) {
        return this.lists[id].getListeners();
    }

    public void register(int id, EventPriority priority, IEventListener listener) {
        this.lists[id].register(priority, listener);
    }

    public void unregister(int id, IEventListener listener) {
        this.lists[id].unregister(listener);
    }

    public static void unregisterAll(int id, IEventListener listener) {
        for (ListenerList listenerList : allLists) {
            listenerList.unregister(id, listener);
        }
    }
}

