/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.patcher;

import LZMA.LzmaInputStream;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import cpw.mods.fml.common.patcher.ClassPatch;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.repackage.com.nothome.delta.GDiffPatcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class ClassPatchManager {
    public static final ClassPatchManager INSTANCE = new ClassPatchManager();
    public static final boolean dumpPatched = Boolean.parseBoolean(System.getProperty("fml.dumpPatchedClasses", "false"));
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugClassPatchManager", "false"));
    private GDiffPatcher patcher = new GDiffPatcher();
    private ListMultimap<String, ClassPatch> patches;
    private Map<String, byte[]> patchedClasses = Maps.newHashMap();
    private File tempDir;

    private ClassPatchManager() {
        if (dumpPatched) {
            this.tempDir = Files.createTempDir();
            FMLRelaunchLog.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("Dumping patched classes to %s", this.tempDir.getAbsolutePath());
        }
    }

    public byte[] getPatchedResource(String name, String mappedName, LaunchClassLoader loader) {
        byte[] byArray = loader.getClassBytes(name);
        return this.applyPatch(name, mappedName, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] applyPatch(String name, String mappedName, byte[] inputData) {
        if (this.patches == null) {
            return inputData;
        }
        if (this.patchedClasses.containsKey(name)) {
            return this.patchedClasses.get(name);
        }
        List list = this.patches.get((Object)name);
        if (list.isEmpty()) {
            return inputData;
        }
        boolean bl = false;
        if (DEBUG) {
            FMLRelaunchLog.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII("Runtime patching class %s (input size %d), found %d patch%s", mappedName, inputData == null ? 0 : inputData.length, list.size(), list.size() != 1 ? "es" : "");
        }
        for (ClassPatch classPatch : list) {
            if (!classPatch.targetClassName.equals(mappedName) && !classPatch.sourceClassName.equals(name)) {
                FMLRelaunchLog.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI("Binary patch found %s for wrong class %s", classPatch.targetClassName, mappedName);
            }
            if (!(classPatch.existsAtTarget || inputData != null && inputData.length != 0)) {
                inputData = new byte[]{};
            } else if (!classPatch.existsAtTarget) {
                FMLRelaunchLog.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI("Patcher expecting empty class data file for %s, but received non-empty", classPatch.targetClassName);
            } else {
                int n = Hashing.adler32().hashBytes(inputData).asInt();
                if (classPatch.inputChecksum != n) {
                    FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("There is a binary discrepency between the expected input class %s (%s) and the actual class. Checksum on disk is %x, in patch %x. Things are probably about to go very wrong. Did you put something into the jar file?", mappedName, name, n, classPatch.inputChecksum);
                    if (!Boolean.parseBoolean(System.getProperty("fml.ignorePatchDiscrepancies", "false"))) {
                        FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("The game is going to exit, because this is a critical error, and it is very improbable that the modded game will work, please obtain clean jar files.", new Object[0]);
                        System.exit(1);
                    } else {
                        FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("FML is going to ignore this error, note that the patch will not be applied, and there is likely to be a malfunctioning behaviour, including not running at all", new Object[0]);
                        bl = true;
                        continue;
                    }
                }
            }
            GDiffPatcher gDiffPatcher = this.patcher;
            synchronized (gDiffPatcher) {
                try {
                    inputData = this.patcher.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(inputData, classPatch.patch);
                }
                catch (IOException iOException) {
                    FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(Level.ERROR, iOException, "Encountered problem runtime patching class %s", name);
                }
            }
        }
        if (!bl && DEBUG) {
            FMLRelaunchLog.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII("Successfully applied runtime patches for %s (new size %d)", mappedName, inputData.length);
        }
        if (dumpPatched) {
            try {
                Files.write((byte[])inputData, (File)new File(this.tempDir, mappedName));
            }
            catch (IOException iOException) {
                FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(Level.ERROR, iOException, "Failed to write %s to %s", mappedName, this.tempDir.getAbsolutePath());
            }
        }
        this.patchedClasses.put(name, inputData);
        return inputData;
    }

    public void setup(Side side) {
        JarInputStream jarInputStream;
        Object object;
        Object object2;
        Pattern pattern = Pattern.compile(String.format("binpatch/%s/.*.binpatch", side.toString().toLowerCase(Locale.ENGLISH)));
        try {
            object2 = this.getClass().getResourceAsStream("/binpatches.pack.lzma");
            if (object2 == null) {
                FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(Level.ERROR, "The binary patch set is missing. Either you are in a development environment, or things are not going to work!", new Object[0]);
                return;
            }
            object = new LzmaInputStream((InputStream)object2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JarOutputStream jarOutputStream = new JarOutputStream(byteArrayOutputStream);
            Pack200.newUnpacker().unpack((InputStream)object, jarOutputStream);
            jarInputStream = new JarInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(Level.ERROR, exception, "Error occurred reading binary patches. Expect severe problems!", new Object[0]);
            throw Throwables.propagate((Throwable)exception);
        }
        this.patches = ArrayListMultimap.create();
        while (true) {
            try {
                while ((object2 = jarInputStream.getNextJarEntry()) != null) {
                    if (pattern.matcher(((ZipEntry)object2).getName()).matches()) {
                        object = this.readPatch((JarEntry)object2, jarInputStream);
                        if (object == null) continue;
                        this.patches.put((Object)object.sourceClassName, object);
                        continue;
                    }
                    jarInputStream.closeEntry();
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        FMLRelaunchLog.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII("Read %d binary patches", this.patches.size());
        if (DEBUG) {
            FMLRelaunchLog.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII("Patch list :\n\t%s", Joiner.on((String)"\t\n").join(this.patches.asMap().entrySet()));
        }
        this.patchedClasses.clear();
    }

    private ClassPatch readPatch(JarEntry patchEntry, JarInputStream jis) {
        ByteArrayDataInput byteArrayDataInput;
        if (DEBUG) {
            FMLRelaunchLog.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI("Reading patch data from %s", patchEntry.getName());
        }
        try {
            byteArrayDataInput = ByteStreams.newDataInput((byte[])ByteStreams.toByteArray((InputStream)jis));
        }
        catch (IOException iOException) {
            FMLRelaunchLog.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(Level.WARN, iOException, "Unable to read binpatch file %s - ignoring", patchEntry.getName());
            return null;
        }
        String string = byteArrayDataInput.readUTF();
        String string2 = byteArrayDataInput.readUTF();
        String string3 = byteArrayDataInput.readUTF();
        boolean bl = byteArrayDataInput.readBoolean();
        int n = 0;
        if (bl) {
            n = byteArrayDataInput.readInt();
        }
        int n2 = byteArrayDataInput.readInt();
        byte[] byArray = new byte[n2];
        byteArrayDataInput.readFully(byArray);
        return new ClassPatch(string, string2, string3, bl, n, byArray);
    }
}

