/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.ZipperUtil;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent$Action;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent$MissingMapping;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData$GameDataSnapshot;
import cpw.mods.fml.common.registry.GameRegistry$Type;
import cpw.mods.fml.common.registry.GameRegistry$UniqueIdentifier;
import cpw.mods.fml.common.registry.ObjectHolderRegistry;
import cpw.mods.fml.common.registry.RegistryDelegate;
import cpw.mods.fml.common.registry.RegistryDelegate$Delegate;
import fgm.IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI;
import fgm.IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI;
import fgm.iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii;
import fgm.iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class GameData {
    static final int MIN_BLOCK_ID = 0;
    static final int MAX_BLOCK_ID = 4095;
    static final int MIN_ITEM_ID = 4096;
    static final int MAX_ITEM_ID = 31999;
    private static final GameData mainData = new GameData();
    @Deprecated
    @ObfuscationIgnore
    public static final FMLControlledNamespacedRegistry<iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii> blockRegistry = GameData.getBlockRegistry();
    @Deprecated
    @ObfuscationIgnore
    public static final FMLControlledNamespacedRegistry<IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI> itemRegistry = GameData.getItemRegistry();
    private static Table<String, String, iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii> customItemStacks = HashBasedTable.create();
    private static Map<GameRegistry$UniqueIdentifier, ModContainer> customOwners = Maps.newHashMap();
    private static GameData frozen;
    private final FMLControlledNamespacedRegistry<iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii> iBlockRegistry;
    private final FMLControlledNamespacedRegistry<IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI> iItemRegistry;
    private final BitSet availabilityMap;
    private final Set<Integer> blockedIds;
    private BiMap<String, IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI> itemSubstitutions = HashBiMap.create();
    private BiMap<String, iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii> blockSubstitutions = HashBiMap.create();

    public static FMLControlledNamespacedRegistry<iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    public static FMLControlledNamespacedRegistry<IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    @Deprecated
    @ObfuscationIgnore
    public static ModContainer findModOwner(String string) {
        GameRegistry$UniqueIdentifier gameRegistry$UniqueIdentifier = new GameRegistry$UniqueIdentifier(string);
        if (customOwners.containsKey(gameRegistry$UniqueIdentifier)) {
            return customOwners.get(gameRegistry$UniqueIdentifier);
        }
        return Loader.instance().getIndexedModList().get(gameRegistry$UniqueIdentifier.modId);
    }

    public static GameData$GameDataSnapshot buildItemDataList() {
        HashMap hashMap = Maps.newHashMap();
        GameData.getMain().iBlockRegistry.serializeInto(hashMap);
        GameData.getMain().iItemRegistry.serializeInto(hashMap);
        HashSet hashSet = Sets.newHashSet();
        GameData.getMain().iBlockRegistry.serializeSubstitutions(hashSet);
        HashSet hashSet2 = Sets.newHashSet();
        GameData.getMain().iItemRegistry.serializeSubstitutions(hashSet2);
        return new GameData$GameDataSnapshot(hashMap, hashSet, hashSet2);
    }

    public static int[] getBlockedIds() {
        int[] nArray = new int[GameData.getMain().blockedIds.size()];
        int n = 0;
        Iterator<Integer> iterator = GameData.getMain().blockedIds.iterator();
        while (iterator.hasNext()) {
            int n2;
            nArray[n] = n2 = iterator.next().intValue();
            ++n;
        }
        return nArray;
    }

    public static void dumpRegistry(File minecraftDir) {
        if (customItemStacks == null) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("fml.dumpRegistry", "false")).booleanValue()) {
            String string2;
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (String string2 : customItemStacks.rowKeySet()) {
                builder.putAll((Object)string2, customItemStacks.row((Object)string2).keySet());
            }
            File file = new File(minecraftDir, "itemStackRegistry.csv");
            string2 = Joiner.on((String)"\n").withKeyValueSeparator(",");
            try {
                Files.write((CharSequence)string2.join((Iterable)builder.build().entries()), (File)file, (Charset)Charsets.UTF_8);
                FMLLog.log(Level.INFO, "Dumped item registry data to %s", file.getAbsolutePath());
            }
            catch (IOException iOException) {
                FMLLog.log(Level.ERROR, iOException, "Failed to write registry data to %s", file.getAbsolutePath());
            }
        }
    }

    static IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.getObject(modId + ":" + name);
    }

    static iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii findBlock(String modId, String name) {
        String string = modId + ":" + name;
        return GameData.getMain().iBlockRegistry.containsKey(string) ? GameData.getMain().iBlockRegistry.getObject(string) : null;
    }

    static iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii findItemStack(String modId, String name) {
        Object object;
        iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2 = (iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii)customItemStacks.get((Object)modId, (Object)name);
        if (iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2 == null && (object = GameData.findItem(modId, name)) != null) {
            iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2 = new iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii((IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI)object, 0, 0);
        }
        if (iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2 == null && (object = GameData.findBlock(modId, name)) != null) {
            iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2 = new iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii((iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii)object, 0, Short.MAX_VALUE);
        }
        return iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2;
    }

    static void registerCustomItemStack(String name, iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii itemStack) {
        customItemStacks.put((Object)Loader.instance().activeModContainer().getModId(), (Object)name, (Object)itemStack);
    }

    static GameRegistry$UniqueIdentifier getUniqueName(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block) {
        if (block == null) {
            return null;
        }
        String string = GameData.getMain().iBlockRegistry.getNameForObject(block);
        GameRegistry$UniqueIdentifier gameRegistry$UniqueIdentifier = new GameRegistry$UniqueIdentifier(string);
        if (customItemStacks.contains((Object)gameRegistry$UniqueIdentifier.modId, (Object)gameRegistry$UniqueIdentifier.name)) {
            return null;
        }
        return gameRegistry$UniqueIdentifier;
    }

    static GameRegistry$UniqueIdentifier getUniqueName(IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI item) {
        if (item == null) {
            return null;
        }
        String string = GameData.getMain().iItemRegistry.getNameForObject(item);
        GameRegistry$UniqueIdentifier gameRegistry$UniqueIdentifier = new GameRegistry$UniqueIdentifier(string);
        if (customItemStacks.contains((Object)gameRegistry$UniqueIdentifier.modId, (Object)gameRegistry$UniqueIdentifier.name)) {
            return null;
        }
        return gameRegistry$UniqueIdentifier;
    }

    /*
     * WARNING - void declaration
     */
    public static void fixBrokenIds(Map<String, Integer> dataList, Set<Integer> blockedIds) {
        int n;
        Object object;
        Object object2;
        Object object3;
        BitSet bitSet = new BitSet(32000);
        for (Map.Entry<String, Integer> object42 : dataList.entrySet()) {
            object3 = object42.getKey();
            object2 = ((String)object3).substring(1);
            if (((String)object3).charAt(0) != '\u0001') continue;
            bitSet.set(object42.getValue());
        }
        HashSet hashSet = new HashSet();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        object3 = new HashMap();
        for (Map.Entry bl : dataList.entrySet()) {
            object = (String)bl.getKey();
            if (((String)object).charAt(0) == '\u0001') continue;
            int iOException = (Integer)bl.getValue();
            String string3 = ((String)object).substring(1);
            String string = '\u0001' + string3;
            IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI iIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI = GameData.getMain().iItemRegistry.getRaw(string3);
            n = 0;
            if (iIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI == null) {
                FMLLog.warning("Item %s (old id %d) is no longer available and thus can't be fixed.", string3, iOException);
                hashSet2.add(object);
                n = 1;
            } else if (iIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI instanceof IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI) {
                if (dataList.containsKey(string)) {
                    int n2 = dataList.get(string);
                    if (n2 != iOException) {
                        FMLLog.warning("ItemBlock %s (old id %d) doesn't have the same id as its block (%d).", string3, iOException, n2);
                        object3.put(bl.getKey(), n2);
                        n = 1;
                    } else {
                        bitSet.set(iOException);
                    }
                } else {
                    FMLLog.warning("Item %s (old id %d) has been migrated to an ItemBlock and can't be fixed.", string3, iOException);
                    hashSet2.add(object);
                    n = 1;
                }
            } else if (bitSet.get(iOException)) {
                FMLLog.warning("Item %s (old id %d) is conflicting with another block/item and can't be fixed.", string3, iOException);
                hashSet2.add(object);
            } else {
                bitSet.set(iOException);
            }
            if (n == 0 || bitSet.get(iOException)) continue;
            hashSet.add(iOException);
            bitSet.set(iOException);
        }
        if (hashSet2.isEmpty() && object3.isEmpty()) {
            return;
        }
        object2 = "Forge Mod Loader detected that this save is damaged.\n\nIt's likely that an automatic repair can successfully restore\nmost of it, except some items which may get swapped with others.\n\nA world backup will be created as a zip file in your saves\ndirectory automatically.\n\n" + hashSet2.size() + " items need to be removed.\n" + object3.size() + " items need to be relocated.";
        boolean bl = StartupQuery.confirm((String)object2);
        if (!bl) {
            StartupQuery.abort();
        }
        object = new HashSet();
        for (String string : hashSet2) {
            object.add(string.substring(1, string.indexOf(58)));
        }
        Iterator<Object> iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.equals("minecraft") && !Loader.isModLoaded(string)) continue;
            iterator.remove();
        }
        if (!object.isEmpty()) {
            object2 = "Forge Mod Loader detected that " + object.size() + " mods are missing.\n\nIf you continue items previously provided by those mods will be\nremoved while repairing this world save.\n\nMissing mods:\n";
            iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                object2 = (String)object2 + string + "\n";
            }
            boolean bl2 = StartupQuery.confirm((String)object2);
            if (!bl2) {
                StartupQuery.abort();
            }
        }
        try {
            iterator = System.getProperty("fml.doNotBackup");
            if (iterator == null || !"true".equals(iterator)) {
                ZipperUtil.backupWorld();
            } else {
                void var10_23;
                boolean bl3 = false;
                while (var10_23 < 10) {
                    FMLLog.severe("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!", new Object[0]);
                    ++var10_23;
                }
            }
        }
        catch (IOException iOException) {
            StartupQuery.notify("The world backup couldn't be created.\n\n" + iOException);
            StartupQuery.abort();
        }
        for (String string : hashSet2) {
            int n3 = dataList.remove(string);
            FMLLog.warning("Removed Item %s, old id %d.", string.substring(1), n3);
        }
        for (Map.Entry entry : object3.entrySet()) {
            String string = (String)entry.getKey();
            int n4 = (Integer)entry.getValue();
            n = dataList.put(string, n4);
            FMLLog.warning("Remapped Item %s to id %d, old id %d.", string.substring(1), n4, n);
        }
        blockedIds.addAll(hashSet);
    }

    public static List<String> injectWorldIDMap(Map<String, Integer> dataList, Set<String> blockSubstitutions, Set<String> itemSubstitutions, boolean injectFrozenData, boolean isLocalWorld) {
        return GameData.injectWorldIDMap(dataList, new HashSet<Integer>(), new HashMap<String, String>(), new HashMap<String, String>(), blockSubstitutions, itemSubstitutions, injectFrozenData, isLocalWorld);
    }

    public static List<String> injectWorldIDMap(Map<String, Integer> dataList, Set<Integer> blockedIds, Map<String, String> blockAliases, Map<String, String> itemAliases, Set<String> blockSubstitutions, Set<String> itemSubstitutions, boolean injectFrozenData, boolean isLocalWorld) {
        FMLLog.info("Injecting existing block and item data into this %s instance", FMLCommonHandler.instance().getEffectiveSide().isServer() ? "server" : "client");
        HashMap hashMap = Maps.newHashMap();
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        GameData.getMain().testConsistency();
        GameData.getMain().iBlockRegistry.dump();
        GameData.getMain().iItemRegistry.dump();
        GameData.getMain().iItemRegistry.resetSubstitutionDelegates();
        GameData gameData = new GameData();
        Iterator<Object> iterator = blockedIds.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            gameData.block(n);
        }
        for (Map.Entry entry : blockAliases.entrySet()) {
            gameData.iBlockRegistry.addAlias((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : itemAliases.entrySet()) {
            gameData.iItemRegistry.addAlias((String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : blockSubstitutions) {
            gameData.iBlockRegistry.activateSubstitution(string);
        }
        for (String string : itemSubstitutions) {
            gameData.iItemRegistry.activateSubstitution(string);
        }
        if (injectFrozenData) {
            for (String string : GameData.getMain().blockSubstitutions.keySet()) {
                if (blockSubstitutions.contains(string)) continue;
                gameData.iBlockRegistry.activateSubstitution(string);
            }
            for (String string : GameData.getMain().itemSubstitutions.keySet()) {
                if (itemSubstitutions.contains(string)) continue;
                gameData.iItemRegistry.activateSubstitution(string);
            }
        }
        for (int i = 0; i < 2; ++i) {
            boolean bl = i == 0;
            for (Map.Entry<String, Integer> entry : dataList.entrySet()) {
                int n;
                String string = entry.getKey();
                int n2 = entry.getValue();
                if (string.charAt(0) == '\u0001' != bl) continue;
                string = string.substring(1);
                int n3 = n = bl ? GameData.getMain().iBlockRegistry.getId(string) : GameData.getMain().iItemRegistry.getId(string);
                if (n == -1) {
                    FMLLog.info("Found a missing id from the world %s", string);
                    linkedHashMap.put(entry.getKey(), n2);
                    continue;
                }
                if (n != n2) {
                    FMLLog.fine("Fixed %s id mismatch %s: %d (init) -> %d (map).", bl ? "block" : "item", string, n, n2);
                    hashMap.put(string, new Integer[]{n, n2});
                }
                if ((n = bl ? gameData.registerBlock(GameData.getMain().iBlockRegistry.getRaw(string), string, n2) : gameData.registerItem(GameData.getMain().iItemRegistry.getRaw(string), string, n2)) == n2) continue;
                throw new IllegalStateException(String.format("Can't map %s %s to id %d (seen at: %d), already occupied by %s, blocked %b, ItemBlock %b", bl ? "block" : "item", string, n2, n, bl ? gameData.iBlockRegistry.getRaw(n2) : gameData.iItemRegistry.getRaw(n2), gameData.blockedIds.contains(n2), bl ? false : GameData.getMain().iItemRegistry.getRaw(n) instanceof IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI));
            }
        }
        List<String> list = Loader.instance().fireMissingMappingEvent(linkedHashMap, isLocalWorld, gameData, hashMap);
        if (!list.isEmpty()) {
            return list;
        }
        if (injectFrozenData) {
            Map<String, Integer> map = GameData.frozen.iBlockRegistry.getEntriesNotIn(gameData.iBlockRegistry);
            Map<String, Integer> map2 = GameData.frozen.iItemRegistry.getEntriesNotIn(gameData.iItemRegistry);
            if (!map.isEmpty() || !map2.isEmpty()) {
                FMLLog.info("Injecting new block and item data into this server instance.", new Object[0]);
                for (int i = 0; i < 2; ++i) {
                    boolean bl = i == 0;
                    Object object = i == 0 ? map : map2;
                    for (Map.Entry entry : object.entrySet()) {
                        String string = (String)entry.getKey();
                        int n = (Integer)entry.getValue();
                        int n4 = bl ? gameData.registerBlock(GameData.frozen.iBlockRegistry.getRaw(string), string, n) : gameData.registerItem(GameData.frozen.iItemRegistry.getRaw(string), string, n);
                        FMLLog.info("Injected new block/item %s: %d (init) -> %d (map).", string, n, n4);
                        if (n4 == n) continue;
                        hashMap.put(string, new Integer[]{(Integer)entry.getValue(), n4});
                    }
                }
            }
        }
        gameData.testConsistency();
        GameData.getMain().set(gameData);
        GameData.getMain().iBlockRegistry.dump();
        GameData.getMain().iItemRegistry.dump();
        Loader.instance().fireRemapEvent(hashMap);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        return ImmutableList.of();
    }

    public static List<String> processIdRematches(Iterable<FMLMissingMappingsEvent$MissingMapping> missedMappings, boolean isLocalWorld, GameData gameData, Map<String, Integer[]> remaps) {
        int n;
        Object iOException2;
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList3 = Lists.newArrayList();
        ArrayList arrayList4 = Lists.newArrayList();
        for (FMLMissingMappingsEvent$MissingMapping object2 : missedMappings) {
            iOException2 = object2.getAction();
            if (iOException2 == FMLMissingMappingsEvent$Action.REMAP) {
                int n2;
                String string;
                if (object2.type == GameRegistry$Type.BLOCK) {
                    n = GameData.getMain().iBlockRegistry.getId((iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii)object2.getTarget());
                    string = GameData.getMain().iBlockRegistry.getNameForObject(object2.getTarget());
                    FMLLog.fine("The Block %s is being remapped to %s.", object2.name, string);
                    n2 = gameData.registerBlock((iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii)object2.getTarget(), string, object2.id);
                    gameData.iBlockRegistry.addAlias(object2.name, string);
                } else {
                    n = GameData.getMain().iItemRegistry.getId((IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI)object2.getTarget());
                    string = GameData.getMain().iItemRegistry.getNameForObject(object2.getTarget());
                    FMLLog.fine("The Item %s is being remapped to %s.", object2.name, string);
                    n2 = gameData.registerItem((IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI)object2.getTarget(), string, object2.id);
                    gameData.iItemRegistry.addAlias(object2.name, string);
                }
                if (n2 != object2.id) {
                    throw new IllegalStateException();
                }
                if (n == n2) continue;
                FMLLog.info("Fixed %s id mismatch %s: %d (init) -> %d (map).", object2.type == GameRegistry$Type.BLOCK ? "block" : "item", string, n, n2);
                remaps.put(string, new Integer[]{n, n2});
                continue;
            }
            if (iOException2 == FMLMissingMappingsEvent$Action.BLOCKONLY) {
                FMLLog.fine("The ItemBlock %s is no longer present in the game. The residual block will remain", object2.name);
                continue;
            }
            if (iOException2 == FMLMissingMappingsEvent$Action.DEFAULT) {
                arrayList4.add(object2.name);
            } else if (iOException2 == FMLMissingMappingsEvent$Action.IGNORE) {
                arrayList2.add(object2.name);
            } else if (iOException2 == FMLMissingMappingsEvent$Action.FAIL) {
                arrayList.add(object2.name);
            } else if (iOException2 == FMLMissingMappingsEvent$Action.WARN) {
                arrayList3.add(object2.name);
            }
            gameData.block(object2.id);
        }
        if (!arrayList4.isEmpty()) {
            Object object3 = "Forge Mod Loader detected missing blocks/items.\n\nThere are " + arrayList4.size() + " missing blocks and items in this save.\nIf you continue the missing blocks/items will get removed.\nA world backup will be automatically created in your saves directory.\n\nMissing Blocks/Items:\n";
            for (Object iOException2 : arrayList4) {
                object3 = (String)object3 + (String)iOException2 + "\n";
            }
            boolean bl = StartupQuery.confirm((String)object3);
            if (!bl) {
                StartupQuery.abort();
            }
            try {
                iOException2 = System.getProperty("fml.doNotBackup");
                if (iOException2 == null || !"true".equals(iOException2)) {
                    ZipperUtil.backupWorld();
                } else {
                    for (n = 0; n < 10; ++n) {
                        FMLLog.severe("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!", new Object[0]);
                    }
                }
            }
            catch (IOException iOException3) {
                StartupQuery.notify("The world backup couldn't be created.\n\n" + iOException3);
                StartupQuery.abort();
            }
            arrayList3.addAll(arrayList4);
        }
        if (!arrayList.isEmpty()) {
            FMLLog.severe("This world contains blocks and items that refuse to be remapped. The world will not be loaded", new Object[0]);
            return arrayList;
        }
        if (!arrayList3.isEmpty()) {
            FMLLog.severe("This world contains block and item mappings that may cause world breakage", new Object[0]);
            return arrayList;
        }
        if (!arrayList2.isEmpty()) {
            FMLLog.fine("There were %d missing mappings that have been ignored", arrayList2.size());
        }
        return arrayList;
    }

    public static void freezeData() {
        FMLLog.fine("Freezing block and item id maps", new Object[0]);
        GameData.getMain().testConsistency();
        frozen = new GameData(GameData.getMain());
        frozen.testConsistency();
    }

    public static void revertToFrozen() {
        if (frozen == null) {
            FMLLog.warning("Can't revert to frozen GameData state without freezing first.", new Object[0]);
        } else {
            FMLLog.fine("Reverting to frozen data state.", new Object[0]);
            GameData.getMain().set(frozen);
        }
        Loader.instance().fireRemapEvent((Map<String, Integer[]>)ImmutableMap.of());
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
    }

    protected static boolean isFrozen(FMLControlledNamespacedRegistry<?> registry) {
        return frozen != null && (GameData.getMain().iBlockRegistry == registry || GameData.getMain().iItemRegistry == registry);
    }

    protected static GameData getMain() {
        return mainData;
    }

    private GameData() {
        this.iBlockRegistry = new FMLControlledNamespacedRegistry<iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii>("minecraft:air", 4095, 0, iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii.class, '\u0001');
        this.iItemRegistry = new FMLControlledNamespacedRegistry<IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI>(null, 31999, 4096, IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI.class, '\u0002');
        this.availabilityMap = new BitSet(32000);
        this.blockedIds = new HashSet<Integer>();
    }

    private GameData(GameData data) {
        this();
        this.set(data);
    }

    private void set(GameData data) {
        this.iBlockRegistry.set(data.iBlockRegistry);
        this.iItemRegistry.set(data.iItemRegistry);
        this.availabilityMap.clear();
        this.availabilityMap.or(data.availabilityMap);
        this.blockedIds.clear();
        this.blockedIds.addAll(data.blockedIds);
    }

    int register(Object obj, String name, int idHint) {
        name = this.addPrefix(name);
        if (obj instanceof iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii) {
            return this.registerBlock((iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii)obj, name, idHint);
        }
        if (obj instanceof IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI) {
            return this.registerItem((IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI)obj, name, idHint);
        }
        throw new IllegalArgumentException("An invalid registry object is to be added, only instances of Block or Item are allowed.");
    }

    int registerItem(IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI item, String name) {
        int n = name.indexOf(58);
        if (name.indexOf(58) != -1) {
            FMLLog.bigWarning("Illegal extra prefix %s for name %s, invalid registry invocation/invalid name?", name.substring(0, n), name);
        }
        name = this.addPrefix(name);
        return this.registerItem(item, name, -1);
    }

    private int registerItem(IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI item, String name, int idHint) {
        if (item instanceof IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI) {
            int n;
            iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii2 = ((IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI)item).iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI;
            if (idHint != -1 && GameData.getMain().blockSubstitutions.containsKey((Object)name)) {
                iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii2 = (iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii)GameData.getMain().blockSubstitutions.get((Object)name);
            }
            if ((n = this.iBlockRegistry.getId(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii2)) == -1) {
                if (idHint < 0 || this.availabilityMap.get(idHint) || idHint > 4095) {
                    n = this.availabilityMap.nextClearBit(0);
                    if (n > 4095) {
                        throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", n));
                    }
                    FMLLog.fine("Allocated id %d for ItemBlock %s in the block id range, original id requested: %d.", n, name, idHint);
                } else {
                    n = idHint;
                }
            } else {
                if (FMLControlledNamespacedRegistry.DEBUG) {
                    FMLLog.fine("Found matching Block %s for ItemBlock %s at id %d, original id requested: %d", iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii2, item, n, idHint);
                }
                this.freeSlot(n, item);
            }
            idHint = n;
        }
        int n = this.iItemRegistry.add(idHint, name, item, this.availabilityMap);
        if (item instanceof IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI) {
            if (n != idHint) {
                throw new IllegalStateException(String.format("ItemBlock at block id %d insertion failed, got id %d.", idHint, n));
            }
            this.verifyItemBlockName((IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI)item);
        }
        this.useSlot(n);
        ((RegistryDelegate$Delegate)item.iIiIIIIiIiIiiiIiIiiIiiIiIiiiIIiIiIiiiIIIiIiIiiiIIIIiIiIiiIiIiiiI).setName(name);
        return n;
    }

    int registerBlockID(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block, String name, int id) {
        int n = name.indexOf(58);
        if (name.indexOf(58) != -1) {
            FMLLog.bigWarning("Illegal extra prefix %s for name %s, invalid registry invocation/invalid name?", name.substring(0, n), name);
        }
        name = this.addPrefix(name);
        return this.registerBlock(block, name, id);
    }

    int registerBlock(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block, String name) {
        int n = name.indexOf(58);
        if (name.indexOf(58) != -1) {
            FMLLog.bigWarning("Illegal extra prefix %s for name %s, invalid registry invocation/invalid name?", name.substring(0, n), name);
        }
        name = this.addPrefix(name);
        return this.registerBlock(block, name, -1);
    }

    private int registerBlock(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block, String name, int idHint) {
        IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI = null;
        for (IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI iIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI : this.iItemRegistry.typeSafeIterable()) {
            if (!(iIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI instanceof IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI) || ((IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI)iIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI).iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI != block) continue;
            iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI = (IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI)iIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI;
            break;
        }
        if (iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI != null) {
            idHint = this.iItemRegistry.getId(iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI);
            FMLLog.fine("Found matching ItemBlock %s for Block %s at id %d", iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI, block, idHint);
            this.freeSlot(idHint, block);
        }
        int n = this.iBlockRegistry.add(idHint, name, block, this.availabilityMap);
        if (iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI != null) {
            if (n != idHint) {
                throw new IllegalStateException(String.format("Block at itemblock id %d insertion failed, got id %d.", idHint, n));
            }
            this.verifyItemBlockName(iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI);
        }
        this.useSlot(n);
        ((RegistryDelegate$Delegate)block.iiiiiiIIiIIiIIIiiiiIIIIiIiIiiiIiIIiIiIIIIiiiiiIiIIiIiiiiIIiIIiII).setName(name);
        return n;
    }

    private void block(int id) {
        this.blockedIds.add(id);
        this.useSlot(id);
    }

    private void useSlot(int id) {
        this.availabilityMap.set(id);
    }

    private void freeSlot(int id, Object obj) {
        FMLControlledNamespacedRegistry<Object> fMLControlledNamespacedRegistry = obj instanceof iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii ? this.iBlockRegistry : this.iItemRegistry;
        Object object = fMLControlledNamespacedRegistry.getRaw(id);
        if (object != null && object != obj) {
            throw new IllegalStateException(String.format("Can't free registry slot %d occupied by %s", id, object));
        }
        this.availabilityMap.clear(id);
    }

    private String addPrefix(String name) {
        ModContainer modContainer;
        String string;
        int n = name.lastIndexOf(58);
        String string2 = n == -1 ? "" : name.substring(0, n);
        if (!string2.equals(string = (modContainer = Loader.instance().activeModContainer()) != null ? modContainer.getModId() : "minecraft")) {
            name = string + ":" + name;
        }
        return name;
    }

    private void verifyItemBlockName(IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI item) {
        String string = this.iBlockRegistry.getNameForObject(item.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI);
        String string2 = this.iItemRegistry.getNameForObject(item);
        if (string != null && !string.equals(string2)) {
            FMLLog.bigWarning("Block <-> ItemBlock name mismatch, block name %s, item name %s", string, string2);
        }
    }

    private void testConsistency() {
        int n = this.availabilityMap.nextSetBit(0);
        while (n >= 0) {
            if (this.iBlockRegistry.getRaw(n) == null && this.iItemRegistry.getRaw(n) == null && !this.blockedIds.contains(n)) {
                throw new IllegalStateException(String.format("availabilityMap references empty entries for id %d.", n));
            }
            n = this.availabilityMap.nextSetBit(n + 1);
        }
        for (n = 0; n < 2; ++n) {
            boolean bl = n == 0;
            String string = bl ? "block" : "item";
            FMLControlledNamespacedRegistry<Object> fMLControlledNamespacedRegistry = bl ? this.iBlockRegistry : this.iItemRegistry;
            fMLControlledNamespacedRegistry.validateContent(bl ? 4095 : 31999, string, this.availabilityMap, this.blockedIds, this.iBlockRegistry);
        }
        FMLLog.fine("Registry consistency check successful", new Object[0]);
    }

    void registerSubstitutionAlias(String nameToSubstitute, GameRegistry$Type type, Object toReplace) {
        type.getRegistry().addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, toReplace);
        type.getRegistry().activateSubstitution(nameToSubstitute);
    }

    static <T> RegistryDelegate<T> buildDelegate(T referant, Class<T> type) {
        return new RegistryDelegate$Delegate<T>(referant, type);
    }

    <T> BiMap<String, T> getPersistentSubstitutionMap(Class<T> type) {
        if (type.equals(IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI.class)) {
            return this.itemSubstitutions;
        }
        if (type.equals(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii.class)) {
            return this.blockSubstitutions;
        }
        throw new RuntimeException("WHAT?");
    }
}

