/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.toposort;

import cpw.mods.fml.common.toposort.TopologicalSort$DirectedGraph$1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class TopologicalSort$DirectedGraph<T>
implements Iterable<T> {
    private final Map<T, SortedSet<T>> graph = new HashMap<T, SortedSet<T>>();
    private List<T> orderedNodes = new ArrayList<T>();

    public boolean addNode(T node) {
        if (this.graph.containsKey(node)) {
            return false;
        }
        this.orderedNodes.add(node);
        this.graph.put(node, new TreeSet(new TopologicalSort$DirectedGraph$1(this)));
        return true;
    }

    public void addEdge(T from, T to) {
        if (!this.graph.containsKey(from) || !this.graph.containsKey(to)) {
            throw new NoSuchElementException("Missing nodes from graph");
        }
        this.graph.get(from).add(to);
    }

    public void removeEdge(T from, T to) {
        if (!this.graph.containsKey(from) || !this.graph.containsKey(to)) {
            throw new NoSuchElementException("Missing nodes from graph");
        }
        this.graph.get(from).remove(to);
    }

    public boolean edgeExists(T from, T to) {
        if (!this.graph.containsKey(from) || !this.graph.containsKey(to)) {
            throw new NoSuchElementException("Missing nodes from graph");
        }
        return this.graph.get(from).contains(to);
    }

    public Set<T> edgesFrom(T from) {
        if (!this.graph.containsKey(from)) {
            throw new NoSuchElementException("Missing node from graph");
        }
        return Collections.unmodifiableSortedSet(this.graph.get(from));
    }

    @Override
    public Iterator<T> iterator() {
        return this.orderedNodes.iterator();
    }

    public int size() {
        return this.graph.size();
    }

    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    public String toString() {
        return this.graph.toString();
    }

    static /* synthetic */ List access$000(TopologicalSort$DirectedGraph x0) {
        return x0.orderedNodes;
    }
}

