/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.versioning;

import com.google.common.base.Joiner;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.Restriction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class VersionRange {
    private final ArtifactVersion recommendedVersion;
    private final List<Restriction> restrictions;

    private VersionRange(ArtifactVersion recommendedVersion, List<Restriction> restrictions) {
        this.recommendedVersion = recommendedVersion;
        this.restrictions = restrictions;
    }

    public ArtifactVersion getRecommendedVersion() {
        return this.recommendedVersion;
    }

    public List<Restriction> getRestrictions() {
        return this.restrictions;
    }

    public VersionRange cloneOf() {
        ArrayList<Restriction> arrayList = null;
        if (this.restrictions != null) {
            arrayList = new ArrayList<Restriction>();
            if (!this.restrictions.isEmpty()) {
                arrayList.addAll(this.restrictions);
            }
        }
        return new VersionRange(this.recommendedVersion, arrayList);
    }

    public static VersionRange newRange(ArtifactVersion version, List<Restriction> restrictions) {
        return new VersionRange(version, restrictions);
    }

    public static VersionRange createFromVersionSpec(String spec) {
        if (spec == null) {
            return null;
        }
        ArrayList<Restriction> arrayList = new ArrayList<Restriction>();
        String string = spec;
        DefaultArtifactVersion defaultArtifactVersion = null;
        ArtifactVersion artifactVersion = null;
        ArtifactVersion artifactVersion2 = null;
        while (string.startsWith("[") || string.startsWith("(")) {
            int n;
            int n2 = string.indexOf(")");
            int n3 = n = string.indexOf("]");
            if ((n < 0 || n2 < n) && n2 >= 0) {
                n3 = n2;
            }
            if (n3 < 0) {
                throw new InvalidVersionSpecificationException("Unbounded range: " + spec);
            }
            Restriction restriction = VersionRange.parseRestriction(string.substring(0, n3 + 1));
            if (artifactVersion2 == null) {
                artifactVersion2 = restriction.getLowerBound();
            }
            if (artifactVersion != null && (restriction.getLowerBound() == null || restriction.getLowerBound().compareTo(artifactVersion) < 0)) {
                throw new InvalidVersionSpecificationException("Ranges overlap: " + spec);
            }
            arrayList.add(restriction);
            artifactVersion = restriction.getUpperBound();
            if ((string = string.substring(n3 + 1).trim()).length() <= 0 || !string.startsWith(",")) continue;
            string = string.substring(1).trim();
        }
        if (string.length() > 0) {
            if (arrayList.size() > 0) {
                throw new InvalidVersionSpecificationException("Only fully-qualified sets allowed in multiple set scenario: " + spec);
            }
            defaultArtifactVersion = new DefaultArtifactVersion(string);
            arrayList.add(Restriction.EVERYTHING);
        }
        return new VersionRange(defaultArtifactVersion, arrayList);
    }

    private static Restriction parseRestriction(String spec) {
        Restriction restriction;
        boolean bl = spec.startsWith("[");
        boolean bl2 = spec.endsWith("]");
        String string = spec.substring(1, spec.length() - 1).trim();
        int n = string.indexOf(",");
        if (n < 0) {
            if (!bl || !bl2) {
                throw new InvalidVersionSpecificationException("Single version must be surrounded by []: " + spec);
            }
            DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(string);
            restriction = new Restriction(defaultArtifactVersion, bl, defaultArtifactVersion, bl2);
        } else {
            String string2;
            String string3 = string.substring(0, n).trim();
            if (string3.equals(string2 = string.substring(n + 1).trim())) {
                throw new InvalidVersionSpecificationException("Range cannot have identical boundaries: " + spec);
            }
            DefaultArtifactVersion defaultArtifactVersion = null;
            if (string3.length() > 0) {
                defaultArtifactVersion = new DefaultArtifactVersion(string3);
            }
            DefaultArtifactVersion defaultArtifactVersion2 = null;
            if (string2.length() > 0) {
                defaultArtifactVersion2 = new DefaultArtifactVersion(string2);
            }
            if (defaultArtifactVersion2 != null && defaultArtifactVersion != null && defaultArtifactVersion2.compareTo(defaultArtifactVersion) < 0) {
                throw new InvalidVersionSpecificationException("Range defies version ordering: " + spec);
            }
            restriction = new Restriction(defaultArtifactVersion, bl, defaultArtifactVersion2, bl2);
        }
        return restriction;
    }

    public static VersionRange createFromVersion(String version, ArtifactVersion existing) {
        List<Restriction> list = Collections.emptyList();
        if (existing == null) {
            existing = new DefaultArtifactVersion(version);
        }
        return new VersionRange(existing, list);
    }

    public VersionRange restrict(VersionRange restriction) {
        List<Restriction> list = this.restrictions;
        List<Restriction> list2 = restriction.restrictions;
        List<Object> list3 = list.isEmpty() || list2.isEmpty() ? Collections.emptyList() : this.intersection(list, list2);
        ArtifactVersion artifactVersion = null;
        if (list3.size() > 0) {
            for (Restriction restriction2 : list3) {
                if (this.recommendedVersion != null && restriction2.containsVersion(this.recommendedVersion)) {
                    artifactVersion = this.recommendedVersion;
                    break;
                }
                if (artifactVersion != null || restriction.getRecommendedVersion() == null || !restriction2.containsVersion(restriction.getRecommendedVersion())) continue;
                artifactVersion = restriction.getRecommendedVersion();
            }
        } else if (this.recommendedVersion != null) {
            artifactVersion = this.recommendedVersion;
        } else if (restriction.recommendedVersion != null) {
            artifactVersion = restriction.recommendedVersion;
        }
        return new VersionRange(artifactVersion, list3);
    }

    private List<Restriction> intersection(List<Restriction> r1, List<Restriction> r2) {
        ArrayList<Restriction> arrayList = new ArrayList<Restriction>(r1.size() + r2.size());
        Iterator<Restriction> iterator = r1.iterator();
        Iterator<Restriction> iterator2 = r2.iterator();
        Restriction restriction = iterator.next();
        Restriction restriction2 = iterator2.next();
        boolean bl = false;
        while (!bl) {
            if (restriction.getLowerBound() == null || restriction2.getUpperBound() == null || restriction.getLowerBound().compareTo(restriction2.getUpperBound()) <= 0) {
                if (restriction.getUpperBound() == null || restriction2.getLowerBound() == null || restriction.getUpperBound().compareTo(restriction2.getLowerBound()) >= 0) {
                    boolean bl2;
                    ArtifactVersion artifactVersion;
                    int n;
                    boolean bl3;
                    ArtifactVersion artifactVersion2;
                    if (restriction.getLowerBound() == null) {
                        artifactVersion2 = restriction2.getLowerBound();
                        bl3 = restriction2.isLowerBoundInclusive();
                    } else if (restriction2.getLowerBound() == null) {
                        artifactVersion2 = restriction.getLowerBound();
                        bl3 = restriction.isLowerBoundInclusive();
                    } else {
                        n = restriction.getLowerBound().compareTo(restriction2.getLowerBound());
                        if (n < 0) {
                            artifactVersion2 = restriction2.getLowerBound();
                            bl3 = restriction2.isLowerBoundInclusive();
                        } else if (n == 0) {
                            artifactVersion2 = restriction.getLowerBound();
                            bl3 = restriction.isLowerBoundInclusive() && restriction2.isLowerBoundInclusive();
                        } else {
                            artifactVersion2 = restriction.getLowerBound();
                            bl3 = restriction.isLowerBoundInclusive();
                        }
                    }
                    if (restriction.getUpperBound() == null) {
                        artifactVersion = restriction2.getUpperBound();
                        bl2 = restriction2.isUpperBoundInclusive();
                    } else if (restriction2.getUpperBound() == null) {
                        artifactVersion = restriction.getUpperBound();
                        bl2 = restriction.isUpperBoundInclusive();
                    } else {
                        n = restriction.getUpperBound().compareTo(restriction2.getUpperBound());
                        if (n < 0) {
                            artifactVersion = restriction.getUpperBound();
                            bl2 = restriction.isUpperBoundInclusive();
                        } else if (n == 0) {
                            artifactVersion = restriction.getUpperBound();
                            bl2 = restriction.isUpperBoundInclusive() && restriction2.isUpperBoundInclusive();
                        } else {
                            artifactVersion = restriction2.getUpperBound();
                            bl2 = restriction2.isUpperBoundInclusive();
                        }
                    }
                    if (artifactVersion2 == null || artifactVersion == null || artifactVersion2.compareTo(artifactVersion) != 0) {
                        arrayList.add(new Restriction(artifactVersion2, bl3, artifactVersion, bl2));
                    } else if (bl3 && bl2) {
                        arrayList.add(new Restriction(artifactVersion2, bl3, artifactVersion, bl2));
                    }
                    if (artifactVersion == restriction2.getUpperBound()) {
                        if (iterator2.hasNext()) {
                            restriction2 = iterator2.next();
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    if (iterator.hasNext()) {
                        restriction = iterator.next();
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (iterator.hasNext()) {
                    restriction = iterator.next();
                    continue;
                }
                bl = true;
                continue;
            }
            if (iterator2.hasNext()) {
                restriction2 = iterator2.next();
                continue;
            }
            bl = true;
        }
        return arrayList;
    }

    public String toString() {
        if (this.recommendedVersion != null) {
            return this.recommendedVersion.toString();
        }
        return Joiner.on((char)',').join(this.restrictions);
    }

    public ArtifactVersion matchVersion(List<ArtifactVersion> versions) {
        ArtifactVersion artifactVersion = null;
        for (ArtifactVersion artifactVersion2 : versions) {
            if (!this.containsVersion(artifactVersion2) || artifactVersion != null && artifactVersion2.compareTo(artifactVersion) <= 0) continue;
            artifactVersion = artifactVersion2;
        }
        return artifactVersion;
    }

    public boolean containsVersion(ArtifactVersion version) {
        for (Restriction restriction : this.restrictions) {
            if (!restriction.containsVersion(version)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRestrictions() {
        return !this.restrictions.isEmpty() && this.recommendedVersion == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionRange)) {
            return false;
        }
        VersionRange versionRange = (VersionRange)obj;
        boolean bl = this.recommendedVersion == versionRange.recommendedVersion || this.recommendedVersion != null && this.recommendedVersion.equals(versionRange.recommendedVersion);
        return bl &= this.restrictions == versionRange.restrictions || this.restrictions != null && this.restrictions.equals(versionRange.restrictions);
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + (this.recommendedVersion == null ? 0 : this.recommendedVersion.hashCode());
        n = 31 * n + (this.restrictions == null ? 0 : this.restrictions.hashCode());
        return n;
    }

    public boolean isUnboundedAbove() {
        return this.restrictions.size() == 1 && this.restrictions.get(0).getUpperBound() == null && !this.restrictions.get(0).isUpperBoundInclusive();
    }

    public String getLowerBoundString() {
        return this.restrictions.size() == 1 ? this.restrictions.get(0).getLowerBound().getVersionString() : "";
    }
}

