/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import org.lwjgl.MemoryUtil;
import org.lwjgl.MemoryUtil$Accessor;
import sun.misc.Unsafe;

class MemoryUtilSun$AccessorUnsafe
implements MemoryUtil$Accessor {
    private final Unsafe unsafe;
    private final long address;

    MemoryUtilSun$AccessorUnsafe() {
        try {
            this.unsafe = MemoryUtilSun$AccessorUnsafe.getUnsafeInstance();
            this.address = this.unsafe.objectFieldOffset(MemoryUtil.getAddressField());
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    @Override
    public long getAddress(Buffer buffer) {
        return this.unsafe.getLong(buffer, this.address);
    }

    private static Unsafe getUnsafeInstance() {
        Field[] fieldArray;
        for (Field field : fieldArray = Unsafe.class.getDeclaredFields()) {
            int n;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(n = field.getModifiers()) || !Modifier.isFinal(n)) continue;
            field.setAccessible(true);
            try {
                return (Unsafe)field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                break;
            }
        }
        throw new UnsupportedOperationException();
    }
}

