/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.LinuxSysImplementation;
import org.lwjgl.MacOSXSysImplementation;
import org.lwjgl.Sys$1;
import org.lwjgl.Sys$2;
import org.lwjgl.Sys$3;
import org.lwjgl.SysImplementation;
import org.lwjgl.WindowsSysImplementation;
import org.lwjgl.input.Mouse;

public final class Sys {
    private static final String JNI_LIBRARY_NAME = "lwjgl";
    private static final String VERSION = "2.9.1";
    private static final String POSTFIX64BIT = "64";
    private static final SysImplementation implementation = Sys.createImplementation();
    private static final boolean is64Bit;

    private static void doLoadLibrary(String lib_name) {
        AccessController.doPrivileged(new Sys$1(lib_name));
    }

    private static void loadLibrary(String lib_name) {
        boolean bl;
        String string = System.getProperty("os.arch");
        boolean bl2 = bl = "amd64".equals(string) || "x86_64".equals(string);
        if (bl) {
            try {
                Sys.doLoadLibrary(lib_name + POSTFIX64BIT);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                LWJGLUtil.log("Failed to load 64 bit library: " + unsatisfiedLinkError.getMessage());
            }
        }
        try {
            Sys.doLoadLibrary(lib_name);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (implementation.has64Bit()) {
                try {
                    Sys.doLoadLibrary(lib_name + POSTFIX64BIT);
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    LWJGLUtil.log("Failed to load 64 bit library: " + unsatisfiedLinkError2.getMessage());
                }
            }
            throw unsatisfiedLinkError;
        }
    }

    private static SysImplementation createImplementation() {
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                return new LinuxSysImplementation();
            }
            case 3: {
                return new WindowsSysImplementation();
            }
            case 2: {
                return new MacOSXSysImplementation();
            }
        }
        throw new IllegalStateException("Unsupported platform");
    }

    private Sys() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static void initialize() {
    }

    public static boolean is64Bit() {
        return is64Bit;
    }

    public static long getTimerResolution() {
        return implementation.getTimerResolution();
    }

    public static long getTime() {
        return System.currentTimeMillis();
    }

    public static void alert(String title, String message) {
        boolean bl = Mouse.isGrabbed();
        if (bl) {
            Mouse.setGrabbed(false);
        }
        if (title == null) {
            title = "";
        }
        if (message == null) {
            message = "";
        }
        implementation.alert(title, message);
        if (bl) {
            Mouse.setGrabbed(true);
        }
    }

    public static boolean openURL(String url) {
        try {
            Class<?> clazz = Class.forName("javax.jnlp.ServiceManager");
            Method method = AccessController.doPrivileged(new Sys$2(clazz));
            Object object = method.invoke(clazz, "javax.jnlp.BasicService");
            Class<?> clazz2 = Class.forName("javax.jnlp.BasicService");
            Method method2 = AccessController.doPrivileged(new Sys$3(clazz2));
            try {
                Boolean bl = (Boolean)method2.invoke(object, new URL(url));
                return bl;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace(System.err);
                return false;
            }
        }
        catch (Exception exception) {
            return implementation.openURL(url);
        }
    }

    public static String getClipboard() {
        return implementation.getClipboard();
    }

    static {
        Sys.loadLibrary(JNI_LIBRARY_NAME);
        is64Bit = implementation.getPointerSize() == 8;
        int n = implementation.getJNIVersion();
        int n2 = implementation.getRequiredJNIVersion();
        if (n != n2) {
            throw new LinkageError("Version mismatch: jar version is '" + n2 + "', native library version is '" + n + "'");
        }
        implementation.setDebug(LWJGLUtil.DEBUG);
    }
}

