/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Cursor$CursorElement;
import org.lwjgl.input.Mouse;
import org.lwjgl.input.OpenGLPackageAccess;

public class Cursor {
    public static final int CURSOR_ONE_BIT_TRANSPARENCY = 1;
    public static final int CURSOR_8_BIT_ALPHA = 2;
    public static final int CURSOR_ANIMATION = 4;
    private final Cursor$CursorElement[] cursors;
    private int index;
    private boolean destroyed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if ((Cursor.getCapabilities() & 1) == 0) {
                throw new LWJGLException("Native cursors not supported");
            }
            BufferChecks.checkBufferSize(images, width * height * numImages);
            if (delays != null) {
                BufferChecks.checkBufferSize(delays, numImages);
            }
            if (!Mouse.isCreated()) {
                throw new IllegalStateException("Mouse must be created before creating cursor objects");
            }
            if (width * height * numImages > images.remaining()) {
                throw new IllegalArgumentException("width*height*numImages > images.remaining()");
            }
            if (xHotspot >= width || xHotspot < 0) {
                throw new IllegalArgumentException("xHotspot > width || xHotspot < 0");
            }
            if (yHotspot >= height || yHotspot < 0) {
                throw new IllegalArgumentException("yHotspot > height || yHotspot < 0");
            }
            Sys.initialize();
            yHotspot = height - 1 - yHotspot;
            this.cursors = Cursor.createCursors(width, height, xHotspot, yHotspot, numImages, images, delays);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMinCursorSize() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!Mouse.isCreated()) {
                throw new IllegalStateException("Mouse must be created.");
            }
            return Mouse.getImplementation().getMinCursorSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxCursorSize() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!Mouse.isCreated()) {
                throw new IllegalStateException("Mouse must be created.");
            }
            return Mouse.getImplementation().getMaxCursorSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCapabilities() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (Mouse.getImplementation() != null) {
                return Mouse.getImplementation().getNativeCursorCapabilities();
            }
            return OpenGLPackageAccess.createImplementation().getNativeCursorCapabilities();
        }
    }

    private static Cursor$CursorElement[] createCursors(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) {
        Cursor$CursorElement[] cursor$CursorElementArray;
        IntBuffer intBuffer = BufferUtils.createIntBuffer(images.remaining());
        Cursor.flipImages(width, height, numImages, images, intBuffer);
        switch (LWJGLUtil.getPlatform()) {
            case 2: {
                Cursor.convertARGBtoABGR(intBuffer);
                cursor$CursorElementArray = new Cursor$CursorElement[numImages];
                for (int i = 0; i < numImages; ++i) {
                    Object object = Mouse.getImplementation().createCursor(width, height, xHotspot, yHotspot, 1, intBuffer, null);
                    long l = delays != null ? (long)delays.get(i) : 0L;
                    long l2 = System.currentTimeMillis();
                    cursor$CursorElementArray[i] = new Cursor$CursorElement(object, l, l2);
                    intBuffer.position(width * height * (i + 1));
                }
                break;
            }
            case 3: {
                cursor$CursorElementArray = new Cursor$CursorElement[numImages];
                for (int i = 0; i < numImages; ++i) {
                    int n = width * height;
                    for (int j = 0; j < n; ++j) {
                        int n2 = j + i * n;
                        int n3 = intBuffer.get(n2) >> 24 & 0xFF;
                        if (n3 == 255) continue;
                        intBuffer.put(n2, 0);
                    }
                    Object object = Mouse.getImplementation().createCursor(width, height, xHotspot, yHotspot, 1, intBuffer, null);
                    long l = delays != null ? (long)delays.get(i) : 0L;
                    long l3 = System.currentTimeMillis();
                    cursor$CursorElementArray[i] = new Cursor$CursorElement(object, l, l3);
                    intBuffer.position(width * height * (i + 1));
                }
                break;
            }
            case 1: {
                Object object = Mouse.getImplementation().createCursor(width, height, xHotspot, yHotspot, numImages, intBuffer, delays);
                Cursor$CursorElement cursor$CursorElement = new Cursor$CursorElement(object, -1L, -1L);
                cursor$CursorElementArray = new Cursor$CursorElement[]{cursor$CursorElement};
                break;
            }
            default: {
                throw new RuntimeException("Unknown OS");
            }
        }
        return cursor$CursorElementArray;
    }

    private static void convertARGBtoABGR(IntBuffer imageBuffer) {
        for (int i = 0; i < imageBuffer.limit(); ++i) {
            int n = imageBuffer.get(i);
            byte by = (byte)(n >>> 24);
            byte by2 = (byte)(n >>> 16);
            byte by3 = (byte)(n >>> 8);
            byte by4 = (byte)n;
            int n2 = ((by & 0xFF) << 24) + ((by4 & 0xFF) << 16) + ((by3 & 0xFF) << 8) + (by2 & 0xFF);
            imageBuffer.put(i, n2);
        }
    }

    private static void flipImages(int width, int height, int numImages, IntBuffer images, IntBuffer images_copy) {
        for (int i = 0; i < numImages; ++i) {
            int n = i * width * height;
            Cursor.flipImage(width, height, n, images, images_copy);
        }
    }

    private static void flipImage(int width, int height, int start_index, IntBuffer images, IntBuffer images_copy) {
        for (int i = 0; i < height >> 1; ++i) {
            int n = i * width + start_index;
            int n2 = (height - i - 1) * width + start_index;
            for (int j = 0; j < width; ++j) {
                int n3 = n + j;
                int n4 = n2 + j;
                int n5 = images.get(n3 + images.position());
                images_copy.put(n3, images.get(n4 + images.position()));
                images_copy.put(n4, n5);
            }
        }
    }

    Object getHandle() {
        this.checkValid();
        return this.cursors[this.index].cursorHandle;
    }

    private void checkValid() {
        if (this.destroyed) {
            throw new IllegalStateException("The cursor is destroyed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            if (Mouse.getNativeCursor() == this) {
                try {
                    Mouse.setNativeCursor(null);
                }
                catch (LWJGLException lWJGLException) {
                    // empty catch block
                }
            }
            for (Cursor$CursorElement cursor$CursorElement : this.cursors) {
                Mouse.getImplementation().destroyCursor(cursor$CursorElement.cursorHandle);
            }
            this.destroyed = true;
        }
    }

    protected void setTimeout() {
        this.checkValid();
        this.cursors[this.index].timeout = System.currentTimeMillis() + this.cursors[this.index].delay;
    }

    protected boolean hasTimedOut() {
        this.checkValid();
        return this.cursors.length > 1 && this.cursors[this.index].timeout < System.currentTimeMillis();
    }

    protected void nextCursor() {
        this.checkValid();
        ++this.index;
        this.index %= this.cursors.length;
    }
}

