/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;

final class CLChecks {
    private CLChecks() {
    }

    static int calculateBufferRectSize(PointerBuffer offset, PointerBuffer region, long row_pitch, long slice_pitch) {
        if (!LWJGLUtil.CHECKS) {
            return 0;
        }
        long l = offset.get(0);
        long l2 = offset.get(1);
        long l3 = offset.get(2);
        if (LWJGLUtil.DEBUG && (l < 0L || l2 < 0L || l3 < 0L)) {
            throw new IllegalArgumentException("Invalid cl_mem host offset: " + l + ", " + l2 + ", " + l3);
        }
        long l4 = region.get(0);
        long l5 = region.get(1);
        long l6 = region.get(2);
        if (LWJGLUtil.DEBUG && (l4 < 1L || l5 < 1L || l6 < 1L)) {
            throw new IllegalArgumentException("Invalid cl_mem rectangle region dimensions: " + l4 + " x " + l5 + " x " + l6);
        }
        if (row_pitch == 0L) {
            row_pitch = l4;
        } else if (LWJGLUtil.DEBUG && row_pitch < l4) {
            throw new IllegalArgumentException("Invalid host row pitch specified: " + row_pitch);
        }
        if (slice_pitch == 0L) {
            slice_pitch = row_pitch * l5;
        } else if (LWJGLUtil.DEBUG && slice_pitch < row_pitch * l5) {
            throw new IllegalArgumentException("Invalid host slice pitch specified: " + slice_pitch);
        }
        return (int)(l3 * slice_pitch + l2 * row_pitch + l + l4 * l5 * l6);
    }

    static int calculateImageSize(PointerBuffer region, long row_pitch, long slice_pitch) {
        if (!LWJGLUtil.CHECKS) {
            return 0;
        }
        long l = region.get(0);
        long l2 = region.get(1);
        long l3 = region.get(2);
        if (LWJGLUtil.DEBUG && (l < 1L || l2 < 1L || l3 < 1L)) {
            throw new IllegalArgumentException("Invalid cl_mem image region dimensions: " + l + " x " + l2 + " x " + l3);
        }
        if (row_pitch == 0L) {
            row_pitch = l;
        } else if (LWJGLUtil.DEBUG && row_pitch < l) {
            throw new IllegalArgumentException("Invalid row pitch specified: " + row_pitch);
        }
        if (slice_pitch == 0L) {
            slice_pitch = row_pitch * l2;
        } else if (LWJGLUtil.DEBUG && slice_pitch < row_pitch * l2) {
            throw new IllegalArgumentException("Invalid slice pitch specified: " + slice_pitch);
        }
        return (int)(slice_pitch * l3);
    }

    static int calculateImage2DSize(ByteBuffer format, long w, long h, long row_pitch) {
        if (!LWJGLUtil.CHECKS) {
            return 0;
        }
        if (LWJGLUtil.DEBUG && (w < 1L || h < 1L)) {
            throw new IllegalArgumentException("Invalid 2D image dimensions: " + w + " x " + h);
        }
        int n = CLChecks.getElementSize(format);
        if (row_pitch == 0L) {
            row_pitch = w * (long)n;
        } else if (LWJGLUtil.DEBUG && (row_pitch < w * (long)n || row_pitch % (long)n != 0L)) {
            throw new IllegalArgumentException("Invalid image_row_pitch specified: " + row_pitch);
        }
        return (int)(row_pitch * h);
    }

    static int calculateImage3DSize(ByteBuffer format, long w, long h, long d, long row_pitch, long slice_pitch) {
        if (!LWJGLUtil.CHECKS) {
            return 0;
        }
        if (LWJGLUtil.DEBUG && (w < 1L || h < 1L || d < 2L)) {
            throw new IllegalArgumentException("Invalid 3D image dimensions: " + w + " x " + h + " x " + d);
        }
        int n = CLChecks.getElementSize(format);
        if (row_pitch == 0L) {
            row_pitch = w * (long)n;
        } else if (LWJGLUtil.DEBUG && (row_pitch < w * (long)n || row_pitch % (long)n != 0L)) {
            throw new IllegalArgumentException("Invalid image_row_pitch specified: " + row_pitch);
        }
        if (slice_pitch == 0L) {
            slice_pitch = row_pitch * h;
        } else if (LWJGLUtil.DEBUG && (row_pitch < row_pitch * h || slice_pitch % row_pitch != 0L)) {
            throw new IllegalArgumentException("Invalid image_slice_pitch specified: " + row_pitch);
        }
        return (int)(slice_pitch * d);
    }

    private static int getElementSize(ByteBuffer format) {
        int n = format.getInt(format.position() + 0);
        int n2 = format.getInt(format.position() + 4);
        return CLChecks.getChannelCount(n) * CLChecks.getChannelSize(n2);
    }

    private static int getChannelCount(int channelOrder) {
        switch (channelOrder) {
            case 4272: 
            case 4273: 
            case 4280: 
            case 4281: 
            case 4282: {
                return 1;
            }
            case 4274: 
            case 4275: 
            case 4283: {
                return 2;
            }
            case 4276: 
            case 4284: {
                return 3;
            }
            case 4277: 
            case 4278: 
            case 4279: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid cl_channel_order specified: " + LWJGLUtil.toHexString(channelOrder));
    }

    private static int getChannelSize(int channelType) {
        switch (channelType) {
            case 4304: 
            case 4306: 
            case 4311: 
            case 4314: {
                return 1;
            }
            case 4305: 
            case 4307: 
            case 4308: 
            case 4309: 
            case 4312: 
            case 4315: 
            case 4317: {
                return 2;
            }
            case 4310: 
            case 4313: 
            case 4316: 
            case 4318: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid cl_channel_type specified: " + LWJGLUtil.toHexString(channelType));
    }
}

