/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.PointerWrapperAbstract;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.InfoUtil;

abstract class InfoUtilAbstract<T extends CLObject>
implements InfoUtil<T> {
    protected InfoUtilAbstract() {
    }

    protected abstract int getInfo(T var1, int var2, ByteBuffer var3, PointerBuffer var4);

    protected int getInfoSizeArraySize(T object, int param_name) {
        throw new UnsupportedOperationException();
    }

    protected PointerBuffer getSizesBuffer(T object, int param_name) {
        int n = this.getInfoSizeArraySize(object, param_name);
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n);
        pointerBuffer.limit(n);
        this.getInfo(object, param_name, pointerBuffer.getBuffer(), null);
        return pointerBuffer;
    }

    @Override
    public int getInfoInt(T object, int param_name) {
        ((PointerWrapperAbstract)object).checkValid();
        ByteBuffer byteBuffer = APIUtil.getBufferByte(4);
        this.getInfo(object, param_name, byteBuffer, null);
        return byteBuffer.getInt(0);
    }

    @Override
    public long getInfoSize(T object, int param_name) {
        ((PointerWrapperAbstract)object).checkValid();
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer();
        this.getInfo(object, param_name, pointerBuffer.getBuffer(), null);
        return pointerBuffer.get(0);
    }

    @Override
    public long[] getInfoSizeArray(T object, int param_name) {
        ((PointerWrapperAbstract)object).checkValid();
        int n = this.getInfoSizeArraySize(object, param_name);
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n);
        this.getInfo(object, param_name, pointerBuffer.getBuffer(), null);
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = pointerBuffer.get(i);
        }
        return lArray;
    }

    @Override
    public long getInfoLong(T object, int param_name) {
        ((PointerWrapperAbstract)object).checkValid();
        ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
        this.getInfo(object, param_name, byteBuffer, null);
        return byteBuffer.getLong(0);
    }

    @Override
    public String getInfoString(T object, int param_name) {
        ((PointerWrapperAbstract)object).checkValid();
        int n = this.getSizeRet(object, param_name);
        if (n <= 1) {
            return null;
        }
        ByteBuffer byteBuffer = APIUtil.getBufferByte(n);
        this.getInfo(object, param_name, byteBuffer, null);
        byteBuffer.limit(n - 1);
        return APIUtil.getString(byteBuffer);
    }

    protected final int getSizeRet(T object, int param_name) {
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer();
        int n = this.getInfo(object, param_name, null, pointerBuffer);
        if (n != 0) {
            throw new IllegalArgumentException("Invalid parameter specified: " + LWJGLUtil.toHexString(param_name));
        }
        return (int)pointerBuffer.get(0);
    }
}

