/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.BufferChecks;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLContext$CLContextUtil;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CallbackUtil;
import org.lwjgl.opencl.InfoUtilAbstract;
import org.lwjgl.opencl.InfoUtilFactory$1;
import org.lwjgl.opencl.Util;
import org.lwjgl.opencl.api.CLImageFormat;
import org.lwjgl.opencl.api.Filter;
import org.lwjgl.opengl.Drawable;

final class InfoUtilFactory$CLContextUtil
extends InfoUtilAbstract<CLContext>
implements CLContext$CLContextUtil {
    private InfoUtilFactory$CLContextUtil() {
    }

    @Override
    protected int getInfo(CLContext context, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        return CL10.clGetContextInfo(context, param_name, param_value, param_value_size_ret);
    }

    @Override
    public List<CLDevice> getInfoDevices(CLContext context) {
        PointerBuffer pointerBuffer;
        int n;
        context.checkValid();
        if (CLCapabilities.getPlatformCapabilities((CLPlatform)((CLPlatform)context.getParent())).OpenCL11) {
            n = this.getInfoInt(context, 4227);
        } else {
            pointerBuffer = APIUtil.getBufferPointer();
            CL10.clGetContextInfo(context, 4225, null, pointerBuffer);
            n = (int)(pointerBuffer.get(0) / (long)PointerBuffer.getPointerSize());
        }
        pointerBuffer = APIUtil.getBufferPointer(n);
        CL10.clGetContextInfo(context, 4225, pointerBuffer.getBuffer(), null);
        ArrayList<CLDevice> arrayList = new ArrayList<CLDevice>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(((CLPlatform)context.getParent()).getCLDevice(pointerBuffer.get(i)));
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLContext create(CLPlatform platform, List<CLDevice> devices, CLContextCallback pfn_notify, Drawable share_drawable, IntBuffer errcode_ret) {
        int n = 2 + (share_drawable == null ? 0 : 4) + 1;
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n + devices.size());
        pointerBuffer.put(4228L).put(platform);
        if (share_drawable != null) {
            share_drawable.setCLSharingProperties(pointerBuffer);
        }
        pointerBuffer.put(0L);
        pointerBuffer.position(n);
        for (CLDevice cLDevice : devices) {
            pointerBuffer.put(cLDevice);
        }
        long l = CLCapabilities.clCreateContext;
        BufferChecks.checkFunctionAddress(l);
        if (errcode_ret != null) {
            BufferChecks.checkBuffer(errcode_ret, 1);
        } else if (LWJGLUtil.DEBUG) {
            errcode_ret = APIUtil.getBufferInt();
        }
        long l2 = pfn_notify == null || pfn_notify.isCustom() ? 0L : CallbackUtil.createGlobalRef(pfn_notify);
        CLContext cLContext = null;
        try {
            cLContext = new CLContext(CL10.nclCreateContext(MemoryUtil.getAddress0(pointerBuffer.getBuffer()), devices.size(), MemoryUtil.getAddress(pointerBuffer, n), pfn_notify == null ? 0L : pfn_notify.getPointer(), l2, MemoryUtil.getAddressSafe(errcode_ret), l), platform);
            if (LWJGLUtil.DEBUG) {
                Util.checkCLError(errcode_ret.get(0));
            }
            CLContext cLContext2 = cLContext;
            return cLContext2;
        }
        finally {
            if (cLContext != null) {
                cLContext.setContextCallback(l2);
            }
        }
    }

    @Override
    public CLContext createFromType(CLPlatform platform, long device_type, CLContextCallback pfn_notify, Drawable share_drawable, IntBuffer errcode_ret) {
        int n = 2 + (share_drawable == null ? 0 : 4) + 1;
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n);
        pointerBuffer.put(4228L).put(platform);
        if (share_drawable != null) {
            share_drawable.setCLSharingProperties(pointerBuffer);
        }
        pointerBuffer.put(0L);
        pointerBuffer.flip();
        return CL10.clCreateContextFromType(pointerBuffer, device_type, pfn_notify, errcode_ret);
    }

    @Override
    public List<CLImageFormat> getSupportedImageFormats(CLContext context, long flags, int image_type, Filter<CLImageFormat> filter) {
        IntBuffer intBuffer = APIUtil.getBufferInt();
        CL10.clGetSupportedImageFormats(context, flags, image_type, null, intBuffer);
        int n = intBuffer.get(0);
        if (n == 0) {
            return null;
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n * 8);
        CL10.clGetSupportedImageFormats(context, flags, image_type, byteBuffer, null);
        ArrayList<CLImageFormat> arrayList = new ArrayList<CLImageFormat>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = n * 8;
            CLImageFormat cLImageFormat = new CLImageFormat(byteBuffer.getInt(n2), byteBuffer.getInt(n2 + 4));
            if (filter != null && !filter.accept(cLImageFormat)) continue;
            arrayList.add(cLImageFormat);
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    /* synthetic */ InfoUtilFactory$CLContextUtil(InfoUtilFactory$1 x0) {
        this();
    }
}

