/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLChecks;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLMem$CLMemUtil;
import org.lwjgl.opencl.InfoUtilAbstract;
import org.lwjgl.opencl.InfoUtilFactory$1;
import org.lwjgl.opencl.Util;
import org.lwjgl.opencl.api.CLBufferRegion;
import org.lwjgl.opencl.api.CLImageFormat;

final class InfoUtilFactory$CLMemUtil
extends InfoUtilAbstract<CLMem>
implements CLMem$CLMemUtil {
    private InfoUtilFactory$CLMemUtil() {
    }

    @Override
    protected int getInfo(CLMem mem, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        return CL10.clGetMemObjectInfo(mem, param_name, param_value, param_value_size_ret);
    }

    @Override
    public CLMem createImage2D(CLContext context, long flags, CLImageFormat image_format, long image_width, long image_height, long image_row_pitch, Buffer host_ptr, IntBuffer errcode_ret) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
        byteBuffer.putInt(0, image_format.getChannelOrder());
        byteBuffer.putInt(4, image_format.getChannelType());
        long l = CLCapabilities.clCreateImage2D;
        BufferChecks.checkFunctionAddress(l);
        if (errcode_ret != null) {
            BufferChecks.checkBuffer(errcode_ret, 1);
        } else if (LWJGLUtil.DEBUG) {
            errcode_ret = APIUtil.getBufferInt();
        }
        CLMem cLMem = new CLMem(CL10.nclCreateImage2D(context.getPointer(), flags, MemoryUtil.getAddress(byteBuffer, 0), image_width, image_height, image_row_pitch, MemoryUtil.getAddress0Safe(host_ptr) + (long)(host_ptr != null ? BufferChecks.checkBuffer(host_ptr, CLChecks.calculateImage2DSize(byteBuffer, image_width, image_height, image_row_pitch)) : 0), MemoryUtil.getAddressSafe(errcode_ret), l), context);
        if (LWJGLUtil.DEBUG) {
            Util.checkCLError(errcode_ret.get(0));
        }
        return cLMem;
    }

    @Override
    public CLMem createImage3D(CLContext context, long flags, CLImageFormat image_format, long image_width, long image_height, long image_depth, long image_row_pitch, long image_slice_pitch, Buffer host_ptr, IntBuffer errcode_ret) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
        byteBuffer.putInt(0, image_format.getChannelOrder());
        byteBuffer.putInt(4, image_format.getChannelType());
        long l = CLCapabilities.clCreateImage3D;
        BufferChecks.checkFunctionAddress(l);
        if (errcode_ret != null) {
            BufferChecks.checkBuffer(errcode_ret, 1);
        } else if (LWJGLUtil.DEBUG) {
            errcode_ret = APIUtil.getBufferInt();
        }
        CLMem cLMem = new CLMem(CL10.nclCreateImage3D(context.getPointer(), flags, MemoryUtil.getAddress(byteBuffer, 0), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.getAddress0Safe(host_ptr) + (long)(host_ptr != null ? BufferChecks.checkBuffer(host_ptr, CLChecks.calculateImage3DSize(byteBuffer, image_width, image_height, image_depth, image_row_pitch, image_slice_pitch)) : 0), MemoryUtil.getAddressSafe(errcode_ret), l), context);
        if (LWJGLUtil.DEBUG) {
            Util.checkCLError(errcode_ret.get(0));
        }
        return cLMem;
    }

    @Override
    public CLMem createSubBuffer(CLMem mem, long flags, int buffer_create_type, CLBufferRegion buffer_create_info, IntBuffer errcode_ret) {
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(2);
        pointerBuffer.put(buffer_create_info.getOrigin());
        pointerBuffer.put(buffer_create_info.getSize());
        return CL11.clCreateSubBuffer(mem, flags, buffer_create_type, pointerBuffer.getBuffer(), errcode_ret);
    }

    @Override
    public ByteBuffer getInfoHostBuffer(CLMem mem) {
        long l;
        mem.checkValid();
        if (LWJGLUtil.DEBUG && ((l = this.getInfoLong(mem, 4353)) & 8L) != 8L) {
            throw new IllegalArgumentException("The specified CLMem object does not use host memory.");
        }
        l = this.getInfoSize(mem, 4354);
        if (l == 0L) {
            return null;
        }
        long l2 = this.getInfoSize(mem, 4355);
        return CL.getHostBuffer(l2, (int)l);
    }

    @Override
    public long getImageInfoSize(CLMem mem, int param_name) {
        mem.checkValid();
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer();
        CL10.clGetImageInfo(mem, param_name, pointerBuffer.getBuffer(), null);
        return pointerBuffer.get(0);
    }

    @Override
    public CLImageFormat getImageInfoFormat(CLMem mem) {
        mem.checkValid();
        ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
        CL10.clGetImageInfo(mem, 4368, byteBuffer, null);
        return new CLImageFormat(byteBuffer.getInt(0), byteBuffer.getInt(4));
    }

    @Override
    public int getImageInfoFormat(CLMem mem, int index) {
        mem.checkValid();
        ByteBuffer byteBuffer = APIUtil.getBufferByte(8);
        CL10.clGetImageInfo(mem, 4368, byteBuffer, null);
        return byteBuffer.getInt(index << 2);
    }

    @Override
    public int getGLObjectType(CLMem mem) {
        mem.checkValid();
        IntBuffer intBuffer = APIUtil.getBufferInt();
        CL10GL.clGetGLObjectInfo(mem, intBuffer, null);
        return intBuffer.get(0);
    }

    @Override
    public int getGLObjectName(CLMem mem) {
        mem.checkValid();
        IntBuffer intBuffer = APIUtil.getBufferInt();
        CL10GL.clGetGLObjectInfo(mem, null, intBuffer);
        return intBuffer.get(0);
    }

    @Override
    public int getGLTextureInfoInt(CLMem mem, int param_name) {
        mem.checkValid();
        ByteBuffer byteBuffer = APIUtil.getBufferByte(4);
        CL10GL.clGetGLTextureInfo(mem, param_name, byteBuffer, null);
        return byteBuffer.getInt(0);
    }

    /* synthetic */ InfoUtilFactory$CLMemUtil(InfoUtilFactory$1 x0) {
        this();
    }
}

