/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.CLProgram$CLProgramUtil;
import org.lwjgl.opencl.InfoUtilAbstract;
import org.lwjgl.opencl.InfoUtilFactory$1;

final class InfoUtilFactory$CLProgramUtil
extends InfoUtilAbstract<CLProgram>
implements CLProgram$CLProgramUtil {
    private InfoUtilFactory$CLProgramUtil() {
    }

    @Override
    protected int getInfo(CLProgram program, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        return CL10.clGetProgramInfo(program, param_name, param_value, param_value_size_ret);
    }

    @Override
    protected int getInfoSizeArraySize(CLProgram program, int param_name) {
        switch (param_name) {
            case 4453: {
                return this.getInfoInt(program, 4450);
            }
        }
        throw new IllegalArgumentException("Unsupported parameter: " + LWJGLUtil.toHexString(param_name));
    }

    @Override
    public CLKernel[] createKernelsInProgram(CLProgram program) {
        IntBuffer intBuffer = APIUtil.getBufferInt();
        CL10.clCreateKernelsInProgram(program, null, intBuffer);
        int n = intBuffer.get(0);
        if (n == 0) {
            return null;
        }
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n);
        CL10.clCreateKernelsInProgram(program, pointerBuffer, null);
        CLKernel[] cLKernelArray = new CLKernel[n];
        for (int i = 0; i < n; ++i) {
            cLKernelArray[i] = program.getCLKernel(pointerBuffer.get(i));
        }
        return cLKernelArray;
    }

    @Override
    public CLDevice[] getInfoDevices(CLProgram program) {
        program.checkValid();
        int n = this.getInfoInt(program, 4450);
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer(n);
        CL10.clGetProgramInfo(program, 4451, pointerBuffer.getBuffer(), null);
        CLPlatform cLPlatform = (CLPlatform)((CLContext)program.getParent()).getParent();
        CLDevice[] cLDeviceArray = new CLDevice[n];
        for (int i = 0; i < n; ++i) {
            cLDeviceArray[i] = cLPlatform.getCLDevice(pointerBuffer.get(i));
        }
        return cLDeviceArray;
    }

    @Override
    public ByteBuffer getInfoBinaries(CLProgram program, ByteBuffer target) {
        program.checkValid();
        PointerBuffer pointerBuffer = this.getSizesBuffer(program, 4453);
        int n = 0;
        for (int i = 0; i < pointerBuffer.limit(); ++i) {
            n = (int)((long)n + pointerBuffer.get(i));
        }
        if (target == null) {
            target = BufferUtils.createByteBuffer(n);
        } else if (LWJGLUtil.DEBUG) {
            BufferChecks.checkBuffer(target, n);
        }
        CL10.clGetProgramInfo(program, pointerBuffer, target, null);
        return target;
    }

    @Override
    public ByteBuffer[] getInfoBinaries(CLProgram program, ByteBuffer[] target) {
        program.checkValid();
        if (target == null) {
            PointerBuffer pointerBuffer = this.getSizesBuffer(program, 4453);
            target = new ByteBuffer[pointerBuffer.remaining()];
            for (int i = 0; i < pointerBuffer.remaining(); ++i) {
                target[i] = BufferUtils.createByteBuffer((int)pointerBuffer.get(i));
            }
        } else if (LWJGLUtil.DEBUG) {
            PointerBuffer pointerBuffer = this.getSizesBuffer(program, 4453);
            if (target.length < pointerBuffer.remaining()) {
                throw new IllegalArgumentException("The target array is not big enough: " + pointerBuffer.remaining() + " buffers are required.");
            }
            for (int i = 0; i < target.length; ++i) {
                BufferChecks.checkBuffer(target[i], (int)pointerBuffer.get(i));
            }
        }
        CL10.clGetProgramInfo(program, target, null);
        return target;
    }

    @Override
    public String getBuildInfoString(CLProgram program, CLDevice device, int param_name) {
        program.checkValid();
        int n = InfoUtilFactory$CLProgramUtil.getBuildSizeRet(program, device, param_name);
        if (n <= 1) {
            return null;
        }
        ByteBuffer byteBuffer = APIUtil.getBufferByte(n);
        CL10.clGetProgramBuildInfo(program, device, param_name, byteBuffer, null);
        byteBuffer.limit(n - 1);
        return APIUtil.getString(byteBuffer);
    }

    @Override
    public int getBuildInfoInt(CLProgram program, CLDevice device, int param_name) {
        program.checkValid();
        ByteBuffer byteBuffer = APIUtil.getBufferByte(4);
        CL10.clGetProgramBuildInfo(program, device, param_name, byteBuffer, null);
        return byteBuffer.getInt(0);
    }

    private static int getBuildSizeRet(CLProgram program, CLDevice device, int param_name) {
        PointerBuffer pointerBuffer = APIUtil.getBufferPointer();
        int n = CL10.clGetProgramBuildInfo(program, device, param_name, null, pointerBuffer);
        if (n != 0) {
            throw new IllegalArgumentException("Invalid parameter specified: " + LWJGLUtil.toHexString(param_name));
        }
        return (int)pointerBuffer.get(0);
    }

    /* synthetic */ InfoUtilFactory$CLProgramUtil(InfoUtilFactory$1 x0) {
        this();
    }
}

