/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class AMDNameGenDelete {
    public static final int GL_DATA_BUFFER_AMD = 37201;
    public static final int GL_PERFORMANCE_MONITOR_AMD = 37202;
    public static final int GL_QUERY_OBJECT_AMD = 37203;
    public static final int GL_VERTEX_ARRAY_OBJECT_AMD = 37204;
    public static final int GL_SAMPLER_OBJECT_AMD = 37205;

    private AMDNameGenDelete() {
    }

    public static void glGenNamesAMD(int identifier, IntBuffer names) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenNamesAMD;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(names);
        AMDNameGenDelete.nglGenNamesAMD(identifier, names.remaining(), MemoryUtil.getAddress(names), l);
    }

    static native void nglGenNamesAMD(int var0, int var1, long var2, long var4);

    public static int glGenNamesAMD(int identifier) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenNamesAMD;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        AMDNameGenDelete.nglGenNamesAMD(identifier, 1, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glDeleteNamesAMD(int identifier, IntBuffer names) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteNamesAMD;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(names);
        AMDNameGenDelete.nglDeleteNamesAMD(identifier, names.remaining(), MemoryUtil.getAddress(names), l);
    }

    static native void nglDeleteNamesAMD(int var0, int var1, long var2, long var4);

    public static void glDeleteNamesAMD(int identifier, int name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteNamesAMD;
        BufferChecks.checkFunctionAddress(l);
        AMDNameGenDelete.nglDeleteNamesAMD(identifier, 1, APIUtil.getInt(contextCapabilities, name), l);
    }

    public static boolean glIsNameAMD(int identifier, int name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsNameAMD;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = AMDNameGenDelete.nglIsNameAMD(identifier, name, l);
        return bl;
    }

    static native boolean nglIsNameAMD(int var0, int var1, long var2);
}

