/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class AMDPerformanceMonitor {
    public static final int GL_COUNTER_TYPE_AMD = 35776;
    public static final int GL_COUNTER_RANGE_AMD = 35777;
    public static final int GL_UNSIGNED_INT64_AMD = 35778;
    public static final int GL_PERCENTAGE_AMD = 35779;
    public static final int GL_PERFMON_RESULT_AVAILABLE_AMD = 35780;
    public static final int GL_PERFMON_RESULT_SIZE_AMD = 35781;
    public static final int GL_PERFMON_RESULT_AMD = 35782;

    private AMDPerformanceMonitor() {
    }

    public static void glGetPerfMonitorGroupsAMD(IntBuffer numGroups, IntBuffer groups) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPerfMonitorGroupsAMD;
        BufferChecks.checkFunctionAddress(l);
        if (numGroups != null) {
            BufferChecks.checkBuffer(numGroups, 1);
        }
        BufferChecks.checkDirect(groups);
        AMDPerformanceMonitor.nglGetPerfMonitorGroupsAMD(MemoryUtil.getAddressSafe(numGroups), groups.remaining(), MemoryUtil.getAddress(groups), l);
    }

    static native void nglGetPerfMonitorGroupsAMD(long var0, int var2, long var3, long var5);

    public static void glGetPerfMonitorCountersAMD(int group, IntBuffer numCounters, IntBuffer maxActiveCounters, IntBuffer counters) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPerfMonitorCountersAMD;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(numCounters, 1);
        BufferChecks.checkBuffer(maxActiveCounters, 1);
        if (counters != null) {
            BufferChecks.checkDirect(counters);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCountersAMD(group, MemoryUtil.getAddress(numCounters), MemoryUtil.getAddress(maxActiveCounters), counters == null ? 0 : counters.remaining(), MemoryUtil.getAddressSafe(counters), l);
    }

    static native void nglGetPerfMonitorCountersAMD(int var0, long var1, long var3, int var5, long var6, long var8);

    public static void glGetPerfMonitorGroupStringAMD(int group, IntBuffer length, ByteBuffer groupString) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPerfMonitorGroupStringAMD;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        if (groupString != null) {
            BufferChecks.checkDirect(groupString);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(group, groupString == null ? 0 : groupString.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddressSafe(groupString), l);
    }

    static native void nglGetPerfMonitorGroupStringAMD(int var0, int var1, long var2, long var4, long var6);

    public static String glGetPerfMonitorGroupStringAMD(int group, int bufSize) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPerfMonitorGroupStringAMD;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, bufSize);
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(group, bufSize, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetPerfMonitorCounterStringAMD(int group, int counter, IntBuffer length, ByteBuffer counterString) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPerfMonitorCounterStringAMD;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        if (counterString != null) {
            BufferChecks.checkDirect(counterString);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(group, counter, counterString == null ? 0 : counterString.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddressSafe(counterString), l);
    }

    static native void nglGetPerfMonitorCounterStringAMD(int var0, int var1, int var2, long var3, long var5, long var7);

    public static String glGetPerfMonitorCounterStringAMD(int group, int counter, int bufSize) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPerfMonitorCounterStringAMD;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, bufSize);
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(group, counter, bufSize, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPerfMonitorCounterInfoAMD;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(data, 16);
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.getAddress(data), l);
    }

    static native void nglGetPerfMonitorCounterInfoAMD(int var0, int var1, int var2, long var3, long var5);

    public static void glGenPerfMonitorsAMD(IntBuffer monitors) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenPerfMonitorsAMD;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(monitors);
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(monitors.remaining(), MemoryUtil.getAddress(monitors), l);
    }

    static native void nglGenPerfMonitorsAMD(int var0, long var1, long var3);

    public static int glGenPerfMonitorsAMD() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenPerfMonitorsAMD;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(1, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glDeletePerfMonitorsAMD(IntBuffer monitors) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeletePerfMonitorsAMD;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(monitors);
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(monitors.remaining(), MemoryUtil.getAddress(monitors), l);
    }

    static native void nglDeletePerfMonitorsAMD(int var0, long var1, long var3);

    public static void glDeletePerfMonitorsAMD(int monitor) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeletePerfMonitorsAMD;
        BufferChecks.checkFunctionAddress(l);
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(1, APIUtil.getInt(contextCapabilities, monitor), l);
    }

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, IntBuffer counterList) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSelectPerfMonitorCountersAMD;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(counterList);
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(monitor, enable, group, counterList.remaining(), MemoryUtil.getAddress(counterList), l);
    }

    static native void nglSelectPerfMonitorCountersAMD(int var0, boolean var1, int var2, int var3, long var4, long var6);

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, int counter) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSelectPerfMonitorCountersAMD;
        BufferChecks.checkFunctionAddress(l);
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(monitor, enable, group, 1, APIUtil.getInt(contextCapabilities, counter), l);
    }

    public static void glBeginPerfMonitorAMD(int monitor) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBeginPerfMonitorAMD;
        BufferChecks.checkFunctionAddress(l);
        AMDPerformanceMonitor.nglBeginPerfMonitorAMD(monitor, l);
    }

    static native void nglBeginPerfMonitorAMD(int var0, long var1);

    public static void glEndPerfMonitorAMD(int monitor) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glEndPerfMonitorAMD;
        BufferChecks.checkFunctionAddress(l);
        AMDPerformanceMonitor.nglEndPerfMonitorAMD(monitor, l);
    }

    static native void nglEndPerfMonitorAMD(int var0, long var1);

    public static void glGetPerfMonitorCounterDataAMD(int monitor, int pname, IntBuffer data, IntBuffer bytesWritten) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPerfMonitorCounterDataAMD;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        if (bytesWritten != null) {
            BufferChecks.checkBuffer(bytesWritten, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(monitor, pname, data.remaining(), MemoryUtil.getAddress(data), MemoryUtil.getAddressSafe(bytesWritten), l);
    }

    static native void nglGetPerfMonitorCounterDataAMD(int var0, int var1, int var2, long var3, long var5, long var7);

    public static int glGetPerfMonitorCounterDataAMD(int monitor, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPerfMonitorCounterDataAMD;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(monitor, pname, 4, MemoryUtil.getAddress(intBuffer), 0L, l);
        return intBuffer.get(0);
    }
}

