/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.LongBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class ARBBindlessTexture {
    public static final int GL_UNSIGNED_INT64_ARB = 5135;

    private ARBBindlessTexture() {
    }

    public static long glGetTextureHandleARB(int texture) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureHandleARB;
        BufferChecks.checkFunctionAddress(l);
        long l2 = ARBBindlessTexture.nglGetTextureHandleARB(texture, l);
        return l2;
    }

    static native long nglGetTextureHandleARB(int var0, long var1);

    public static long glGetTextureSamplerHandleARB(int texture, int sampler) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTextureSamplerHandleARB;
        BufferChecks.checkFunctionAddress(l);
        long l2 = ARBBindlessTexture.nglGetTextureSamplerHandleARB(texture, sampler, l);
        return l2;
    }

    static native long nglGetTextureSamplerHandleARB(int var0, int var1, long var2);

    public static void glMakeTextureHandleResidentARB(long handle) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMakeTextureHandleResidentARB;
        BufferChecks.checkFunctionAddress(l);
        ARBBindlessTexture.nglMakeTextureHandleResidentARB(handle, l);
    }

    static native void nglMakeTextureHandleResidentARB(long var0, long var2);

    public static void glMakeTextureHandleNonResidentARB(long handle) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMakeTextureHandleNonResidentARB;
        BufferChecks.checkFunctionAddress(l);
        ARBBindlessTexture.nglMakeTextureHandleNonResidentARB(handle, l);
    }

    static native void nglMakeTextureHandleNonResidentARB(long var0, long var2);

    public static long glGetImageHandleARB(int texture, int level, boolean layered, int layer, int format) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetImageHandleARB;
        BufferChecks.checkFunctionAddress(l);
        long l2 = ARBBindlessTexture.nglGetImageHandleARB(texture, level, layered, layer, format, l);
        return l2;
    }

    static native long nglGetImageHandleARB(int var0, int var1, boolean var2, int var3, int var4, long var5);

    public static void glMakeImageHandleResidentARB(long handle, int access) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMakeImageHandleResidentARB;
        BufferChecks.checkFunctionAddress(l);
        ARBBindlessTexture.nglMakeImageHandleResidentARB(handle, access, l);
    }

    static native void nglMakeImageHandleResidentARB(long var0, int var2, long var3);

    public static void glMakeImageHandleNonResidentARB(long handle) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMakeImageHandleNonResidentARB;
        BufferChecks.checkFunctionAddress(l);
        ARBBindlessTexture.nglMakeImageHandleNonResidentARB(handle, l);
    }

    static native void nglMakeImageHandleNonResidentARB(long var0, long var2);

    public static void glUniformHandleui64ARB(int location, long value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformHandleui64ARB;
        BufferChecks.checkFunctionAddress(l);
        ARBBindlessTexture.nglUniformHandleui64ARB(location, value, l);
    }

    static native void nglUniformHandleui64ARB(int var0, long var1, long var3);

    public static void glUniformHandleuARB(int location, LongBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformHandleui64vARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        ARBBindlessTexture.nglUniformHandleui64vARB(location, value.remaining(), MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformHandleui64vARB(int var0, int var1, long var2, long var4);

    public static void glProgramUniformHandleui64ARB(int program, int location, long value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformHandleui64ARB;
        BufferChecks.checkFunctionAddress(l);
        ARBBindlessTexture.nglProgramUniformHandleui64ARB(program, location, value, l);
    }

    static native void nglProgramUniformHandleui64ARB(int var0, int var1, long var2, long var4);

    public static void glProgramUniformHandleuARB(int program, int location, LongBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformHandleui64vARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        ARBBindlessTexture.nglProgramUniformHandleui64vARB(program, location, values.remaining(), MemoryUtil.getAddress(values), l);
    }

    static native void nglProgramUniformHandleui64vARB(int var0, int var1, int var2, long var3, long var5);

    public static boolean glIsTextureHandleResidentARB(long handle) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsTextureHandleResidentARB;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = ARBBindlessTexture.nglIsTextureHandleResidentARB(handle, l);
        return bl;
    }

    static native boolean nglIsTextureHandleResidentARB(long var0, long var2);

    public static boolean glIsImageHandleResidentARB(long handle) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsImageHandleResidentARB;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = ARBBindlessTexture.nglIsImageHandleResidentARB(handle, l);
        return bl;
    }

    static native boolean nglIsImageHandleResidentARB(long var0, long var2);

    public static void glVertexAttribL1ui64ARB(int index, long x) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttribL1ui64ARB;
        BufferChecks.checkFunctionAddress(l);
        ARBBindlessTexture.nglVertexAttribL1ui64ARB(index, x, l);
    }

    static native void nglVertexAttribL1ui64ARB(int var0, long var1, long var3);

    public static void glVertexAttribL1uARB(int index, LongBuffer v) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttribL1ui64vARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(v, 1);
        ARBBindlessTexture.nglVertexAttribL1ui64vARB(index, MemoryUtil.getAddress(v), l);
    }

    static native void nglVertexAttribL1ui64vARB(int var0, long var1, long var3);

    public static void glGetVertexAttribLuARB(int index, int pname, LongBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexAttribLui64vARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        ARBBindlessTexture.nglGetVertexAttribLui64vARB(index, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetVertexAttribLui64vARB(int var0, int var1, long var2, long var4);
}

