/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class ARBShaderObjects {
    public static final int GL_PROGRAM_OBJECT_ARB = 35648;
    public static final int GL_OBJECT_TYPE_ARB = 35662;
    public static final int GL_OBJECT_SUBTYPE_ARB = 35663;
    public static final int GL_OBJECT_DELETE_STATUS_ARB = 35712;
    public static final int GL_OBJECT_COMPILE_STATUS_ARB = 35713;
    public static final int GL_OBJECT_LINK_STATUS_ARB = 35714;
    public static final int GL_OBJECT_VALIDATE_STATUS_ARB = 35715;
    public static final int GL_OBJECT_INFO_LOG_LENGTH_ARB = 35716;
    public static final int GL_OBJECT_ATTACHED_OBJECTS_ARB = 35717;
    public static final int GL_OBJECT_ACTIVE_UNIFORMS_ARB = 35718;
    public static final int GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 35719;
    public static final int GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 35720;
    public static final int GL_SHADER_OBJECT_ARB = 35656;
    public static final int GL_FLOAT_VEC2_ARB = 35664;
    public static final int GL_FLOAT_VEC3_ARB = 35665;
    public static final int GL_FLOAT_VEC4_ARB = 35666;
    public static final int GL_INT_VEC2_ARB = 35667;
    public static final int GL_INT_VEC3_ARB = 35668;
    public static final int GL_INT_VEC4_ARB = 35669;
    public static final int GL_BOOL_ARB = 35670;
    public static final int GL_BOOL_VEC2_ARB = 35671;
    public static final int GL_BOOL_VEC3_ARB = 35672;
    public static final int GL_BOOL_VEC4_ARB = 35673;
    public static final int GL_FLOAT_MAT2_ARB = 35674;
    public static final int GL_FLOAT_MAT3_ARB = 35675;
    public static final int GL_FLOAT_MAT4_ARB = 35676;
    public static final int GL_SAMPLER_1D_ARB = 35677;
    public static final int GL_SAMPLER_2D_ARB = 35678;
    public static final int GL_SAMPLER_3D_ARB = 35679;
    public static final int GL_SAMPLER_CUBE_ARB = 35680;
    public static final int GL_SAMPLER_1D_SHADOW_ARB = 35681;
    public static final int GL_SAMPLER_2D_SHADOW_ARB = 35682;
    public static final int GL_SAMPLER_2D_RECT_ARB = 35683;
    public static final int GL_SAMPLER_2D_RECT_SHADOW_ARB = 35684;

    private ARBShaderObjects() {
    }

    public static void glDeleteObjectARB(int obj) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteObjectARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglDeleteObjectARB(obj, l);
    }

    static native void nglDeleteObjectARB(int var0, long var1);

    public static int glGetHandleARB(int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetHandleARB;
        BufferChecks.checkFunctionAddress(l);
        int n = ARBShaderObjects.nglGetHandleARB(pname, l);
        return n;
    }

    static native int nglGetHandleARB(int var0, long var1);

    public static void glDetachObjectARB(int containerObj, int attachedObj) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDetachObjectARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglDetachObjectARB(containerObj, attachedObj, l);
    }

    static native void nglDetachObjectARB(int var0, int var1, long var2);

    public static int glCreateShaderObjectARB(int shaderType) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCreateShaderObjectARB;
        BufferChecks.checkFunctionAddress(l);
        int n = ARBShaderObjects.nglCreateShaderObjectARB(shaderType, l);
        return n;
    }

    static native int nglCreateShaderObjectARB(int var0, long var1);

    public static void glShaderSourceARB(int shader, ByteBuffer string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glShaderSourceARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(string);
        ARBShaderObjects.nglShaderSourceARB(shader, 1, MemoryUtil.getAddress(string), string.remaining(), l);
    }

    static native void nglShaderSourceARB(int var0, int var1, long var2, int var4, long var5);

    public static void glShaderSourceARB(int shader, CharSequence string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glShaderSourceARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglShaderSourceARB(shader, 1, APIUtil.getBuffer(contextCapabilities, string), string.length(), l);
    }

    public static void glShaderSourceARB(int shader, CharSequence[] strings) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glShaderSourceARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkArray(strings);
        ARBShaderObjects.nglShaderSourceARB3(shader, strings.length, APIUtil.getBuffer(contextCapabilities, strings), APIUtil.getLengths(contextCapabilities, strings), l);
    }

    static native void nglShaderSourceARB3(int var0, int var1, long var2, long var4, long var6);

    public static void glCompileShaderARB(int shaderObj) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompileShaderARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglCompileShaderARB(shaderObj, l);
    }

    static native void nglCompileShaderARB(int var0, long var1);

    public static int glCreateProgramObjectARB() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCreateProgramObjectARB;
        BufferChecks.checkFunctionAddress(l);
        int n = ARBShaderObjects.nglCreateProgramObjectARB(l);
        return n;
    }

    static native int nglCreateProgramObjectARB(long var0);

    public static void glAttachObjectARB(int containerObj, int obj) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glAttachObjectARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglAttachObjectARB(containerObj, obj, l);
    }

    static native void nglAttachObjectARB(int var0, int var1, long var2);

    public static void glLinkProgramARB(int programObj) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glLinkProgramARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglLinkProgramARB(programObj, l);
    }

    static native void nglLinkProgramARB(int var0, long var1);

    public static void glUseProgramObjectARB(int programObj) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUseProgramObjectARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglUseProgramObjectARB(programObj, l);
    }

    static native void nglUseProgramObjectARB(int var0, long var1);

    public static void glValidateProgramARB(int programObj) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glValidateProgramARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglValidateProgramARB(programObj, l);
    }

    static native void nglValidateProgramARB(int var0, long var1);

    public static void glUniform1fARB(int location, float v0) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform1fARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglUniform1fARB(location, v0, l);
    }

    static native void nglUniform1fARB(int var0, float var1, long var2);

    public static void glUniform2fARB(int location, float v0, float v1) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform2fARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglUniform2fARB(location, v0, v1, l);
    }

    static native void nglUniform2fARB(int var0, float var1, float var2, long var3);

    public static void glUniform3fARB(int location, float v0, float v1, float v2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform3fARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglUniform3fARB(location, v0, v1, v2, l);
    }

    static native void nglUniform3fARB(int var0, float var1, float var2, float var3, long var4);

    public static void glUniform4fARB(int location, float v0, float v1, float v2, float v3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform4fARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglUniform4fARB(location, v0, v1, v2, v3, l);
    }

    static native void nglUniform4fARB(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glUniform1iARB(int location, int v0) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform1iARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglUniform1iARB(location, v0, l);
    }

    static native void nglUniform1iARB(int var0, int var1, long var2);

    public static void glUniform2iARB(int location, int v0, int v1) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform2iARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglUniform2iARB(location, v0, v1, l);
    }

    static native void nglUniform2iARB(int var0, int var1, int var2, long var3);

    public static void glUniform3iARB(int location, int v0, int v1, int v2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform3iARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglUniform3iARB(location, v0, v1, v2, l);
    }

    static native void nglUniform3iARB(int var0, int var1, int var2, int var3, long var4);

    public static void glUniform4iARB(int location, int v0, int v1, int v2, int v3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform4iARB;
        BufferChecks.checkFunctionAddress(l);
        ARBShaderObjects.nglUniform4iARB(location, v0, v1, v2, v3, l);
    }

    static native void nglUniform4iARB(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glUniform1ARB(int location, FloatBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform1fvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform1fvARB(location, values.remaining(), MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform1fvARB(int var0, int var1, long var2, long var4);

    public static void glUniform2ARB(int location, FloatBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform2fvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform2fvARB(location, values.remaining() >> 1, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform2fvARB(int var0, int var1, long var2, long var4);

    public static void glUniform3ARB(int location, FloatBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform3fvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform3fvARB(location, values.remaining() / 3, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform3fvARB(int var0, int var1, long var2, long var4);

    public static void glUniform4ARB(int location, FloatBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform4fvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform4fvARB(location, values.remaining() >> 2, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform4fvARB(int var0, int var1, long var2, long var4);

    public static void glUniform1ARB(int location, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform1ivARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform1ivARB(location, values.remaining(), MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform1ivARB(int var0, int var1, long var2, long var4);

    public static void glUniform2ARB(int location, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform2ivARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform2ivARB(location, values.remaining() >> 1, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform2ivARB(int var0, int var1, long var2, long var4);

    public static void glUniform3ARB(int location, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform3ivARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform3ivARB(location, values.remaining() / 3, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform3ivARB(int var0, int var1, long var2, long var4);

    public static void glUniform4ARB(int location, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform4ivARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform4ivARB(location, values.remaining() >> 2, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform4ivARB(int var0, int var1, long var2, long var4);

    public static void glUniformMatrix2ARB(int location, boolean transpose, FloatBuffer matrices) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix2fvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(matrices);
        ARBShaderObjects.nglUniformMatrix2fvARB(location, matrices.remaining() >> 2, transpose, MemoryUtil.getAddress(matrices), l);
    }

    static native void nglUniformMatrix2fvARB(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix3ARB(int location, boolean transpose, FloatBuffer matrices) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix3fvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(matrices);
        ARBShaderObjects.nglUniformMatrix3fvARB(location, matrices.remaining() / 9, transpose, MemoryUtil.getAddress(matrices), l);
    }

    static native void nglUniformMatrix3fvARB(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix4ARB(int location, boolean transpose, FloatBuffer matrices) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix4fvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(matrices);
        ARBShaderObjects.nglUniformMatrix4fvARB(location, matrices.remaining() >> 4, transpose, MemoryUtil.getAddress(matrices), l);
    }

    static native void nglUniformMatrix4fvARB(int var0, int var1, boolean var2, long var3, long var5);

    public static void glGetObjectParameterARB(int obj, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetObjectParameterfvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        ARBShaderObjects.nglGetObjectParameterfvARB(obj, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetObjectParameterfvARB(int var0, int var1, long var2, long var4);

    public static float glGetObjectParameterfARB(int obj, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetObjectParameterfvARB;
        BufferChecks.checkFunctionAddress(l);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        ARBShaderObjects.nglGetObjectParameterfvARB(obj, pname, MemoryUtil.getAddress(floatBuffer), l);
        return floatBuffer.get(0);
    }

    public static void glGetObjectParameterARB(int obj, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetObjectParameterivARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetObjectParameterivARB(int var0, int var1, long var2, long var4);

    public static int glGetObjectParameteriARB(int obj, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetObjectParameterivARB;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetInfoLogARB(int obj, IntBuffer length, ByteBuffer infoLog) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetInfoLogARB;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(infoLog);
        ARBShaderObjects.nglGetInfoLogARB(obj, infoLog.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(infoLog), l);
    }

    static native void nglGetInfoLogARB(int var0, int var1, long var2, long var4, long var6);

    public static String glGetInfoLogARB(int obj, int maxLength) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetInfoLogARB;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetAttachedObjectsARB(int containerObj, IntBuffer count, IntBuffer obj) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetAttachedObjectsARB;
        BufferChecks.checkFunctionAddress(l);
        if (count != null) {
            BufferChecks.checkBuffer(count, 1);
        }
        BufferChecks.checkDirect(obj);
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, obj.remaining(), MemoryUtil.getAddressSafe(count), MemoryUtil.getAddress(obj), l);
    }

    static native void nglGetAttachedObjectsARB(int var0, int var1, long var2, long var4, long var6);

    public static int glGetUniformLocationARB(int programObj, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformLocationARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        BufferChecks.checkNullTerminated(name);
        int n = ARBShaderObjects.nglGetUniformLocationARB(programObj, MemoryUtil.getAddress(name), l);
        return n;
    }

    static native int nglGetUniformLocationARB(int var0, long var1, long var3);

    public static int glGetUniformLocationARB(int programObj, CharSequence name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformLocationARB;
        BufferChecks.checkFunctionAddress(l);
        int n = ARBShaderObjects.nglGetUniformLocationARB(programObj, APIUtil.getBufferNT(contextCapabilities, name), l);
        return n;
    }

    public static void glGetActiveUniformARB(int programObj, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveUniformARB;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkBuffer(size, 1);
        BufferChecks.checkBuffer(type, 1);
        BufferChecks.checkDirect(name);
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, name.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(size), MemoryUtil.getAddress(type), MemoryUtil.getAddress(name), l);
    }

    static native void nglGetActiveUniformARB(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetActiveUniformARB(int programObj, int index, int maxLength, IntBuffer sizeType) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveUniformARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(sizeType, 2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(sizeType), MemoryUtil.getAddress(sizeType, sizeType.position() + 1), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static String glGetActiveUniformARB(int programObj, int index, int maxLength) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveUniformARB;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress0(APIUtil.getBufferInt(contextCapabilities)), MemoryUtil.getAddress(APIUtil.getBufferInt(contextCapabilities), 1), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static int glGetActiveUniformSizeARB(int programObj, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveUniformARB;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, 0, 0L, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer, 1), APIUtil.getBufferByte0(contextCapabilities), l);
        return intBuffer.get(0);
    }

    public static int glGetActiveUniformTypeARB(int programObj, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveUniformARB;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, 0, 0L, MemoryUtil.getAddress(intBuffer, 1), MemoryUtil.getAddress(intBuffer), APIUtil.getBufferByte0(contextCapabilities), l);
        return intBuffer.get(0);
    }

    public static void glGetUniformARB(int programObj, int location, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformfvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetUniformfvARB(int var0, int var1, long var2, long var4);

    public static void glGetUniformARB(int programObj, int location, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformivARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        ARBShaderObjects.nglGetUniformivARB(programObj, location, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetUniformivARB(int var0, int var1, long var2, long var4);

    public static void glGetShaderSourceARB(int obj, IntBuffer length, ByteBuffer source) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetShaderSourceARB;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(source);
        ARBShaderObjects.nglGetShaderSourceARB(obj, source.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(source), l);
    }

    static native void nglGetShaderSourceARB(int var0, int var1, long var2, long var4, long var6);

    public static String glGetShaderSourceARB(int obj, int maxLength) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetShaderSourceARB;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }
}

