/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class ATIVertexArrayObject {
    public static final int GL_STATIC_ATI = 34656;
    public static final int GL_DYNAMIC_ATI = 34657;
    public static final int GL_PRESERVE_ATI = 34658;
    public static final int GL_DISCARD_ATI = 34659;
    public static final int GL_OBJECT_BUFFER_SIZE_ATI = 34660;
    public static final int GL_OBJECT_BUFFER_USAGE_ATI = 34661;
    public static final int GL_ARRAY_OBJECT_BUFFER_ATI = 34662;
    public static final int GL_ARRAY_OBJECT_OFFSET_ATI = 34663;

    private ATIVertexArrayObject() {
    }

    public static int glNewObjectBufferATI(int pPointer_size, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNewObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        int n = ATIVertexArrayObject.nglNewObjectBufferATI(pPointer_size, 0L, usage, l);
        return n;
    }

    public static int glNewObjectBufferATI(ByteBuffer pPointer, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNewObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pPointer);
        int n = ATIVertexArrayObject.nglNewObjectBufferATI(pPointer.remaining(), MemoryUtil.getAddress(pPointer), usage, l);
        return n;
    }

    public static int glNewObjectBufferATI(DoubleBuffer pPointer, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNewObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pPointer);
        int n = ATIVertexArrayObject.nglNewObjectBufferATI(pPointer.remaining() << 3, MemoryUtil.getAddress(pPointer), usage, l);
        return n;
    }

    public static int glNewObjectBufferATI(FloatBuffer pPointer, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNewObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pPointer);
        int n = ATIVertexArrayObject.nglNewObjectBufferATI(pPointer.remaining() << 2, MemoryUtil.getAddress(pPointer), usage, l);
        return n;
    }

    public static int glNewObjectBufferATI(IntBuffer pPointer, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNewObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pPointer);
        int n = ATIVertexArrayObject.nglNewObjectBufferATI(pPointer.remaining() << 2, MemoryUtil.getAddress(pPointer), usage, l);
        return n;
    }

    public static int glNewObjectBufferATI(ShortBuffer pPointer, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glNewObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pPointer);
        int n = ATIVertexArrayObject.nglNewObjectBufferATI(pPointer.remaining() << 1, MemoryUtil.getAddress(pPointer), usage, l);
        return n;
    }

    static native int nglNewObjectBufferATI(int var0, long var1, int var3, long var4);

    public static boolean glIsObjectBufferATI(int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = ATIVertexArrayObject.nglIsObjectBufferATI(buffer, l);
        return bl;
    }

    static native boolean nglIsObjectBufferATI(int var0, long var1);

    public static void glUpdateObjectBufferATI(int buffer, int offset, ByteBuffer pPointer, int preserve) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUpdateObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pPointer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(buffer, offset, pPointer.remaining(), MemoryUtil.getAddress(pPointer), preserve, l);
    }

    public static void glUpdateObjectBufferATI(int buffer, int offset, DoubleBuffer pPointer, int preserve) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUpdateObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pPointer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(buffer, offset, pPointer.remaining() << 3, MemoryUtil.getAddress(pPointer), preserve, l);
    }

    public static void glUpdateObjectBufferATI(int buffer, int offset, FloatBuffer pPointer, int preserve) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUpdateObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pPointer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(buffer, offset, pPointer.remaining() << 2, MemoryUtil.getAddress(pPointer), preserve, l);
    }

    public static void glUpdateObjectBufferATI(int buffer, int offset, IntBuffer pPointer, int preserve) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUpdateObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pPointer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(buffer, offset, pPointer.remaining() << 2, MemoryUtil.getAddress(pPointer), preserve, l);
    }

    public static void glUpdateObjectBufferATI(int buffer, int offset, ShortBuffer pPointer, int preserve) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUpdateObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pPointer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(buffer, offset, pPointer.remaining() << 1, MemoryUtil.getAddress(pPointer), preserve, l);
    }

    static native void nglUpdateObjectBufferATI(int var0, int var1, int var2, long var3, int var5, long var6);

    public static void glGetObjectBufferATI(int buffer, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetObjectBufferfvATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        ATIVertexArrayObject.nglGetObjectBufferfvATI(buffer, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetObjectBufferfvATI(int var0, int var1, long var2, long var4);

    public static void glGetObjectBufferATI(int buffer, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetObjectBufferivATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        ATIVertexArrayObject.nglGetObjectBufferivATI(buffer, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetObjectBufferivATI(int var0, int var1, long var2, long var4);

    public static int glGetObjectBufferiATI(int buffer, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetObjectBufferivATI;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ATIVertexArrayObject.nglGetObjectBufferivATI(buffer, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glFreeObjectBufferATI(int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFreeObjectBufferATI;
        BufferChecks.checkFunctionAddress(l);
        ATIVertexArrayObject.nglFreeObjectBufferATI(buffer, l);
    }

    static native void nglFreeObjectBufferATI(int var0, long var1);

    public static void glArrayObjectATI(int array, int size, int type, int stride, int buffer, int offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glArrayObjectATI;
        BufferChecks.checkFunctionAddress(l);
        ATIVertexArrayObject.nglArrayObjectATI(array, size, type, stride, buffer, offset, l);
    }

    static native void nglArrayObjectATI(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glGetArrayObjectATI(int array, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetArrayObjectfvATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        ATIVertexArrayObject.nglGetArrayObjectfvATI(array, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetArrayObjectfvATI(int var0, int var1, long var2, long var4);

    public static void glGetArrayObjectATI(int array, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetArrayObjectivATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        ATIVertexArrayObject.nglGetArrayObjectivATI(array, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetArrayObjectivATI(int var0, int var1, long var2, long var4);

    public static void glVariantArrayObjectATI(int id, int type, int stride, int buffer, int offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVariantArrayObjectATI;
        BufferChecks.checkFunctionAddress(l);
        ATIVertexArrayObject.nglVariantArrayObjectATI(id, type, stride, buffer, offset, l);
    }

    static native void nglVariantArrayObjectATI(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glGetVariantArrayObjectATI(int id, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVariantArrayObjectfvATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        ATIVertexArrayObject.nglGetVariantArrayObjectfvATI(id, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetVariantArrayObjectfvATI(int var0, int var1, long var2, long var4);

    public static void glGetVariantArrayObjectATI(int id, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVariantArrayObjectivATI;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        ATIVertexArrayObject.nglGetVariantArrayObjectivATI(id, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetVariantArrayObjectivATI(int var0, int var1, long var2, long var4);
}

